/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.statistics.fus;

import com.intellij.jupyter.core.core.impl.actions.run.NotebookRunAllAction;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterRestartKernelAction;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerPerFileService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.statistics.fus.KotlinNotebookFeatureUsagesCollector;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kotlin/jupyter/core/statistics/fus/KotlinNotebookFusActionListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "beforeActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookFusActionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookFusActionListener.kt\ncom/intellij/kotlin/jupyter/core/statistics/fus/KotlinNotebookFusActionListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class KotlinNotebookFusActionListener
implements AnActionListener {
    public void beforeActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        AnAction anAction = action;
        if (anAction instanceof JupyterRestartKernelAction) {
            BackedNotebookVirtualFile backedNotebookVirtualFile = KotlinNotebookFusActionListener.beforeActionPerformed$getBackedFile(event);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile backedFile = backedNotebookVirtualFile;
            JupyterCompilerPerFileService compilerService = JupyterCompilerService.Companion.getForFile(project2, backedFile);
            int cellCountBeforeRestart = compilerService.getExecutedCellsCount();
            int classpathSizeBeforeRestart = compilerService.getCurrentClasspath().size();
            KotlinNotebookFeatureUsagesCollector.Companion.registerKernelRestart(project2, cellCountBeforeRestart, classpathSizeBeforeRestart);
        } else if (anAction instanceof NotebookRunAllAction) {
            BackedNotebookVirtualFile backedNotebookVirtualFile = KotlinNotebookFusActionListener.beforeActionPerformed$getBackedFile(event);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile backedFile = backedNotebookVirtualFile;
            JupyterNotebook jupyterNotebook = backedFile.getNotebookOrNull();
            int cellCountToRun = jupyterNotebook != null ? jupyterNotebook.cellsCount() : -1;
            KotlinNotebookFeatureUsagesCollector.Companion.registerRunAllCells(project2, cellCountToRun);
        }
    }

    private static final BackedNotebookVirtualFile beforeActionPerformed$getBackedFile(AnActionEvent $event) {
        BackedNotebookVirtualFile backedFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile;
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)$event);
        if (backedNotebookVirtualFile2 == null) {
            return null;
        }
        BackedNotebookVirtualFile it = backedNotebookVirtualFile = (backedFile = backedNotebookVirtualFile2);
        boolean bl = false;
        return IsKotlinNotebookKt.isKotlinNotebook(it.getFile()) ? backedNotebookVirtualFile : null;
    }
}

