/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.toolwindow;

import com.intellij.openapi.module.Module;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class SpringMvcViewUtils {
    public static boolean processUrls(Module module, @Nullable SpringBeanPointer<?> controllerSpringBeanPointer, Set<RequestMethod> requestMethods, Processor<? super UrlMappingElement> processor) {
        boolean foundMatch = false;
        for (UrlMappingElement variant : SpringMvcUtils.getUrlMappings(module)) {
            if (!SpringMvcViewUtils.matchesSelectedController(controllerSpringBeanPointer, variant) || !SpringMvcViewUtils.matchesRequestMethod(requestMethods, variant)) continue;
            foundMatch = true;
            if (processor.process((Object)variant)) continue;
            return false;
        }
        return !foundMatch;
    }

    private static boolean matchesSelectedController(@Nullable SpringBeanPointer<?> controllerSpringBeanPointer, UrlMappingElement variant) {
        if (controllerSpringBeanPointer == null) {
            return true;
        }
        return variant.isDefinedInBean(controllerSpringBeanPointer);
    }

    private static boolean matchesRequestMethod(Set<RequestMethod> requestMethods, UrlMappingElement variant) {
        if (variant.getMethod().length == 0) {
            return true;
        }
        for (RequestMethod method : variant.getMethod()) {
            if (!requestMethods.contains((Object)method)) continue;
            return true;
        }
        return false;
    }
}

