/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import org.jetbrains.annotations.NotNull;

public class CssConvertColorToRgbInspection
extends CssBaseInspection {
    @NotNull
    public String getShortName() {
        return "CssConvertColorToRgbInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssConvertColorToRgbInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(this){

            public void visitCssTerm(CssTerm _term) {
                super.visitCssTerm(_term);
                if (CssTermTypes.COLOR == _term.getTermType() && !CssConvertColorToRgbInspection.isColorFunction((PsiElement)_term)) {
                    holder.registerProblem((PsiElement)_term, CssBundle.message((String)"css.convert.color.value.to.rgb", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{CssFixFactory.getInstance().convertToRgbQuickFix()});
                }
            }
        };
    }

    private static boolean isColorFunction(PsiElement element) {
        if (element instanceof CssTerm && CssTermTypes.COLOR == ((CssTerm)element).getTermType()) {
            ColorDeclarationType type = ColorDeclarationType.fromColorTerm((PsiElement)element);
            return type == ColorDeclarationType.RGB || type == ColorDeclarationType.RGBA;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssConvertColorToRgbInspection", "buildVisitor"));
    }
}

