/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.Bottom;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTypeMapper
extends PsiTypeVisitorEx<PsiType> {
    protected static final Logger LOG = Logger.getInstance(PsiTypeMapper.class);

    @Nullable
    public <T extends PsiType> T mapType(@NotNull T type) {
        if (type == null) {
            PsiTypeMapper.$$$reportNull$$$0(0);
        }
        return (T)type.accept(this);
    }

    @Override
    public PsiType visitArrayType(@NotNull PsiArrayType type) {
        PsiType componentType;
        PsiType mappedComponent;
        if (type == null) {
            PsiTypeMapper.$$$reportNull$$$0(1);
        }
        if ((mappedComponent = this.mapType(componentType = type.getComponentType())) == null) {
            return null;
        }
        if (mappedComponent == componentType) {
            return type;
        }
        return new PsiArrayType(mappedComponent, type.getAnnotationProvider());
    }

    @Override
    public PsiType visitEllipsisType(@NotNull PsiEllipsisType type) {
        PsiType componentType;
        PsiType mappedComponent;
        if (type == null) {
            PsiTypeMapper.$$$reportNull$$$0(2);
        }
        if ((mappedComponent = this.mapType(componentType = type.getComponentType())) == null) {
            return null;
        }
        if (mappedComponent == componentType) {
            return type;
        }
        return new PsiEllipsisType(mappedComponent, type.getAnnotationProvider());
    }

    @Override
    public PsiType visitTypeVariable(@NotNull PsiTypeVariable var) {
        if (var == null) {
            PsiTypeMapper.$$$reportNull$$$0(3);
        }
        return var;
    }

    @Override
    public PsiType visitBottom(@NotNull Bottom bottom) {
        if (bottom == null) {
            PsiTypeMapper.$$$reportNull$$$0(4);
        }
        return bottom;
    }

    @Override
    public PsiType visitCapturedWildcardType(@NotNull PsiCapturedWildcardType type) {
        if (type == null) {
            PsiTypeMapper.$$$reportNull$$$0(5);
        }
        return type;
    }

    @Override
    public abstract PsiType visitClassType(@NotNull PsiClassType var1);

    @Override
    public PsiType visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        if (primitiveType == null) {
            PsiTypeMapper.$$$reportNull$$$0(6);
        }
        return primitiveType;
    }

    @Override
    public PsiType visitType(@NotNull PsiType type) {
        if (type == null) {
            PsiTypeMapper.$$$reportNull$$$0(7);
        }
        LOG.error("No visit* methods were calleed for " + type);
        return null;
    }

    @Override
    public PsiType visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        if (wildcardType == null) {
            PsiTypeMapper.$$$reportNull$$$0(8);
        }
        PsiType bound = wildcardType.getBound();
        PsiManager manager = wildcardType.getManager();
        if (bound == null) {
            return PsiWildcardType.createUnbounded(manager);
        }
        if ((bound = this.mapType(bound)) == null) {
            return null;
        }
        return wildcardType.isExtends() ? PsiWildcardType.createExtends(manager, bound) : PsiWildcardType.createSuper(manager, bound);
    }

    @Override
    @Nullable
    public PsiType visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
        if (intersectionType == null) {
            PsiTypeMapper.$$$reportNull$$$0(9);
        }
        SmartList substituted = new SmartList();
        for (PsiType component : intersectionType.getConjuncts()) {
            PsiType mapped = this.mapType(component);
            if (mapped == null) {
                return null;
            }
            substituted.add(mapped);
        }
        return PsiIntersectionType.createIntersection(false, substituted.toArray(PsiType.EMPTY_ARRAY));
    }

    @Override
    public PsiType visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
        if (disjunctionType == null) {
            PsiTypeMapper.$$$reportNull$$$0(10);
        }
        SmartList substituted = new SmartList();
        for (PsiType component : disjunctionType.getDisjunctions()) {
            PsiType mapped = this.mapType(component);
            if (mapped == null) {
                return null;
            }
            substituted.add(mapped);
        }
        return disjunctionType.newDisjunctionType((List<PsiType>)substituted);
    }

    @Override
    public PsiType visitDiamondType(@NotNull PsiDiamondType diamondType) {
        if (diamondType == null) {
            PsiTypeMapper.$$$reportNull$$$0(11);
        }
        return diamondType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottom";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wildcardType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersectionType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disjunctionType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diamondType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/PsiTypeMapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mapType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEllipsisType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeVariable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBottom";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCapturedWildcardType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrimitiveType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWildcardType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIntersectionType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDisjunctionType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDiamondType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

