/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.stubs.JSFrameworkMarkersIndex;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStubBase<PsiT extends JSElement>
extends StubBase<PsiT>
implements JSStubElement<PsiT> {
    private static final Key<Set<String>> FRAMEWORK_MARKERS = Key.create((String)"framework.markers");
    private final int myFlags;

    protected JSStubBase(@NotNull PsiT psi, @Nullable StubElement parent, @NotNull IElementType elementType) {
        if (psi == null) {
            JSStubBase.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            JSStubBase.$$$reportNull$$$0(1);
        }
        this(psi, parent, elementType, 0);
    }

    protected JSStubBase(@NotNull PsiT psi, @Nullable StubElement parent, @NotNull IElementType elementType, int childFlags) {
        if (psi == null) {
            JSStubBase.$$$reportNull$$$0(2);
        }
        if (elementType == null) {
            JSStubBase.$$$reportNull$$$0(3);
        }
        super(parent, elementType);
        Set<String> elements = JSStubBase.getFrameworkMarkers(psi);
        if (!elements.isEmpty()) {
            this.putUserData(FRAMEWORK_MARKERS, elements);
        }
        this.myFlags = childFlags;
    }

    @ApiStatus.Obsolete
    protected JSStubBase(StubElement parent, @NotNull IElementType elementType, int childFlags) {
        if (elementType == null) {
            JSStubBase.$$$reportNull$$$0(4);
        }
        super(parent, elementType);
        this.myFlags = childFlags;
    }

    protected JSStubBase(@NotNull StubInputStream dataStream, @Nullable StubElement parentStub, @NotNull IElementType elementType) throws IOException {
        if (dataStream == null) {
            JSStubBase.$$$reportNull$$$0(5);
        }
        if (elementType == null) {
            JSStubBase.$$$reportNull$$$0(6);
        }
        super(parentStub, elementType);
        int flagsSize = this.getFlagsStructure().size();
        assert (flagsSize <= 32) : ((Object)((Object)this)).getClass();
        this.myFlags = flagsSize == 0 ? 0 : DataInputOutputUtil.readINT((DataInput)dataStream);
    }

    public void serialize(StubOutputStream dataStream) throws IOException {
        if (this.getFlagsStructure().size() > 0) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myFlags);
        }
    }

    protected static void writeString(StringRef ref2, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(StringRef.toString((StringRef)ref2));
    }

    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FlagsStructure.EMPTY;
        if (flagsStructure == null) {
            JSStubBase.$$$reportNull$$$0(7);
        }
        return flagsStructure;
    }

    public void index(@NotNull IndexSink sink) {
        Set markers;
        if (sink == null) {
            JSStubBase.$$$reportNull$$$0(8);
        }
        if ((markers = (Set)this.getUserData(FRAMEWORK_MARKERS)) != null) {
            for (String marker : markers) {
                JSFrameworkMarkersIndex.index(marker, sink);
            }
        }
    }

    protected <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return (T)IntFlagsSerializer.INSTANCE.readValue(this.getFlagsStructure(), structureElement, this.myFlags);
    }

    @Contract(pure=true)
    protected static <T> int writeFlag(int flags, @NotNull FlagsStructure flagsStructure, @NotNull FlagsStructureElement<T> structureElement, T value) {
        if (flagsStructure == null) {
            JSStubBase.$$$reportNull$$$0(9);
        }
        if (structureElement == null) {
            JSStubBase.$$$reportNull$$$0(10);
        }
        return IntFlagsSerializer.INSTANCE.writeValue(flagsStructure, structureElement, value, flags);
    }

    @NotNull
    private static Set<String> getFrameworkMarkers(@NotNull JSElement element2) {
        if (element2 == null) {
            JSStubBase.$$$reportNull$$$0(11);
        }
        HashSet result2 = null;
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            List keys = handler.getMarkers((PsiElement)element2);
            if (keys.isEmpty()) continue;
            if (result2 == null) {
                result2 = new HashSet();
            }
            result2.addAll(keys);
        }
        Set<String> set = result2 == null ? Collections.emptySet() : result2;
        if (set == null) {
            JSStubBase.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagsStructure";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeFlag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkMarkers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12 -> new IllegalStateException(string);
        };
    }
}

