/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.filter;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.MultiMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"getDtsDuplicates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "candidates", "", "isFromInternalModule", "", "elementToImport", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.backend"})
public final class SimilarModulesFilterKt {
    private static final Set<JSImportCandidate> getDtsDuplicates(List<? extends JSImportCandidate> candidates) {
        Set uniqueTsFiles = new LinkedHashSet();
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        MultiMap elementsFromDts = multiMap;
        for (JSImportCandidate jSImportCandidate : candidates) {
            String pathWithoutExtension;
            String extension;
            String path2;
            VirtualFile file;
            if (PsiUtilCore.getVirtualFile((PsiElement)jSImportCandidate.getElement()) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)file.getPath(), (String)"getPath(...)");
            if (JSFileReferencesUtil.findImplicitExtension((String)path2) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)JSFileReferencesUtil.trimExistingExtension((String)path2, (String)extension), (String)"trimExistingExtension(...)");
            String string = extension;
            Intrinsics.checkNotNullExpressionValue((Object)TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS, (String)"TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS");
            if (ArraysKt.contains((Object[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS, (Object)string)) {
                uniqueTsFiles.add(pathWithoutExtension);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS, (String)"TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS");
            if (!ArraysKt.contains((Object[])TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS, (Object)string)) continue;
            elementsFromDts.putValue((Object)pathWithoutExtension, (Object)jSImportCandidate);
        }
        if (elementsFromDts.isEmpty() || uniqueTsFiles.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set set = elementsFromDts.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        return SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), arg_0 -> SimilarModulesFilterKt.getDtsDuplicates$lambda$0(uniqueTsFiles, arg_0)), SimilarModulesFilterKt::getDtsDuplicates$lambda$1));
    }

    private static final boolean isFromInternalModule(PsiElement elementToImport) {
        JSElement scope2 = ES6PsiUtil.getExportScope((PsiElement)elementToImport);
        return scope2 instanceof TypeScriptModule && ((TypeScriptModule)scope2).isInternal();
    }

    private static final boolean getDtsDuplicates$lambda$0(Set $uniqueTsFiles, Map.Entry it) {
        return $uniqueTsFiles.contains(it.getKey());
    }

    private static final Iterable getDtsDuplicates$lambda$1(Map.Entry it) {
        Object v = it.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
        return (Iterable)v;
    }

    public static final /* synthetic */ Set access$getDtsDuplicates(List candidates) {
        return SimilarModulesFilterKt.getDtsDuplicates(candidates);
    }

    public static final /* synthetic */ boolean access$isFromInternalModule(PsiElement elementToImport) {
        return SimilarModulesFilterKt.isFromInternalModule(elementToImport);
    }
}

