/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFileNameMismatchIntentionBase
extends JavaScriptIntention {
    @Nullable
    protected String myName = null;
    @Nullable
    protected String myFileName = null;
    @Nullable
    protected String myEntityDesc = null;
    @Nullable
    protected String myEntityName = null;

    @Nullable
    static JSQualifiedNamedElement findNamedElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(0);
        }
        if (element2 instanceof PsiWhiteSpace) {
            element2 = element2.getPrevSibling();
        }
        if (PsiUtilCore.getElementType((PsiElement)element2) != JSTokenTypes.IDENTIFIER) {
            return null;
        }
        PsiElement parent = element2.getParent();
        return (parent instanceof JSClass || parent instanceof JSFunctionDeclaration || parent instanceof JSVariable) && ((JSQualifiedNamedElement)parent).getNameIdentifier() == element2 ? (JSQualifiedNamedElement)parent : null;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        JSQualifiedNamedElement jsElement;
        if (project == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(2);
        }
        if (!JSFileNameMismatchIntentionBase.isTopLevelDeclaration((PsiElement)(jsElement = JSFileNameMismatchIntentionBase.findNamedElement(element2))) || JSNameSuggestionsUtil.matchesFileNameByCodeStyle((JSNamedElement)jsElement)) {
            return false;
        }
        this.myName = jsElement.getName();
        if (this.myName == null) {
            return false;
        }
        PsiFile file = jsElement.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String withoutExtension = JSNameSuggestionsUtil.fileNameFromElementName((JSNamedElement)jsElement, this.myName);
        if (withoutExtension == null) {
            return false;
        }
        this.myFileName = withoutExtension + "." + virtualFile.getExtension();
        JSNamedElementPresenter presenter = new JSNamedElementPresenter((PsiElement)jsElement);
        this.myEntityDesc = presenter.describeWithShortName();
        this.myEntityName = presenter.describeElementKind();
        return true;
    }

    @Contract(value="null -> false")
    private static boolean isTopLevelDeclaration(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        PsiElement parent = element2.getParent();
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFile) {
            return true;
        }
        return parent instanceof ES6ExportDefaultAssignment && parent.getParent() instanceof JSFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/JSFileNameMismatchIntentionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findNamedElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

