/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/inspections/UnterminatedStatementJSInspectionSettingsListener;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.backend"})
public final class UnterminatedStatementJSInspectionSettingsListener
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = CodeStyleSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new CodeStyleSettingsListener(project){
            private volatile Map<String, Boolean> settingStatus;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                this.settingStatus = this.readSettingStatus();
            }

            public void codeStyleSettingsChanged(CodeStyleSettingsChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!Intrinsics.areEqual((Object)event.getProject(), (Object)this.$project)) {
                    return;
                }
                Map<String, Boolean> newSettingStatus = this.readSettingStatus();
                if (!Intrinsics.areEqual(newSettingStatus, this.settingStatus)) {
                    this.settingStatus = newSettingStatus;
                    DaemonCodeAnalyzer.getInstance((Project)this.$project).restart((Object)"UnterminatedStatementJSInspectionSettingsListener.codeStyleChanged");
                }
            }

            /*
             * WARNING - void declaration
             */
            private final Map<String, Boolean> readSettingStatus() {
                void $this$associateTo$iv$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$mapTo$iv$iv;
                CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
                CodeStyleSettings settings = codeStyleSettings;
                List list = LanguageCodeStyleSettingsProvider.getAllProviders();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllProviders(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LanguageCodeStyleSettingsProvider languageCodeStyleSettingsProvider = (LanguageCodeStyleSettingsProvider)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getLanguage());
                }
                Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$filterIsInstance = false;
                $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JSLanguageDialect)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$associate$iv = (List)destination$iv$iv;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv2;
                    JSLanguageDialect lang = (JSLanguageDialect)element$iv$iv;
                    boolean bl = false;
                    CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass((Language)((Language)lang)));
                    Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
                    JSCodeStyleSettings customSettings = (JSCodeStyleSettings)customCodeStyleSettings;
                    Pair pair = TuplesKt.to((Object)lang.getID(), (Object)customSettings.USE_SEMICOLON_AFTER_STATEMENT);
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                return destination$iv$iv2;
            }
        });
        return Unit.INSTANCE;
    }
}

