/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.InheritorsCodeVisionProvider;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.highlighting.JSBasicGutterIconNavigationHandler;
import com.intellij.lang.javascript.highlighting.JavaScriptLineMarkerProvider;
import com.intellij.lang.javascript.hints.JSCodeVisionLocationKind;
import com.intellij.lang.javascript.hints.JSCodeVisionLocations;
import com.intellij.lang.javascript.hints.JSCodeVisionUsageCollector;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.Query;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0017\u0010\u000f\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\fH\u0016R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/intellij/lang/javascript/hints/JSInheritorsCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/InheritorsCodeVisionProvider;", "<init>", "()V", "acceptsFile", "", "file", "Lcom/intellij/psi/PsiFile;", "acceptsElement", "element", "Lcom/intellij/psi/PsiElement;", "getHint", "", "getVisionInfo", "Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$CodeVisionInfo;", "calculateHint", "Lorg/jetbrains/annotations/Nls;", "getHintForSettingsPreview", "handleClick", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "event", "Ljava/awt/event/MouseEvent;", "logClickToFUS", "hint", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "id", "getId", "()Ljava/lang/String;", "intellij.javascript.backend"})
public final class JSInheritorsCodeVisionProvider
extends InheritorsCodeVisionProvider {
    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JSCodeVisionLocations.INSTANCE.acceptsFile(file);
    }

    public boolean acceptsElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return JSCodeVisionLocations.INSTANCE.isImportantLocation(element2);
    }

    @Nullable
    public String getHint(@NotNull PsiElement element2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo codeVisionInfo = this.getVisionInfo(element2, file);
        return codeVisionInfo != null ? codeVisionInfo.getText() : null;
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo preview = this.getHintForSettingsPreview(element2, file);
        if (preview != null) {
            return preview;
        }
        return (CodeVisionProviderBase.CodeVisionInfo)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)element2, () -> JSInheritorsCodeVisionProvider.getVisionInfo$lambda$0(this, element2));
    }

    private final CodeVisionProviderBase.CodeVisionInfo calculateHint(PsiElement element2) {
        if (element2 instanceof JSClass) {
            Query inheritorsClassQuery = JSClassSearch.searchClassInheritors((JSClass)((JSClass)element2), (boolean)true);
            int count = inheritorsClassQuery.findAll().size();
            if (count > 0) {
                Object[] objectArray = new Object[]{count};
                String string = JavaScriptBundle.message((String)"code.vision.inheritors.hint", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return new CodeVisionProviderBase.CodeVisionInfo(string, Integer.valueOf(count), false, 4, null);
            }
        } else if (element2 instanceof JSPsiElementBase) {
            JSClass jSClass = JSUtils.getMemberContainingClass((PsiElement)element2);
            if (jSClass == null) {
                return null;
            }
            JSClass clazz = jSClass;
            Query query = clazz.isInterface() ? JSMembersSearch.searchImplementingMembers((JSPsiElementBase)((JSPsiElementBase)element2), (boolean)true) : JSMembersSearch.searchOverridingMembers((JSPsiElementBase)((JSPsiElementBase)element2), (boolean)true);
            int count = query.findAll().size();
            if (count > 0) {
                String string;
                if (clazz.isInterface()) {
                    var6_9 = new Object[]{count};
                    string = JavaScriptBundle.message((String)"code.vision.implementations.hint", (Object[])var6_9);
                } else {
                    var6_9 = new Object[]{count};
                    string = JavaScriptBundle.message((String)"code.vision.overrides.hint", (Object[])var6_9);
                }
                String string2 = string;
                Intrinsics.checkNotNull((Object)string2);
                return new CodeVisionProviderBase.CodeVisionInfo(string2, Integer.valueOf(count), false, 4, null);
            }
        }
        return null;
    }

    @Nls
    private final CodeVisionProviderBase.CodeVisionInfo getHintForSettingsPreview(PsiElement element2, PsiFile file) {
        if (element2 instanceof JSClass && file.getVirtualFile() == null && Intrinsics.areEqual((Object)((JSClass)element2).getName(), (Object)"MyButton")) {
            String string = file.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"class MyButton { }\nclass AnimatedButton extends MyButton { }")) {
                Object[] objectArray = new Object[]{1};
                String string2 = JavaScriptBundle.message((String)"code.vision.inheritors.hint", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return new CodeVisionProviderBase.CodeVisionInfo(string2, Integer.valueOf(1), false, 4, null);
            }
        }
        return null;
    }

    public void handleClick(@NotNull Editor editor, @NotNull PsiElement element2, @Nullable MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof JSClass) {
            JSBasicGutterIconNavigationHandler<JSClass> jSBasicGutterIconNavigationHandler;
            if (((JSClass)element2).isInterface()) {
                JSBasicGutterIconNavigationHandler<JSClass> jSBasicGutterIconNavigationHandler2 = JavaScriptLineMarkerProvider.ourClassInheritorsNavHandler;
                jSBasicGutterIconNavigationHandler = jSBasicGutterIconNavigationHandler2;
                Intrinsics.checkNotNullExpressionValue(jSBasicGutterIconNavigationHandler2, (String)"ourClassInheritorsNavHandler");
            } else {
                JSBasicGutterIconNavigationHandler<JSClass> jSBasicGutterIconNavigationHandler3 = JavaScriptLineMarkerProvider.ourInterfaceImplementationsNavHandler;
                jSBasicGutterIconNavigationHandler = jSBasicGutterIconNavigationHandler3;
                Intrinsics.checkNotNullExpressionValue(jSBasicGutterIconNavigationHandler3, (String)"ourInterfaceImplementationsNavHandler");
            }
            JSBasicGutterIconNavigationHandler<JSClass> navigationHandler = jSBasicGutterIconNavigationHandler;
            PsiElement nameIdentifier = ((JSClass)element2).getNameIdentifier();
            if (nameIdentifier != null) {
                navigationHandler.navigate(event, nameIdentifier);
            }
        } else if (element2 instanceof JSPsiElementBase && element2 instanceof JSNamedElement) {
            JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)element2);
            JSBasicGutterIconNavigationHandler<JSPsiElementBase> handler = clazz.isInterface() ? JavaScriptLineMarkerProvider.ourImplementingMembersNavHandler : JavaScriptLineMarkerProvider.ourOverridingMembersNavHandler;
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element2).getNameIdentifier();
            if (nameIdentifier != null) {
                handler.navigate(event, nameIdentifier);
            }
        }
    }

    public void logClickToFUS(@NotNull PsiElement element2, @NotNull String hint2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint2, (String)"hint");
        JSCodeVisionLocationKind jSCodeVisionLocationKind = JSCodeVisionLocations.INSTANCE.getLocationKind$intellij_javascript_backend(element2);
        if (jSCodeVisionLocationKind == null) {
            jSCodeVisionLocationKind = JSCodeVisionLocationKind.OTHER;
        }
        JSCodeVisionLocationKind location = jSCodeVisionLocationKind;
        JSCodeVisionUsageCollector.INSTANCE.getIMPLEMENTATION_CLICKED_EVENT_ID().log(element2.getProject(), (Object)location);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getId() {
        return "js.inheritors";
    }

    private static final CodeVisionProviderBase.CodeVisionInfo getVisionInfo$lambda$0(JSInheritorsCodeVisionProvider this$0, PsiElement $element) {
        return this$0.calculateHint($element);
    }
}

