/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.tns.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ParamEditor;
import com.intellij.database.dataSource.url.TypeDescriptorUi;
import com.intellij.database.dataSource.url.TypesRegistryUi;
import com.intellij.database.dataSource.url.ui.BaseTypeDescriptor;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.dialects.oracle.tns.OraTnsNamesExtractor;
import com.intellij.database.util.DbUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.system.OS;
import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TnsNamesParamEditor
extends ParamEditorBase<TextFieldWithAutoCompletion<String>> {
    private static final String ORACLE_REG_ROOT = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE";
    private final ActionGroup myContextMenu;

    public TnsNamesParamEditor(@NlsContexts.Label @NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(1);
        }
        this(label, interchange, new TnsCompletionProvider(interchange));
    }

    private TnsNamesParamEditor(@NlsContexts.Label @NotNull String label, @NotNull DataInterchange interchange, @NotNull TnsCompletionProvider comp) {
        if (label == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(2);
        }
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(3);
        }
        if (comp == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(4);
        }
        super((JComponent)new TextFieldWithAutoCompletion(interchange.getProject(), (TextFieldWithAutoCompletionListProvider)comp, false, null), interchange, FieldSize.MEDIUM, label, new AnAction[0]);
        this.myContextMenu = new DefaultActionGroup(new AnAction[]{new DumbAwareAction(DatabaseBundle.messagePointer((String)"action.TnsNamesParamEditor.reparse.text", (Object[])new Object[0]), DatabaseBundle.messagePointer((String)"action.TnsNamesParamEditor.reparse.description", (Object[])new Object[0]), AllIcons.Actions.Refresh){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                String tnsadmin = TnsNamesParamEditor.this.getInterchange().getProperty("TNSADMIN_DIR");
                e.getPresentation().setEnabled(tnsadmin != null && TnsNamesParamEditor.hasTnsNamesOra(tnsadmin));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                TnsNamesParamEditor.this.getInterchange().forceUpdateProperty("TNSADMIN_DIR");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }});
        comp.init((Disposable)this);
        interchange.addPersistentProperty("TNSADMIN_DIR");
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).ensureWillComputePreferredSize();
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                TnsNamesParamEditor.this.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$2", "documentChanged"));
            }
        });
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).addSettingsProvider(editor -> editor.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler.Simple(this.myContextMenu)));
    }

    private static boolean hasTnsNamesOra(@Nullable String path) {
        return path != null && new File(path, "tnsnames.ora").exists();
    }

    @Nullable
    private static String getEnvTnsAdminPath() {
        return System.getenv("TNS_ADMIN");
    }

    @Nullable
    private static String getEnvOracleHomePath() {
        String res = System.getenv("ORACLE_HOME");
        return res == null ? null : FileUtil.join((String[])new String[]{res, "network", "admin"});
    }

    @Nullable
    private static String checkRegDefaultHome(@NotNull String defaultHomePath, @NotNull String defaultHomeKey, Function<String, String> ... homeCheckers) {
        String defaultHome;
        if (defaultHomePath == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(5);
        }
        if (defaultHomeKey == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(6);
        }
        if (homeCheckers == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(7);
        }
        if ((defaultHome = WindowsRegistryUtil.readRegistryValue((String)defaultHomePath, (String)defaultHomeKey)) == null) {
            return null;
        }
        for (Function<String, String> checker : homeCheckers) {
            String res = (String)checker.fun((Object)("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\" + defaultHome));
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Nullable
    private static String checkRegOracleHomes(Function<String, String> ... homeCheckers) {
        String res;
        if (homeCheckers == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(8);
        }
        if ((res = TnsNamesParamEditor.checkRegDefaultHome("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\ALL_HOMES", "DEFAULT_HOME", homeCheckers)) != null) {
            return res;
        }
        res = TnsNamesParamEditor.checkRegDefaultHome(ORACLE_REG_ROOT, "DEFAULT_HOME", homeCheckers);
        if (res != null) {
            return res;
        }
        List possibleHomes = WindowsRegistryUtil.readRegistryBranch((String)ORACLE_REG_ROOT);
        for (Function<String, String> checker : homeCheckers) {
            for (String possibleHome : possibleHomes) {
                res = (String)checker.fun((Object)("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\" + possibleHome));
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    @Nullable
    private static String getRegOraclePath() {
        return TnsNamesParamEditor.checkRegOracleHomes(new Function[]{new Function.Mono<String>(){

            public String fun(String homePath) {
                String res = WindowsRegistryUtil.readRegistryValue((String)homePath, (String)"TNS_ADMIN");
                return TnsNamesParamEditor.hasTnsNamesOra(res) ? res : null;
            }
        }, new Function.Mono<String>(){

            public String fun(String homePath) {
                String res = WindowsRegistryUtil.readRegistryValue((String)homePath, (String)"ORACLE_HOME");
                return res != null && TnsNamesParamEditor.hasTnsNamesOra(FileUtil.join((String[])new String[]{res, "network", "admin"})) ? res : null;
            }
        }});
    }

    @Nullable
    private static String findDirectoryWithTnsNamesOra() {
        String res = TnsNamesParamEditor.getEnvTnsAdminPath();
        if (TnsNamesParamEditor.hasTnsNamesOra(res)) {
            return res;
        }
        if (OS.CURRENT == OS.Windows) {
            res = TnsNamesParamEditor.getRegOraclePath();
            if (TnsNamesParamEditor.hasTnsNamesOra(res)) {
                return res;
            }
        } else {
            res = "/etc";
            if (TnsNamesParamEditor.hasTnsNamesOra("/etc")) {
                return res;
            }
        }
        if (TnsNamesParamEditor.hasTnsNamesOra(res = TnsNamesParamEditor.getEnvOracleHomePath())) {
            return res;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = ((TextFieldWithAutoCompletion)this.getEditorComponent()).getText();
        if (string == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(10);
        }
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).setText(text);
    }

    public static Collection<ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(11);
        }
        return Collections.singletonList(new MyTnsAdminField(interchange));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHomePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHomeKey";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeCheckers";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRegDefaultHome";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkRegOracleHomes";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSatellites";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    public static class TnsCompletionProvider
    extends TextFieldWithAutoCompletion.StringsCompletionProvider
    implements PropertyChangeListener {
        @NotNull
        private final DataInterchange myInterchange;
        private String myTnsAdminDir;
        private boolean myComputed;

        public TnsCompletionProvider(@NotNull DataInterchange interchange) {
            if (interchange == null) {
                TnsCompletionProvider.$$$reportNull$$$0(0);
            }
            super(null, null);
            this.myComputed = false;
            this.myInterchange = interchange;
            this.setTnsAdminDir(this.myInterchange.getProperty("TNSADMIN_DIR"));
        }

        void init(@NotNull Disposable parent) {
            if (parent == null) {
                TnsCompletionProvider.$$$reportNull$$$0(1);
            }
            this.myInterchange.addPropertyChangeListener("TNSADMIN_DIR", (PropertyChangeListener)this, parent);
        }

        public void setTnsAdminDir(@Nullable String tnsAdminDir) {
            this.myTnsAdminDir = tnsAdminDir;
            this.reset();
        }

        public void reset() {
            this.myComputed = false;
            this.setItems(null);
        }

        @NotNull
        public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            if (!this.myComputed) {
                ArrayList items = new ArrayList();
                if (this.myTnsAdminDir != null) {
                    try {
                        OraTnsNamesExtractor.extract((File)OraTnsNamesExtractor.getTnsNamesOra((String)this.myTnsAdminDir), s -> items.add(s));
                    }
                    catch (IOException e) {
                        this.myInterchange.putProperty("TNSADMIN_ERROR", e.getMessage());
                    }
                }
                this.setItems(items);
                this.myComputed = true;
            }
            Collection collection = super.getItems(prefix, cached, parameters);
            if (collection == null) {
                TnsCompletionProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setTnsAdminDir((String)evt.getNewValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$TnsCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$TnsCompletionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "init";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyTnsAdminField
    extends TextParamEditor
    implements PropertyChangeListener {
        private static final String TNSADMIN_ERROR = "TNSADMIN_ERROR";
        @NlsSafe
        private static final String TNSADMIN_COLON = "TNSADMIN:";

        MyTnsAdminField(final @NotNull DataInterchange interchange) {
            if (interchange == null) {
                MyTnsAdminField.$$$reportNull$$$0(0);
            }
            super(interchange, TNSADMIN_COLON, FieldSize.LARGE, new AnAction[0]);
            this.setText(StringUtil.notNullize((String)interchange.getProperty("TNSADMIN_DIR")));
            interchange.addPropertyChangeListener("TNSADMIN_DIR", (PropertyChangeListener)this, (Disposable)this);
            interchange.addPropertyChangeListener(TNSADMIN_ERROR, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() == null) {
                        return;
                    }
                    interchange.putProperty(MyTnsAdminField.TNSADMIN_ERROR, null);
                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JBLabel((String)evt.getNewValue())).setFadeoutTime(5000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint((Component)this.getComponent(), new Point()), Balloon.Position.above));
                }
            }, (Disposable)this);
            FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
            descriptor.setHideIgnored(false);
            descriptor.setTitle(DatabaseBundle.message((String)"dialog.title.choose.tnsadmin.directory.location", (Object[])new Object[0]));
            this.addButton((AnAction)new ParamEditorBase.FMChooseAction(descriptor));
            DbUIUtil.invokeLater(() -> this.updateTnsAdmin());
            DefaultActionGroup contextMenu = new DefaultActionGroup(new AnAction[]{new DumbAwareAction(DatabaseBundle.messagePointer((String)"action.MyTnsAdminField.anonymous.text", (Object[])new Object[0]), DatabaseBundle.messagePointer((String)"action.MyTnsAdminField.anonymous.description", (Object[])new Object[0]), AllIcons.Actions.Refresh){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String dir;
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((dir = TnsNamesParamEditor.findDirectoryWithTnsNamesOra()) == null) {
                        JBPopupFactory.getInstance().createBalloonBuilder(HintUtil.createErrorLabel((String)DatabaseBundle.message((String)"hint.text.tnsnames.ora.found", (Object[])new Object[0]))).setFadeoutTime(5000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint((Component)this.getComponent(), new Point()), Balloon.Position.above);
                        return;
                    }
                    this.getInterchange().putProperty("TNSADMIN_DIR", dir);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$MyTnsAdminField$2", "actionPerformed"));
                }
            }});
            PopupHandler.installPopupMenu((JComponent)this.getEditorComponent(), (ActionGroup)contextMenu, (String)"TnsNamesParamPopup");
        }

        private void updateTnsAdmin() {
            String val = this.getInterchange().getProperty("TNSADMIN_DIR");
            boolean newVal = false;
            if (StringUtil.isEmpty((String)val)) {
                val = TnsNamesParamEditor.findDirectoryWithTnsNamesOra();
                boolean bl = newVal = !StringUtil.isEmpty((String)val);
            }
            if (newVal) {
                this.getInterchange().putProperty("TNSADMIN_DIR", val);
            } else {
                this.getInterchange().forceUpdateProperty("TNSADMIN_DIR");
            }
        }

        protected void fireChanged() {
            this.getInterchange().putProperty("TNSADMIN_DIR", StringUtil.nullize((String)this.getText()));
            super.fireChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String text = StringUtil.notNullize((String)((String)evt.getNewValue()));
            if (!this.getText().equals(text)) {
                this.setText(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$MyTnsAdminField", "<init>"));
        }
    }

    static final class Factory
    implements TypesRegistryUi.TypeDescriptorUiFactory {
        Factory() {
        }

        public void createTypeDescriptor(@NotNull Consumer<? super TypeDescriptorUi> consumer) {
            if (consumer == null) {
                Factory.$$$reportNull$$$0(0);
            }
            consumer.consume((Object)new BaseTypeDescriptor(this, "tns_name"){

                @NotNull
                protected ParamEditor createFieldImpl(@NlsContexts.Label @NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
                    if (caption == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (interchange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return new TnsNamesParamEditor(1.formatFieldCaption((String)caption), interchange);
                }

                @NotNull
                public Collection<ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
                    if (interchange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    Collection<ParamEditor> collection = TnsNamesParamEditor.createSatellites(interchange);
                    if (collection == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return collection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "caption";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "interchange";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$Factory$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$Factory$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createSatellites";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createFieldImpl";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "createSatellites";
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 3 -> new IllegalStateException(string);
                    };
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$Factory", "createTypeDescriptor"));
        }
    }
}

