/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabasePluginId;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProviderUi;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.ui.AuthWidgetBuilderImpl;
import com.intellij.database.dataSource.url.ui.PasswordStorageComponent;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.grid.scripting.impl.DataLoaderManager;
import com.intellij.grid.scripting.impl.ScriptedGridDataHookUp;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ProxyCredentialStore;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DatabaseCoreUiServiceImpl
extends DatabaseCoreUiService {
    @Nullable
    public DbElement findElement(@NotNull Project project, @Nullable DasObject o) {
        if (project == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(0);
        }
        return ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDbElement(o);
    }

    @Nullable
    public Boolean firstRowIsHeader(@Nullable VirtualFile file) {
        return file == null ? null : ScriptedGridDataHookUp.ScriptedLoaderFileConfig.Companion.get(file).getFirstRowIsHeader();
    }

    @Nullable
    public CsvFormat getCsvFormat(@Nullable Project project, @Nullable VirtualFile file, boolean detect) {
        if (file == null) {
            return null;
        }
        CsvFormatResolver.FormatGetter[] getters = detect ? (CsvFormatResolver.FormatGetter[])ContainerUtil.ar((Object[])new CsvFormatResolver.FormatGetter[]{CsvFormatResolver.FormatGetter.FILE, CsvFormatResolver.FormatGetter.STATE, CsvFormatResolver.FormatGetter.CONTENT}) : (CsvFormatResolver.FormatGetter[])ContainerUtil.ar((Object[])new CsvFormatResolver.FormatGetter[]{CsvFormatResolver.FormatGetter.FILE, CsvFormatResolver.FormatGetter.STATE});
        return CsvFormatResolver.getFormat((Project)project, (VirtualFile)file, (boolean)true, null, (CsvFormatResolver.FormatGetter[])getters);
    }

    @TestOnly
    public void extractExtensionScripts() throws IOException {
        ExtensionsRootType.getInstance().updatePluginResources(DatabasePluginId.get());
        DataLoaderManager.getInstance().flush();
    }

    @NotNull
    public JBIterable<?> treeChildren(@NotNull Project project, @NotNull Object object, @NotNull ObjectKind kind) {
        BasicNode node;
        if (project == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(1);
        }
        if (object == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(3);
        }
        if ((node = (BasicNode)ObjectUtils.tryCast((Object)object, BasicNode.class)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseCoreUiServiceImpl.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        DvTreeStructureService structure = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
        JBIterable children = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(node1 -> SequenceFun.jbi((Sequence)structure.childrenOf(node1))).withRoot((Object)node)).expandAndSkip(o -> o == node || o instanceof DvTreeLayoutLayer.HostGroup)).bfsTraversal();
        BasicNode family = (BasicNode)children.find(o -> DatabaseCoreUiServiceImpl.getEffectiveFamilyKind(o) == kind);
        JBIterable jBIterable = family == null ? children.filter(o -> o instanceof BasicObjectNode && ((BasicObjectNode)o).getMetaObject().kind == kind) : SequenceFun.jbi((Sequence)structure.childrenOf(family));
        if (jBIterable == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    private static ObjectKind getEffectiveFamilyKind(BasicNode node) {
        return node instanceof FamilyWithId ? ((FamilyWithId)node).getFamilyId().getFakeKind() : ObjectKind.UNKNOWN_OBJECT;
    }

    @Nullable
    public ObjectKind getKindOrFakeKind(@Nullable String code) {
        DvFamilyId.Companion.ensureInitialised();
        return super.getKindOrFakeKind(code);
    }

    @Nullable
    public AuthWidgetBuilder createAuthWidgetBuilder() {
        return new AuthWidgetBuilderImpl();
    }

    @NotNull
    public Executor executor() {
        Executor executor = DatabaseCredentialsUi.EXECUTOR;
        if (executor == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(6);
        }
        return executor;
    }

    public void askCredentials(@NlsContexts.DialogMessage String message, boolean error, DatabaseConnectionConfig config, Project project, DatabaseCredentials dc, boolean unsure) {
        int res2;
        if (unsure && (res2 = Messages.showOkCancelDialog((Project)project, (String)message, (String)DatabaseBundle.message((String)"dialog.title.connecting.to", (Object[])new Object[]{config.getName()}), (String)DatabaseBundle.message((String)"button.change.credentials", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"button.abort", (Object[])new Object[0]), (Icon)Messages.getErrorIcon())) == 2) {
            throw new ProcessCanceledException();
        }
        DatabaseCredentialsAuthProviderUi.askCredentials(message, error, config, project, dc);
    }

    @NotNull
    public <E> JComboBox<E> createComboBox(@NotNull ComboBoxModel<E> model) {
        if (model == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(7);
        }
        return new ComboBox(model);
    }

    @NotNull
    public List<Pair<String, String>> getProxyOptions(@NotNull List<String> extraNonProxyHosts, @Nullable URI uri) {
        HttpConfigurable configurable;
        ArrayList<Pair<String, String>> options;
        if (extraNonProxyHosts == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(8);
        }
        if (!(options = new ArrayList<Pair<String, String>>((configurable = HttpConfigurable.getInstance()).getJvmProperties(true, uri))).isEmpty()) {
            options.add((Pair<String, String>)Pair.create((Object)"http.useProxy", (Object)"true"));
            DatabaseCoreUiServiceImpl.fillNonProxyOptions(extraNonProxyHosts, options, configurable);
        }
        ArrayList<Pair<String, String>> arrayList = options;
        if (arrayList == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public List<Pair<String, String>> getNonProxyOptions(@NotNull List<String> extraNonProxyHosts) {
        if (extraNonProxyHosts == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(10);
        }
        HttpConfigurable configurable = HttpConfigurable.getInstance();
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        DatabaseCoreUiServiceImpl.fillNonProxyOptions(extraNonProxyHosts, options, configurable);
        ArrayList<Pair<String, String>> arrayList = options;
        if (arrayList == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static void fillNonProxyOptions(@NotNull List<String> extraNonProxyHosts, @NotNull List<Pair<String, String>> options, HttpConfigurable configurable) {
        if (extraNonProxyHosts == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(12);
        }
        if (options == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(13);
        }
        List hosts = StringUtil.isEmpty((String)configurable.PROXY_EXCEPTIONS) ? Collections.emptyList() : StringUtil.split((String)configurable.PROXY_EXCEPTIONS, (String)",");
        StringBuilder nonProxy = new StringBuilder();
        StringUtil.join((Iterable)hosts, String::trim, (String)"|", (StringBuilder)nonProxy);
        for (String host : extraNonProxyHosts) {
            if (hosts.contains(host)) continue;
            if (!nonProxy.isEmpty()) {
                nonProxy.append("|");
            }
            nonProxy.append(host);
        }
        if (!nonProxy.isEmpty()) {
            String nonProxyHosts = nonProxy.toString();
            options.add((Pair<String, String>)Pair.create((Object)"http.nonProxyHosts", (Object)nonProxyHosts));
            options.add((Pair<String, String>)Pair.create((Object)"https.nonProxyHosts", (Object)nonProxyHosts));
            options.add((Pair<String, String>)Pair.create((Object)"socksNonProxyHosts", (Object)nonProxyHosts));
        }
    }

    public void setProxyServerCredentials(@NotNull String host, int port, @Nullable Credentials credentials) {
        if (host == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(14);
        }
        ProxyCredentialStore.getInstance().setCredentials(host, port, credentials, false);
    }

    @Nullable
    public Credentials getProxyServerCredentials(@NotNull String host, int port) {
        if (host == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(15);
        }
        return ProxyCredentialStore.getInstance().getCredentials(host, port);
    }

    @NotNull
    public AsyncTask<SyncQueue.SyncResult> performAutoSyncTask(@NotNull LoaderContext context, boolean stopRunning) {
        if (context == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(16);
        }
        AsyncTask asyncTask = DataSourceUtil.performAutoSyncTask((LoaderContext)context, (boolean)stopRunning);
        if (asyncTask == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(17);
        }
        return asyncTask;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public AsyncTask<SyncQueue.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(18);
        }
        AsyncTask asyncTask = DataSourceUtil.performManualSyncTask((LoaderContext)context);
        if (asyncTask == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(19);
        }
        return asyncTask;
    }

    public boolean isNonPersistentPasswordStorage() {
        return PasswordStorageComponent.isNonPersistentStorage();
    }

    public void browse(@NotNull String url) {
        if (url == null) {
            DatabaseCoreUiServiceImpl.$$$reportNull$$$0(20);
        }
        BrowserUtil.browse((String)url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9, 11, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseCoreUiServiceImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraNonProxyHosts";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseCoreUiServiceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "treeChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "executor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonProxyOptions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "performAutoSyncTask";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "treeChildren";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProxyOptions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNonProxyOptions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fillNonProxyOptions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setProxyServerCredentials";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProxyServerCredentials";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "browse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9, 11, 17, 19 -> new IllegalStateException(string);
        };
    }
}

