/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.Function;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringResourceConverter
extends Converter<PsiFileSystemItem>
implements CustomReferenceConverter<PsiFileSystemItem> {
    public PsiFileSystemItem fromString(@Nullable String s, @NotNull ConvertContext context) {
        GenericAttributeValue attributeValue;
        PsiReference[] references;
        DomElement domElement;
        if (context == null) {
            SpringResourceConverter.$$$reportNull$$$0(0);
        }
        if (s != null && (domElement = context.getInvocationElement()) instanceof GenericAttributeValue && (references = this.createReferences((PsiElement)(attributeValue = (GenericAttributeValue)domElement).getXmlAttributeValue(), attributeValue.getStringValue(), this.isEndingSlashNotAllowed())).length > 0) {
            for (int i = references.length - 1; i >= 0; --i) {
                PsiElement result;
                PsiReference reference = references[i];
                if (!(reference instanceof FileReference) || (result = reference.resolve()) == null) continue;
                return (PsiFileSystemItem)result;
            }
        }
        return null;
    }

    public String toString(@Nullable PsiFileSystemItem psiFile, @NotNull ConvertContext context) {
        if (context == null) {
            SpringResourceConverter.$$$reportNull$$$0(1);
        }
        return null;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<PsiFileSystemItem> genericDomValue, PsiElement element, ConvertContext context) {
        return this.createReferences(element, genericDomValue.getStringValue(), this.isEndingSlashNotAllowed());
    }

    protected boolean isEndingSlashNotAllowed() {
        return true;
    }

    protected Condition<PsiFileSystemItem> getCondition() {
        return Conditions.alwaysTrue();
    }

    @Nullable
    protected Function<PsiFile, Collection<PsiFileSystemItem>> getCustomDefaultPathEvaluator(@NotNull PsiElement element, @NotNull String s) {
        if (element == null) {
            SpringResourceConverter.$$$reportNull$$$0(2);
        }
        if (s == null) {
            SpringResourceConverter.$$$reportNull$$$0(3);
        }
        return null;
    }

    private PsiReference @NotNull [] createReferences(@Nullable PsiElement element, @Nullable String s, boolean endingSlashNotAllowed) {
        if (s == null || element == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringResourceConverter.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SpringResourcesBuilder builder = SpringResourcesBuilder.create(element, s).fromRoot(StringUtil.startsWithChar((CharSequence)s, (char)'/')).filter(this.getCondition()).endingSlashNotAllowed(endingSlashNotAllowed).customDefaultPathEvaluator(this.getCustomDefaultPathEvaluator(element, s));
        PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(builder);
        if (psiReferenceArray == null) {
            SpringResourceConverter.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringResourceConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringResourceConverter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDefaultPathEvaluator";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public static class Directory
    extends SpringResourceConverter {
        @Override
        protected Condition<PsiFileSystemItem> getCondition() {
            return FileReferenceSet.DIRECTORY_FILTER;
        }
    }

    public static class Allowed
    extends SpringResourceConverter {
        @Override
        protected boolean isEndingSlashNotAllowed() {
            return false;
        }
    }
}

