/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dialects.snowflake.model.SFlakeClass;
import com.intellij.database.dialects.snowflake.model.SFlakeClassInstance;
import com.intellij.database.dialects.snowflake.model.SFlakeMethod;
import com.intellij.database.dialects.snowflake.model.SFlakeRoot;
import com.intellij.database.dialects.snowflake.model.SFlakeSchema;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.base.psi.SqlCodeBlockElementTypeImpl;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.snowflake.SFlakeElementTypes;
import com.intellij.sql.dialects.snowflake.SFlakeTokens;
import com.intellij.sql.dialects.snowflake.dataFlow.SFlakeDFABuildingVisitor;
import com.intellij.sql.dialects.snowflake.psi.SFlakeConstructorCallExpression;
import com.intellij.sql.dialects.snowflake.psi.SFlakeCreateClassInstanceStatement;
import com.intellij.sql.dialects.snowflake.refactoring.SFlakeExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SFlakeDialect
extends SqlLanguageDialectBase {
    public static final SFlakeDialect INSTANCE = new SFlakeDialect();

    private SFlakeDialect() {
        super("Snowflake");
    }

    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(SFlakeTokens.class);
        if (tokensHelper == null) {
            SFlakeDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"variant", (String)"variant", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"object", (String)"object", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"geography", (String)"geography", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SNOWFLAKE;
        if (dbms == null) {
            SFlakeDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        Collection types = super.getParentDbTypes(result, type);
        if (type == SFlakeElementTypes.Kinds.SHARE) {
            types.add(SFlakeElementTypes.Kinds.ACCOUNT);
        }
        if (this.unaliased(type) == ObjectKind.TABLE) {
            types.add(ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.CLASS) {
            types.add(ObjectKind.SCHEMA);
        }
        return (T)types;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SFlakeDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SFlakeDialect.$$$reportNull$$$0(3);
        }
        if ((type == ObjectKind.STREAM || this.unaliased(type) == ObjectKind.TABLE || type == ObjectKind.FOREIGN_TABLE) && expectedTypes.contains(ObjectKind.TABLE)) {
            return true;
        }
        return SFlakeDialect.isConstructorCall(symbol, expectedTypes);
    }

    private static boolean isConstructorCall(@Nullable DasSymbol symbol, @NotNull Set<ObjectKind> expectedTypes) {
        SFlakeMethod method;
        DasObject dasObject;
        if (expectedTypes == null) {
            SFlakeDialect.$$$reportNull$$$0(4);
        }
        return symbol != null && (dasObject = DbUtil.getDasObject((Object)symbol.getDasObject())) instanceof SFlakeMethod && (method = (SFlakeMethod)dasObject).isConstructor() && expectedTypes.contains(ObjectKind.CLASS);
    }

    @NotNull
    public ObjectKind unaliased(@NotNull ObjectKind kind) {
        if (kind == null) {
            SFlakeDialect.$$$reportNull$$$0(5);
        }
        if (kind == ObjectKind.DYNAMIC_TABLE || kind == SFlakeElementTypes.Kinds.ICEBERG_TABLE || kind == SFlakeElementTypes.Kinds.EVENT_TABLE || kind == SFlakeElementTypes.Kinds.HYBRID_TABLE) {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                SFlakeDialect.$$$reportNull$$$0(6);
            }
            return objectKind;
        }
        ObjectKind objectKind = super.unaliased(kind);
        if (objectKind == null) {
            SFlakeDialect.$$$reportNull$$$0(7);
        }
        return objectKind;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean shouldWrap(SqlDefinition o, ObjectKind kind) {
        return kind == SFlakeElementTypes.Kinds.ACCOUNT || super.shouldWrap(o, kind);
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        JdbcUrlParser params = SqlDialectImplUtilCore.getParsed((RawConnectionConfig)SqlImportUtil.getConnectionConfig((DbDataSource)dataSource));
        ObjectName dbName = params == null ? null : ObjectName.plain((String)StringUtil.nullize((String)params.getParameter("database")));
        ObjectName scName = (ObjectName)ObjectUtils.chooseNotNull(params == null ? null : ObjectName.plain((String)StringUtil.nullize((String)params.getParameter("schema"))), (Object)LazyData.PUBLIC_NAME);
        DasNamespace curDb = SFlakeDialect.getDefaultTopNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        DasNamespace curSc = SFlakeDialect.getDefaultSubNamespace((DasNamespace)curDb, (ObjectName)scName);
        if (curSc != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)curSc, (TreePatternNode.Group[])new TreePatternNode.Group[0]);
            if (treePattern == null) {
                SFlakeDialect.$$$reportNull$$$0(8);
            }
            return treePattern;
        }
        if (curDb != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)curDb, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)scName, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                SFlakeDialect.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)SqlImportUtil.createPositiveDatabase((dataSource == null ? 1 : 0) != 0, (ObjectName)dbName, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)scName, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}))));
    }

    public boolean shouldSkipResolveNameCheck(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place) {
        if (expectedTypes == null) {
            SFlakeDialect.$$$reportNull$$$0(10);
        }
        return super.shouldSkipResolveNameCheck(symbol, type, expectedTypes, place) || SFlakeDialect.isConstructorCall(symbol, expectedTypes);
    }

    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SFlakeDialect.$$$reportNull$$$0(11);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath((TreePattern)pattern, (ObjectName[])dsNames, Collections.singletonList(LazyData.PUBLIC_NAME), (boolean)false, (ObjectKind[])new ObjectKind[]{SqlImportUtil.DATA_SOURCE, ObjectKind.DATABASE, ObjectKind.SCHEMA});
        if (treePattern == null) {
            SFlakeDialect.$$$reportNull$$$0(12);
        }
        return treePattern;
    }

    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        TreePattern dbPattern;
        ObjectKind refKind;
        if (prev == null) {
            SFlakeDialect.$$$reportNull$$$0(13);
        }
        if (ref == null) {
            SFlakeDialect.$$$reportNull$$$0(14);
        }
        boolean isDb = (refKind = ref.getReferenceElementType().getTargetKind()) == ObjectKind.DATABASE;
        boolean isSc = refKind == ObjectKind.SCHEMA || refKind == SqlDbElementType.ANY && ref.getQualifierExpression() != null;
        TreePattern scPattern = isDb ? null : SqlImportUtil.createRefPattern((SqlReferenceExpression)ref, (ObjectKind)ObjectKind.SCHEMA, (Dbms)this.getDbms());
        TreePattern treePattern = dbPattern = isSc ? null : this.createDbRefPattern(prev, ref);
        if (isSc) {
            return scPattern;
        }
        if (isDb) {
            return dbPattern;
        }
        return TreePatternUtils.union((TreePattern[])new TreePattern[]{dbPattern, scPattern});
    }

    public boolean canContainDdl(@NotNull PsiElement e) {
        if (e == null) {
            SFlakeDialect.$$$reportNull$$$0(15);
        }
        return super.canContainDdl(e) || e instanceof SqlCreateProcedureStatement || e instanceof SqlCodeBlockElementTypeImpl.BodyElement || e instanceof SqlBlockStatement;
    }

    @Nullable
    private TreePattern createDbRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        if (prev == null) {
            SFlakeDialect.$$$reportNull$$$0(16);
        }
        if (ref == null) {
            SFlakeDialect.$$$reportNull$$$0(17);
        }
        return SqlDialectImplUtilCore.refPatternExpandedToSchema((TreePattern)prev, (SqlReferenceExpression)ref, (SqlLanguageDialectEx)this);
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    @Nullable
    public SqlFunctionCallExpression getCallByCalleeExpression(@NotNull PsiElement element) {
        PsiElement psiElement;
        SqlReferenceExpression ref;
        if (element == null) {
            SFlakeDialect.$$$reportNull$$$0(18);
        }
        if (element instanceof SqlReferenceExpression && (ref = (SqlReferenceExpression)element).getReferenceElementType() == SFlakeElementTypes.Extra.SFLAKE_CLASS_REFERENCE && (psiElement = ref.getParent()) instanceof SqlCreateStatement) {
            SqlCreateStatement def = (SqlCreateStatement)psiElement;
            return (SqlFunctionCallExpression)PsiTreeUtil.findChildOfType((PsiElement)def, SFlakeConstructorCallExpression.class);
        }
        return super.getCallByCalleeExpression(element);
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            SFlakeDialect.$$$reportNull$$$0(19);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class, SqlMergeStatement.class}) != null;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            SFlakeDialect.$$$reportNull$$$0(20);
        }
        return 255;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return SFlakeExtractFunctionHelper.INSTANCE;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new SFlakeDFABuildingVisitor((SqlLanguageDialectEx)this);
    }

    public SqlCloseBlockProcessor[] getEnterHandlerBlockProcessors() {
        return SqlCloseBlockProcessor.EMPTY_ARRAY;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        boolean inPl;
        if (place == null) {
            SFlakeDialect.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            SFlakeDialect.$$$reportNull$$$0(22);
        }
        boolean bl = inPl = PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{SqlBlockStatement.class}) != null;
        if (inPl && SqlImplUtil.getQualifier((PsiElement)place) == null) {
            for (ReservedEntity.Typed typed : LazyData.RE_DML_STATUS_VARS) {
                if (SFlakeDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)typed, (DasType)typed.type, (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) continue;
                return false;
            }
            if (PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{SqlExceptionWhenClause.class}) != null) {
                for (ReservedEntity.Typed typed : LazyData.RE_EXCEPTION_WHEN_VARS) {
                    if (SFlakeDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)typed, (DasType)typed.type, (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) continue;
                    return false;
                }
                for (ReservedEntity reservedEntity : LazyData.RE_EXCEPTIONS) {
                    if (SFlakeDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)reservedEntity, null, (String)name2, (PsiElement)place, (boolean)resolve, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) continue;
                    return false;
                }
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve, processor);
    }

    public void addExtraResolveTargets(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull DasSymbol symbol) {
        DasObject dasObject;
        if (processor == null) {
            SFlakeDialect.$$$reportNull$$$0(23);
        }
        if (state == null) {
            SFlakeDialect.$$$reportNull$$$0(24);
        }
        if (ref == null) {
            SFlakeDialect.$$$reportNull$$$0(25);
        }
        if (symbol == null) {
            SFlakeDialect.$$$reportNull$$$0(26);
        }
        if ((dasObject = DbUtil.getDasObject((Object)symbol.getDasObject())) instanceof SFlakeClass) {
            SFlakeClass klass = (SFlakeClass)dasObject;
            if (ref.getElement().getParent() instanceof SqlCreateStatement) {
                JBIterable constructors = JBIterable.from(klass.getMethods()).filter(m -> m.isConstructor());
                for (SFlakeMethod constructor : constructors) {
                    DasSymbol constructorSymbol = DasSymbolUtil.wrapObjectToSymbol((DasObject)constructor, (SqlScopeProcessor)processor);
                    if (constructorSymbol == null) continue;
                    processor.executeTarget(constructorSymbol, null, null, state);
                }
            }
        }
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            SFlakeDialect.$$$reportNull$$$0(27);
        }
        if (state == null) {
            SFlakeDialect.$$$reportNull$$$0(28);
        }
        if (ref == null) {
            SFlakeDialect.$$$reportNull$$$0(29);
        }
        if (qualifier == null) {
            SFlakeDialect.$$$reportNull$$$0(30);
        }
        if (qualifier instanceof SqlReferenceExpression) {
            SqlReferenceExpression qualifierRef = (SqlReferenceExpression)qualifier;
            if (ref.getReferenceElementType() == SFlakeElementTypes.Extra.SFLAKE_CLASS_REFERENCE) {
                DasObject namespace = DbUtil.getDasObject((Object)qualifierRef.resolve());
                if (!(namespace instanceof SFlakeSchema)) {
                    return false;
                }
                SFlakeSchema schema = (SFlakeSchema)namespace;
                ModNamingFamily<? extends SFlakeClass> candidateClasses = ((SFlakeRoot)schema.getModel().getRoot()).getClasses();
                for (SFlakeClass candidateClass : candidateClasses) {
                    if (candidateClass.getClassSchema() != schema || processor.executeObject((DasObject)candidateClass, null, null, state)) continue;
                    return false;
                }
            }
            if (ref.getReferenceElementType() == SqlCompositeElementTypes.SQL_METHOD_REFERENCE) {
                SFlakeClass klass = SFlakeDialect.getClassByInstance(qualifierRef.resolve());
                if (klass == null) {
                    return false;
                }
                ModNamingFamily<? extends SFlakeMethod> candidateMethods = klass.getMethods();
                for (SFlakeMethod candidateMethod : candidateMethods) {
                    if (!candidateMethod.getName().equalsIgnoreCase(ref.getReferenceName()) || processor.executeObject((DasObject)candidateMethod, null, null, state)) continue;
                    return false;
                }
            }
        }
        return super.processQualifiedResolve(processor, state, ref, qualifier);
    }

    @Nullable
    private static SFlakeClass getClassByInstance(@Nullable PsiElement classInstance) {
        DasObject obj = DbUtil.getDasObject((Object)classInstance);
        if (obj instanceof SFlakeClassInstance) {
            SFlakeClassInstance ci = (SFlakeClassInstance)obj;
            return ci.getClassDef();
        }
        if (obj instanceof SFlakeCreateClassInstanceStatement) {
            SFlakeCreateClassInstanceStatement cs = (SFlakeCreateClassInstanceStatement)obj;
            return cs.getClassDef();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 14: 
            case 17: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 22: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "unaliased";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unaliased";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipResolveNameCheck";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canContainDdl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDbRefPattern";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCallByCalleeExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addExtraResolveTargets";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV})});
        static final ObjectName PUBLIC_NAME = ObjectName.quoted((String)"PUBLIC");
        static final List<ReservedEntity.Typed> RE_DML_STATUS_VARS;
        static final List<ReservedEntity.Typed> RE_EXCEPTION_WHEN_VARS;
        static final List<ReservedEntity> RE_EXCEPTIONS;

        LazyData() {
        }

        static {
            DasTypeSystemBase typeSystem = DasTypeSystems.getTypeSystem((Dbms)Dbms.SNOWFLAKE);
            RE_DML_STATUS_VARS = Arrays.asList(new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLROWCOUNT", ObjectKind.VARIABLE, typeSystem.getIntType()), new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLFOUND", ObjectKind.VARIABLE, typeSystem.getBooleanType()), new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLNOTFOUND", ObjectKind.VARIABLE, typeSystem.getBooleanType()));
            RE_EXCEPTION_WHEN_VARS = Arrays.asList(new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLCODE", ObjectKind.VARIABLE, typeSystem.getIntType()), new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLERRM", ObjectKind.VARIABLE, typeSystem.getStringType()), new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLSTATE", ObjectKind.VARIABLE, typeSystem.getStringType()));
            RE_EXCEPTIONS = Arrays.asList(new ReservedEntity(Dbms.SNOWFLAKE, "STATEMENT_ERROR", ObjectKind.EXCEPTION), new ReservedEntity(Dbms.SNOWFLAKE, "EXPRESSION_ERROR", ObjectKind.EXCEPTION));
        }
    }
}

