/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.actions.ddl.ModifyObjectAction;
import com.intellij.database.diagram.DbDiagramDataModel;
import com.intellij.database.diagram.DbDiagramElementManager;
import com.intellij.database.diagram.DbDiagramNode;
import com.intellij.database.diagram.actions.DbDiagramRefresher;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiagramExtras
extends DiagramExtras<DbElement> {
    private final DiagramDnDProvider<DbElement> DND_PROVIDER = new DiagramDnDProvider<DbElement>(this){

        public boolean isAcceptedForDnD(Object o, Project project) {
            return DbDiagramElementManager.isAcceptedAsNodeImpl(o);
        }

        public DbElement[] wrapToModelObject(Object o, Project project) {
            return new DbElement[]{(DbElement)o};
        }
    };

    public DiagramElementsProvider<DbElement> @NotNull [] getElementsProviders() {
        if (DiagramElementsProvider.EMPTY_ARRAY == null) {
            DbDiagramExtras.$$$reportNull$$$0(0);
        }
        return DiagramElementsProvider.EMPTY_ARRAY;
    }

    public DiagramDnDProvider<DbElement> getDnDProvider() {
        return this.DND_PROVIDER;
    }

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull List<DiagramNode<DbElement>> nodes, @NotNull DiagramBuilder builder) {
        if (sink == null) {
            DbDiagramExtras.$$$reportNull$$$0(1);
        }
        if (nodes == null) {
            DbDiagramExtras.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DbDiagramExtras.$$$reportNull$$$0(3);
        }
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"reference.persistencediagram");
        DbDiagramDataModel dataModel = (DbDiagramDataModel)builder.getDataModel();
        BasicModel model = DbDiagramExtras.getModel(dataModel);
        sink.set(ModifyObjectAction.POST_INTROSPECTION_CALLBACK, (Object)(model == null ? null : new DbDiagramRefresher(builder, model)));
        if (nodes.isEmpty()) {
            DbElement[] dbElementArray;
            DbElement schema = DbDiagramExtras.getSchema(dataModel);
            if (schema == null) {
                dbElementArray = null;
            } else {
                DbElement[] dbElementArray2 = new DbElement[1];
                dbElementArray = dbElementArray2;
                dbElementArray2[0] = schema;
            }
            sink.set(DatabaseView.DB_ELEMENTS, dbElementArray);
        }
    }

    @Nullable
    private static BasicModel getModel(@NotNull DbDiagramDataModel dataModel) {
        BasicModel m;
        DbElement original;
        if (dataModel == null) {
            DbDiagramExtras.$$$reportNull$$$0(4);
        }
        if ((original = (DbElement)dataModel.getOriginalElement()) == null) {
            return null;
        }
        DasModel model = original.getDataSource().getModel();
        return model instanceof BasicModel ? (m = (BasicModel)model) : null;
    }

    @Nullable
    private static DbElement getSchema(DbDiagramDataModel dataModel) {
        DbElement original = (DbElement)dataModel.getOriginalElement();
        if (original != null && original.getKind() == ObjectKind.SCHEMA) {
            return original;
        }
        DbDiagramNode anyNode = (DbDiagramNode)((Object)ContainerUtil.getFirstItem(dataModel.getNodes()));
        if (anyNode == null) {
            return null;
        }
        DbTable anyTable = anyNode.getIdentifyingElement();
        return (DbElement)DasUtil.getSchemaObject((DasObject)anyTable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramExtras";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsProviders";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramExtras";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

