/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.transformer;

import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.CorrectnessAnalysisState;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.DiagnosableProposalTransformer;
import com.intellij.ml.inline.completion.impl.postprocessing.util.MLCompletionCommentsUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/RemoveCommentsTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/DiagnosableProposalTransformer;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;)V", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "transformAnalyzed", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "getOrder", "", "intellij.fullLine.core.completion"})
public final class RemoveCommentsTransformer
extends DiagnosableProposalTransformer {
    @NotNull
    private final MLCompletionLanguageKit kit;
    @NotNull
    private final MLCompletionParameters parameters;

    public RemoveCommentsTransformer(@NotNull MLCompletionLanguageKit kit, @NotNull MLCompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        super("Remove comments");
        this.kit = kit;
        this.parameters = parameters;
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal2) {
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        return proposal2;
    }

    @Override
    @NotNull
    public AnalyzedMLCompletionProposal transformAnalyzed(@NotNull AnalyzedMLCompletionProposal proposal2) {
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        return (AnalyzedMLCompletionProposal)this.diagnoseMapping((MLCompletionProposal)proposal2, (Function0)new Function0<AnalyzedMLCompletionProposal>(this, proposal2){
            final /* synthetic */ RemoveCommentsTransformer this$0;
            final /* synthetic */ AnalyzedMLCompletionProposal $proposal;
            {
                this.this$0 = $receiver;
                this.$proposal = $proposal;
                super(0);
            }

            public final AnalyzedMLCompletionProposal invoke() {
                int startOffset;
                if (RemoveCommentsTransformer.access$getParameters$p(this.this$0).isComment()) {
                    return this.$proposal;
                }
                CorrectnessAnalysisState correctnessState = this.$proposal.getCorrectnessState();
                if (!(correctnessState instanceof CorrectnessAnalysisState.Analyzed)) {
                    if (Intrinsics.areEqual((Object)correctnessState, (Object)CorrectnessAnalysisState.Unknown.INSTANCE)) {
                        return this.$proposal;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                SuggestionEnricher.Enrichment enrichment = ((CorrectnessAnalysisState.Analyzed)correctnessState).getEnrichment();
                PsiFile file = enrichment.component2();
                TextRange range = enrichment.component3();
                if (file == null) {
                    return this.$proposal;
                }
                List comments2 = MLCompletionCommentsUtil.findComments$default(MLCompletionCommentsUtil.INSTANCE, RemoveCommentsTransformer.access$getKit$p(this.this$0), file, range, 0, 8, null);
                TextRange singleComment = (TextRange)CollectionsKt.singleOrNull((List)comments2);
                if (singleComment == null || range.getEndOffset() != singleComment.getEndOffset()) {
                    return this.$proposal;
                }
                singleComment = singleComment.shiftLeft(range.getStartOffset());
                for (startOffset = singleComment.getStartOffset(); startOffset > 0 && CharsKt.isWhitespace((char)this.$proposal.getSuggestion().charAt(startOffset - 1)); --startOffset) {
                }
                if (startOffset == 0) {
                    return this.$proposal;
                }
                AnalyzedMLCompletionProposal analyzedMLCompletionProposal = this.$proposal.trimSuffix(StringsKt.drop((String)this.$proposal.getSuggestion(), (int)startOffset));
                if (analyzedMLCompletionProposal == null) {
                    analyzedMLCompletionProposal = this.$proposal;
                }
                return analyzedMLCompletionProposal;
            }
        });
    }

    @Override
    public int getOrder() {
        return 1000;
    }

    public static final /* synthetic */ MLCompletionParameters access$getParameters$p(RemoveCommentsTransformer $this) {
        return $this.parameters;
    }

    public static final /* synthetic */ MLCompletionLanguageKit access$getKit$p(RemoveCommentsTransformer $this) {
        return $this.kit;
    }
}

