/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4CopyOperation;
import org.jetbrains.idea.perforce.operations.P4DeleteOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.P4MoveRenameOperation;
import org.jetbrains.idea.perforce.operations.P4MoveToChangeListOperation;
import org.jetbrains.idea.perforce.operations.P4RevertOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

@State(name="VcsOperationLog", storages={@Storage(value="$WORKSPACE_FILE$")}, reportStatistic=false)
public final class VcsOperationLog
implements PersistentStateComponent<OperationList> {
    private static final Logger LOG = Logger.getInstance(VcsOperationLog.class);
    private final Object lock = new Object();
    private final Project myProject;
    private OperationList myOperations = new OperationList();

    public VcsOperationLog(Project project) {
        this.myProject = project;
    }

    public static VcsOperationLog getInstance(Project project) {
        return (VcsOperationLog)project.getService(VcsOperationLog.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationList getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull OperationList state) {
        if (state == null) {
            VcsOperationLog.$$$reportNull$$$0(0);
        }
        Object object = this.lock;
        synchronized (object) {
            this.myOperations = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLog(VcsOperation vcsOperation) {
        Object object = this.lock;
        synchronized (object) {
            for (VcsOperation oldOp : this.myOperations.myOperationsByOutputPath.get((Object)vcsOperation.getInputPath())) {
                VcsOperation mergedOp = vcsOperation.checkMerge(oldOp);
                if (mergedOp == oldOp) continue;
                this.myOperations.removeOperation(oldOp);
                if (mergedOp != null) {
                    this.myOperations.addOperation(mergedOp);
                }
                return;
            }
            LOG.debug("Add to log " + String.valueOf(vcsOperation));
            vcsOperation.prepareOffline(this.myProject);
            this.myOperations.addOperation(vcsOperation);
        }
    }

    public boolean runOperations(List<VcsOperation> operations, @NlsContexts.TabTitle String title, PerformInBackgroundOption option, List<VcsException> exceptions) {
        Runnable runnable = this.enqueueOperations(operations, title, option, exceptions);
        if (runnable == null) {
            return false;
        }
        int startSize = exceptions.size();
        runnable.run();
        return startSize == exceptions.size();
    }

    public void queueOperations(List<? extends VcsOperation> operations, @NlsContexts.ProgressTitle String title, PerformInBackgroundOption option) {
        this.queueOperations(operations, title, option, null);
    }

    public void queueOperations(List<? extends VcsOperation> operations, @NlsContexts.ProgressTitle String title, PerformInBackgroundOption option, @Nullable Runnable edtCallback) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Runnable runnable = this.enqueueOperations(operations, title, option, exceptions);
        if (runnable == null) {
            return;
        }
        PerforceVcs.getInstance(this.myProject).runBackgroundTask(title, option, runnable, edtCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Runnable enqueueOperations(List<? extends VcsOperation> operations, @NlsContexts.TabTitle String title, PerformInBackgroundOption option, List<VcsException> exceptions) {
        Object object = this.lock;
        synchronized (object) {
            for (VcsOperation vcsOperation : operations) {
                this.addToLog(vcsOperation);
            }
        }
        if (!PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
            return null;
        }
        return () -> {
            HashSet<P4Connection> authorized = new HashSet<P4Connection>();
            block7: while (true) {
                try {
                    while (true) {
                        AccessToken ignored = PerforceVcs.getInstance(this.myProject).writeLockP4();
                        try {
                            if (new MergedOperationExecutor(this.takeMergeableOperations(), title, option, authorized).executeOperations()) continue;
                            break block7;
                        }
                        finally {
                            if (ignored == null) continue;
                            ignored.close();
                            continue;
                        }
                        break;
                    }
                }
                catch (VcsException e) {
                    exceptions.add(e);
                    continue;
                }
                break;
            }
            if (!exceptions.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(exceptions, title);
            }
        };
    }

    public void replayLog() {
        String title = PerforceBundle.message("replaying.offline.operations", new Object[0]);
        this.queueOperations(Collections.emptyList(), title, PerformInBackgroundOption.DEAF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VcsOperation> takeMergeableOperations() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.myOperations.myOperationsByOutputPath.isEmpty()) {
                Collection allOperations = this.myOperations.myOperationsByOutputPath.values();
                VcsOperation firstOp = (VcsOperation)allOperations.iterator().next();
                List mergeable = ContainerUtil.filter((Collection)allOperations, op -> op.getClass() == firstOp.getClass());
                mergeable.forEach(this.myOperations::removeOperation);
                return mergeable;
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsOperation> getPendingOperations() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOperations.getOperations();
        }
    }

    public Map<String, String> getReopenedPaths() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (VcsOperation op : this.getPendingOperations()) {
            op.fillReopenedPaths(result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/idea/perforce/operations/VcsOperationLog", "loadState"));
    }

    public static class OperationList {
        private final MultiMap<String, VcsOperation> myOperationsByOutputPath = new MultiMap(FileCollectionFactory.createCanonicalFilePathLinkedMap());

        @AbstractCollection(elementTypes={P4AddOperation.class, P4CopyOperation.class, P4DeleteOperation.class, P4MoveRenameOperation.class, P4EditOperation.class, P4RevertOperation.class, P4MoveToChangeListOperation.class})
        public List<VcsOperation> getOperations() {
            return new ArrayList<VcsOperation>(this.myOperationsByOutputPath.values());
        }

        @AbstractCollection(elementTypes={P4AddOperation.class, P4CopyOperation.class, P4DeleteOperation.class, P4MoveRenameOperation.class, P4EditOperation.class, P4RevertOperation.class, P4MoveToChangeListOperation.class})
        public void setOperations(@NotNull List<VcsOperation> operations) {
            if (operations == null) {
                OperationList.$$$reportNull$$$0(0);
            }
            this.myOperationsByOutputPath.clear();
            for (VcsOperation operation : operations) {
                this.addOperation(operation);
            }
        }

        private void addOperation(@NotNull VcsOperation operation) {
            if (operation == null) {
                OperationList.$$$reportNull$$$0(1);
            }
            this.myOperationsByOutputPath.putValue((Object)operation.getOutputPath(), (Object)operation);
        }

        private void removeOperation(@NotNull VcsOperation operation) {
            if (operation == null) {
                OperationList.$$$reportNull$$$0(2);
            }
            this.myOperationsByOutputPath.remove((Object)operation.getOutputPath(), (Object)operation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operations";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/perforce/operations/VcsOperationLog$OperationList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setOperations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOperation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeOperation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MergedOperationExecutor {
        private final LinkedHashSet<VcsOperation> myRemaining;
        private final @NlsContexts.ProgressTitle String myTitle;
        private final PerformInBackgroundOption myOption;
        private final Set<P4Connection> myAuthorized;
        private final ProcessingContext myContext = new ProcessingContext();

        MergedOperationExecutor(@NlsContexts.ProgressTitle List<VcsOperation> operations, String title, PerformInBackgroundOption option, Set<P4Connection> authorized) {
            this.myRemaining = new LinkedHashSet<VcsOperation>(operations);
            this.myTitle = title;
            this.myOption = option;
            this.myAuthorized = authorized;
        }

        @Nullable
        private LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> mergeOperations() throws VcsConnectionProblem {
            LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result = new LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>>();
            MultiMap byConnection = new MultiMap();
            for (VcsOperation operation : this.myRemaining) {
                Set<P4Connection> touchedConnections = this.ensureAuthorized(operation);
                if (touchedConnections == null) {
                    return null;
                }
                if (touchedConnections.size() == 1) {
                    byConnection.putValue((Object)touchedConnections.iterator().next(), (Object)operation);
                    continue;
                }
                this.handleNonMergeableOperation(result, operation);
            }
            if (this.myRemaining.getFirst() instanceof P4RevertOperation) {
                for (P4Connection connection : byConnection.keySet()) {
                    this.mergeRevert(result, connection, byConnection.get((Object)connection));
                }
            } else {
                for (VcsOperation operation : byConnection.values()) {
                    this.handleNonMergeableOperation(result, operation);
                }
            }
            return result;
        }

        private void mergeRevert(LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result, @NotNull P4Connection connection, Collection<VcsOperation> operations) {
            if (connection == null) {
                MergedOperationExecutor.$$$reportNull$$$0(0);
            }
            if (operations.size() == 1) {
                this.handleNonMergeableOperation(result, operations.iterator().next());
                return;
            }
            result.put((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> {
                ArrayList<String> toRevert = new ArrayList<String>();
                ArrayList<File> toDelete = new ArrayList<File>();
                for (VcsOperation operation : operations) {
                    ((P4RevertOperation)operation).prepareRevert(toRevert, toDelete);
                }
                PerforceRunner.getInstance(VcsOperationLog.this.myProject).revertAll(toRevert, connection);
                P4RevertOperation.refreshAfterRevert(toRevert, toDelete, VcsOperationLog.this.myProject);
            }), operations);
        }

        private void handleNonMergeableOperation(LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result, VcsOperation operation) {
            result.put((ThrowableRunnable<VcsException>)((ThrowableRunnable)() -> operation.execute(VcsOperationLog.this.myProject, this.myContext)), Collections.singletonList(operation));
        }

        @Nullable
        private Set<P4Connection> ensureAuthorized(VcsOperation operation) throws VcsConnectionProblem {
            HashSet<P4Connection> touchedConnections = new HashSet<P4Connection>();
            for (String path : operation.getAffectedPaths()) {
                P4Connection connection = PerforceConnectionManager.getInstance(VcsOperationLog.this.myProject).getConnectionForFile(new File(path));
                if (connection == null) {
                    return null;
                }
                touchedConnections.add(connection);
                if (!this.myAuthorized.add(connection)) continue;
                PerforceLoginManager.getInstance(VcsOperationLog.this.myProject).check(connection, true);
            }
            return touchedConnections;
        }

        private void fixLater(VcsConnectionProblem e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean inTests = ApplicationManager.getApplication().isUnitTestMode();
                if (e.attemptQuickFix(!inTests) && PerforceSettings.getSettings((Project)VcsOperationLog.this.myProject).ENABLED) {
                    VcsOperationLog.this.queueOperations(Collections.emptyList(), this.myTitle, this.myOption);
                } else {
                    PerforceSettings.getSettings(VcsOperationLog.this.myProject).disable(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pushBackOperations() {
            Object object = VcsOperationLog.this.lock;
            synchronized (object) {
                VcsOperationLog.this.myOperations.setOperations(ContainerUtil.newArrayList((Iterable)ContainerUtil.concat(this.myRemaining, VcsOperationLog.this.myOperations.getOperations())));
            }
        }

        private boolean executeOperations() throws VcsException {
            if (this.myRemaining.isEmpty()) {
                return false;
            }
            try {
                LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> map = this.mergeOperations();
                if (map == null) {
                    this.pushBackOperations();
                    AbstractVcsHelper.getInstance((Project)VcsOperationLog.this.myProject).showError(new VcsException(PerforceBundle.message("error.can.not.execute.invalid.connection.settings", this.myTitle)), this.myTitle);
                    return false;
                }
                for (ThrowableRunnable<VcsException> composite : map.keySet()) {
                    composite.run();
                    this.myRemaining.removeAll(map.get(composite));
                }
            }
            catch (VcsConnectionProblem e) {
                this.pushBackOperations();
                this.fixLater(e);
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/operations/VcsOperationLog$MergedOperationExecutor", "mergeRevert"));
        }
    }
}

