/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.split.frontend;

import com.intellij.jupyter.split.frontend.JupyterFrontendDocumentSynchronizerService;
import com.intellij.jupyter.split.frontend.JupyterFrontendDocumentVersionChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListener;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/split/frontend/JupyterFrontendDocumentSynchronizerService;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/jupyter/split/frontend/JupyterFrontendDocumentVersionChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addListener", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "listener", "change", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "subscribeToDocumentSynchronizer", "unsubscribeFromDocumentSynchronizer", "Companion", "intellij.jupyter.split.frontend"})
public final class JupyterFrontendDocumentSynchronizerService
implements DocumentSynchronizerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EventDispatcher<JupyterFrontendDocumentVersionChangeListener> listeners;

    public JupyterFrontendDocumentSynchronizerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        EventDispatcher eventDispatcher = EventDispatcher.create(JupyterFrontendDocumentVersionChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.listeners = eventDispatcher;
    }

    public final void addListener(@NotNull EditorImpl editor, @NotNull JupyterFrontendDocumentVersionChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!this.listeners.hasListeners()) {
            this.subscribeToDocumentSynchronizer();
        }
        JupyterFrontendDocumentVersionChangeListener listenerWrapper2 = new JupyterFrontendDocumentVersionChangeListener(editor, listener){
            final /* synthetic */ EditorImpl $editor;
            final /* synthetic */ JupyterFrontendDocumentVersionChangeListener $listener;
            {
                this.$editor = $editor;
                this.$listener = $listener;
            }

            public void onVersionChange(RdDocumentChange change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                Project project = this.$editor.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                DocumentEx documentEx = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)((Document)documentEx), (Project)project2);
                DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
                if (Intrinsics.areEqual((Object)change.getDocumentId(), (Object)(documentSynchronizer2 != null ? documentSynchronizer2.getDocumentId() : null))) {
                    this.$listener.onVersionChange(change);
                }
            }
        };
        this.listeners.addListener((EventListener)listenerWrapper2);
        Disposer.register((Disposable)editor.getDisposable(), () -> JupyterFrontendDocumentSynchronizerService.addListener$lambda$0(this, listenerWrapper2));
    }

    public void change(@NotNull RdDocumentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ((JupyterFrontendDocumentVersionChangeListener)this.listeners.getMulticaster()).onVersionChange(change);
    }

    private final void subscribeToDocumentSynchronizer() {
        ClientAppSession session = FrontendSessionsUtilKt.getFrontendProjectSession((Project)this.project).getAppSession();
        DocumentSynchronizerListeners listeners = DocumentSynchronizerListeners.Companion.getInstance(session);
        listeners.addListener((DocumentSynchronizerListener)this);
    }

    private final void unsubscribeFromDocumentSynchronizer() {
        if (this.project.isDisposed()) {
            return;
        }
        ClientAppSession session = FrontendSessionsUtilKt.getFrontendProjectSession((Project)this.project).getAppSession();
        DocumentSynchronizerListeners listeners = DocumentSynchronizerListeners.Companion.getInstance(session);
        listeners.removeListener((DocumentSynchronizerListener)this);
    }

    private static final void addListener$lambda$0(JupyterFrontendDocumentSynchronizerService this$0, addListener.listenerWrapper.1 $listenerWrapper) {
        this$0.listeners.removeListener((EventListener)$listenerWrapper);
        if (!this$0.listeners.hasListeners()) {
            this$0.unsubscribeFromDocumentSynchronizer();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/split/frontend/JupyterFrontendDocumentSynchronizerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/split/frontend/JupyterFrontendDocumentSynchronizerService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.split.frontend"})
    @SourceDebugExtension(value={"SMAP\nJupyterFrontendDocumentSynchronizerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFrontendDocumentSynchronizerService.kt\ncom/intellij/jupyter/split/frontend/JupyterFrontendDocumentSynchronizerService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,74:1\n30#2,2:75\n*S KotlinDebug\n*F\n+ 1 JupyterFrontendDocumentSynchronizerService.kt\ncom/intellij/jupyter/split/frontend/JupyterFrontendDocumentSynchronizerService$Companion\n*L\n72#1:75,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterFrontendDocumentSynchronizerService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JupyterFrontendDocumentSynchronizerService> serviceClass$iv = JupyterFrontendDocumentSynchronizerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterFrontendDocumentSynchronizerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

