/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.parser.ParseException;
import org.jetbrains.relocated.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public abstract class UnitProcessor
extends org.jetbrains.relocated.apache.batik.parser.UnitProcessor {
    public static UnitProcessor.Context createContext(BridgeContext ctx2, Element e) {
        return new DefaultContext(ctx2, e);
    }

    public static float svgHorizontalCoordinateToObjectBoundingBox(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgToObjectBoundingBox(s, attr, (short)2, ctx2);
    }

    public static float svgVerticalCoordinateToObjectBoundingBox(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgToObjectBoundingBox(s, attr, (short)1, ctx2);
    }

    public static float svgOtherCoordinateToObjectBoundingBox(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgToObjectBoundingBox(s, attr, (short)0, ctx2);
    }

    public static float svgHorizontalLengthToObjectBoundingBox(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgLengthToObjectBoundingBox(s, attr, (short)2, ctx2);
    }

    public static float svgVerticalLengthToObjectBoundingBox(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgLengthToObjectBoundingBox(s, attr, (short)1, ctx2);
    }

    public static float svgOtherLengthToObjectBoundingBox(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgLengthToObjectBoundingBox(s, attr, (short)0, ctx2);
    }

    public static float svgLengthToObjectBoundingBox(String s, String attr, short d, UnitProcessor.Context ctx2) {
        float v = UnitProcessor.svgToObjectBoundingBox(s, attr, d, ctx2);
        if (v < 0.0f) {
            throw new BridgeException(UnitProcessor.getBridgeContext(ctx2), ctx2.getElement(), "length.negative", new Object[]{attr, s});
        }
        return v;
    }

    public static float svgToObjectBoundingBox(String s, String attr, short d, UnitProcessor.Context ctx2) {
        try {
            return org.jetbrains.relocated.apache.batik.parser.UnitProcessor.svgToObjectBoundingBox(s, attr, d, ctx2);
        }
        catch (ParseException pEx) {
            throw new BridgeException(UnitProcessor.getBridgeContext(ctx2), ctx2.getElement(), pEx, "attribute.malformed", new Object[]{attr, s, pEx});
        }
    }

    public static float svgHorizontalLengthToUserSpace(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgLengthToUserSpace(s, attr, (short)2, ctx2);
    }

    public static float svgVerticalLengthToUserSpace(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgLengthToUserSpace(s, attr, (short)1, ctx2);
    }

    public static float svgOtherLengthToUserSpace(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgLengthToUserSpace(s, attr, (short)0, ctx2);
    }

    public static float svgHorizontalCoordinateToUserSpace(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgToUserSpace(s, attr, (short)2, ctx2);
    }

    public static float svgVerticalCoordinateToUserSpace(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgToUserSpace(s, attr, (short)1, ctx2);
    }

    public static float svgOtherCoordinateToUserSpace(String s, String attr, UnitProcessor.Context ctx2) {
        return UnitProcessor.svgToUserSpace(s, attr, (short)0, ctx2);
    }

    public static float svgLengthToUserSpace(String s, String attr, short d, UnitProcessor.Context ctx2) {
        float v = UnitProcessor.svgToUserSpace(s, attr, d, ctx2);
        if (v < 0.0f) {
            throw new BridgeException(UnitProcessor.getBridgeContext(ctx2), ctx2.getElement(), "length.negative", new Object[]{attr, s});
        }
        return v;
    }

    public static float svgToUserSpace(String s, String attr, short d, UnitProcessor.Context ctx2) {
        try {
            return org.jetbrains.relocated.apache.batik.parser.UnitProcessor.svgToUserSpace(s, attr, d, ctx2);
        }
        catch (ParseException pEx) {
            throw new BridgeException(UnitProcessor.getBridgeContext(ctx2), ctx2.getElement(), pEx, "attribute.malformed", new Object[]{attr, s, pEx});
        }
    }

    protected static BridgeContext getBridgeContext(UnitProcessor.Context ctx2) {
        if (ctx2 instanceof DefaultContext) {
            return ((DefaultContext)ctx2).ctx;
        }
        return null;
    }

    public static class DefaultContext
    implements UnitProcessor.Context {
        protected Element e;
        protected BridgeContext ctx;

        public DefaultContext(BridgeContext ctx2, Element e) {
            this.ctx = ctx2;
            this.e = e;
        }

        @Override
        public Element getElement() {
            return this.e;
        }

        @Override
        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        @Override
        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        @Override
        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }

        @Override
        public float getXHeight() {
            return 0.5f;
        }

        @Override
        public float getViewportWidth() {
            return this.ctx.getViewport(this.e).getWidth();
        }

        @Override
        public float getViewportHeight() {
            return this.ctx.getViewport(this.e).getHeight();
        }
    }
}

