/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkICCP;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "compressedProfile", "", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "profileName", "", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "Companion", "plot-api"})
public final class PngChunkICCP
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private String profileName;
    private byte[] compressedProfile;
    @NotNull
    public static final String ID = "iCCP";

    public PngChunkICCP(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        String string = this.profileName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profileName");
            string = null;
        }
        int n = string.length();
        byte[] byArray = this.compressedProfile;
        if (this.compressedProfile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compressedProfile");
            byArray = null;
        }
        ChunkRaw c = this.createEmptyChunk(n + byArray.length + 2, true);
        String string2 = this.profileName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profileName");
            string2 = null;
        }
        byte[] byArray2 = ChunkHelper.INSTANCE.toBytesLatin1(string2);
        byte[] byArray3 = c.getData();
        Intrinsics.checkNotNull((Object)byArray3);
        String string3 = this.profileName;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profileName");
            string3 = null;
        }
        ArrayUtilsKt.arraycopy(byArray2, 0, byArray3, 0, string3.length());
        byte[] byArray4 = c.getData();
        Intrinsics.checkNotNull((Object)byArray4);
        String string4 = this.profileName;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profileName");
            string4 = null;
        }
        byArray4[string4.length()] = 0;
        byte[] byArray5 = c.getData();
        Intrinsics.checkNotNull((Object)byArray5);
        String string5 = this.profileName;
        if (string5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profileName");
            string5 = null;
        }
        byArray5[string5.length() + 1] = 0;
        byte[] byArray6 = this.compressedProfile;
        if (this.compressedProfile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compressedProfile");
            byArray6 = null;
        }
        byte[] byArray7 = c.getData();
        Intrinsics.checkNotNull((Object)byArray7);
        String string6 = this.profileName;
        if (string6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profileName");
            string6 = null;
        }
        int n2 = string6.length() + 2;
        byte[] byArray8 = this.compressedProfile;
        if (this.compressedProfile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compressedProfile");
            byArray8 = null;
        }
        ArrayUtilsKt.arraycopy(byArray6, 0, byArray7, n2, byArray8.length);
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        byte[] byArray = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray);
        int pos0 = ChunkHelper.INSTANCE.posNullByte(byArray);
        byte[] byArray2 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray2);
        this.profileName = ChunkHelper.INSTANCE.toStringLatin1(byArray2, 0, pos0);
        byte[] byArray3 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray3);
        int comp = byArray3[pos0 + 1] & 0xFF;
        if (comp != 0) {
            throw new PngjException("bad compression for ChunkTypeICCP");
        }
        byte[] byArray4 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray4);
        int compdatasize = byArray4.length - (pos0 + 2);
        this.compressedProfile = new byte[compdatasize];
        byte[] byArray5 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray5);
        byte[] byArray6 = this.compressedProfile;
        if (this.compressedProfile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"compressedProfile");
            byArray6 = null;
        }
        ArrayUtilsKt.arraycopy(byArray5, pos0 + 2, byArray6, 0, compdatasize);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkICCP$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

