/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.MapperUtil;
import org.jetbrains.letsPlot.core.plot.builder.scale.GuideMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.mapper.ColorMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.mapper.GuideMappers;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.MapperProviderBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorGradientnMapperProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/MapperProviderBase;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "colors", "", "naValue", "(Ljava/util/List;Lorg/jetbrains/letsPlot/commons/values/Color;)V", "createContinuousMapper", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/GuideMapper;", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "trans", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "createDiscreteMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nColorGradientnMapperProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorGradientnMapperProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorGradientnMapperProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class ColorGradientnMapperProvider
extends MapperProviderBase<Color> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Color> colors;

    public ColorGradientnMapperProvider(@NotNull List<Color> colors, @NotNull Color naValue) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)naValue, (String)"naValue");
        super(naValue);
        this.colors = colors;
        if (!(this.colors.size() > 1)) {
            boolean bl = false;
            String string = "gradient requires colors list with two or more elements";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public ScaleMapper<Color> createDiscreteMapper(@NotNull DiscreteTransform discreteTransform) {
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        List<Double> transformedDomain = discreteTransform.getEffectiveDomainTransformed();
        DoubleSpan mapperDomain = SeriesUtil.ensureApplicableRange$default(SeriesUtil.INSTANCE, DoubleSpan.Companion.encloseAllQ((Iterable<Double>)transformedDomain), null, 2, null);
        Function1 gradient = org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColorGradientnMapperProvider$Companion.createGradient$plot_builder$default(Companion, mapperDomain, this.colors, (Color)this.getNaValue(), 0.0, 8, null);
        return GuideMappers.INSTANCE.asNotContinuous(ScaleMapper.Companion.wrap(gradient));
    }

    @Override
    @NotNull
    public GuideMapper<Color> createContinuousMapper(@NotNull DoubleSpan domain, @NotNull ContinuousTransform trans) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        DoubleSpan domain2 = MapperUtil.INSTANCE.rangeWithLimitsAfterTransform(domain, trans);
        Function1 gradient = org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColorGradientnMapperProvider$Companion.createGradient$plot_builder$default(Companion, domain2, this.colors, (Color)this.getNaValue(), 0.0, 8, null);
        return GuideMappers.INSTANCE.asContinuous(ScaleMapper.Companion.wrap(gradient));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorGradientnMapperProvider$Companion;", "", "()V", "createGradient", "Lkotlin/Function1;", "", "Lorg/jetbrains/letsPlot/commons/values/Color;", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "colors", "", "naColor", "alpha", "createGradient$plot_builder", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nColorGradientnMapperProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorGradientnMapperProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorGradientnMapperProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1549#2:86\n1620#2,3:87\n1549#2:90\n1620#2,3:91\n*S KotlinDebug\n*F\n+ 1 ColorGradientnMapperProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColorGradientnMapperProvider$Companion\n*L\n57#1:86\n57#1:87,3\n61#1:90\n61#1:91,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Function1<Double, Color> createGradient$plot_builder(@NotNull DoubleSpan domain, @NotNull List<Color> colors, @NotNull Color naColor, double alpha) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            Intrinsics.checkNotNullParameter((Object)naColor, (String)"naColor");
            int subdomainsCount = colors.size() - 1;
            double subdomainLength = domain.getLength() / (double)subdomainsCount;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)subdomainsCount);
            boolean $i$f$map22 = false;
            void var12_10 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(domain.getLowerEnd() + subdomainLength * (double)it);
            }
            List subdomainEnds = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)domain.getUpperEnd()));
            Iterable $i$f$map22 = CollectionsKt.windowed$default((Iterable)CollectionsKt.zip((Iterable)subdomainEnds, (Iterable)colors), (int)2, (int)0, (boolean)false, (int)6, null);
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list2 = (List)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                Pair low = (Pair)list2.get(0);
                Pair high = (Pair)list2.get(1);
                double lowValue = ((Number)low.component1()).doubleValue();
                Color lowColor = (Color)low.component2();
                double highValue = ((Number)high.component1()).doubleValue();
                Color highColor = (Color)high.component2();
                DoubleSpan subdomain = new DoubleSpan(lowValue, highValue);
                collection.add(ColorMapper.INSTANCE.gradient(subdomain, lowColor, highColor, naColor, alpha));
            }
            List mappers = (List)destination$iv$iv2;
            return (Function1)new Function1<Double, Color>(naColor, (List<Double>)subdomainEnds, (List<? extends Function1<? super Double, Color>>)mappers){
                final /* synthetic */ Color $naColor;
                final /* synthetic */ List<Double> $subdomainEnds;
                final /* synthetic */ List<Function1<Double, Color>> $mappers;
                {
                    this.$naColor = $naColor;
                    this.$subdomainEnds = $subdomainEnds;
                    this.$mappers = $mappers;
                    super(1);
                }

                @NotNull
                public final Color invoke(@Nullable Double value) {
                    Color color;
                    double d;
                    if (value == null || !(!Double.isInfinite(d = value.doubleValue()) && !Double.isNaN(d))) {
                        color = this.$naColor;
                    } else if (value < ((Number)CollectionsKt.first(this.$subdomainEnds)).doubleValue() || value > ((Number)CollectionsKt.last(this.$subdomainEnds)).doubleValue()) {
                        color = this.$naColor;
                    } else {
                        int i = CollectionsKt.binarySearch$default(this.$subdomainEnds, (Comparable)value, (int)0, (int)0, (int)6, null);
                        int subdomainIndex = i < 0 ? Math.abs(i + 1) - 1 : Math.min(i, CollectionsKt.getLastIndex(this.$mappers));
                        color = (Color)this.$mappers.get(subdomainIndex).invoke((Object)value);
                    }
                    return color;
                }
            };
        }

        public static /* synthetic */ Function1 createGradient$plot_builder$default(Companion companion, DoubleSpan doubleSpan, List list2, Color color, double d, int n, Object object) {
            if ((n & 8) != 0) {
                d = 1.0;
            }
            return companion.createGradient$plot_builder(doubleSpan, list2, color, d);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

