/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\f\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LabelOptions;", "", "()V", "alphaStroke", "", "getAlphaStroke", "()Z", "setAlphaStroke", "(Z)V", "borderWidth", "", "getBorderWidth", "()D", "setBorderWidth", "(D)V", "paddingFactor", "getPaddingFactor", "setPaddingFactor", "radiusFactor", "getRadiusFactor", "setRadiusFactor", "Companion", "plot-base"})
public final class LabelOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double paddingFactor = 0.25;
    private double radiusFactor = 0.15;
    private double borderWidth = 1.0;
    private boolean alphaStroke;

    public final double getPaddingFactor() {
        return this.paddingFactor;
    }

    public final void setPaddingFactor(double d) {
        this.paddingFactor = d;
    }

    public final double getRadiusFactor() {
        return this.radiusFactor;
    }

    public final void setRadiusFactor(double d) {
        this.radiusFactor = d;
    }

    public final double getBorderWidth() {
        return this.borderWidth;
    }

    public final void setBorderWidth(double d) {
        this.borderWidth = d;
    }

    public final boolean getAlphaStroke() {
        return this.alphaStroke;
    }

    public final void setAlphaStroke(boolean bl) {
        this.alphaStroke = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011J6\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\fH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LabelOptions$Companion;", "", "()V", "buildLabelComponent", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "location", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "text", "", "sizeUnitRatio", "", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "boundsCenter", "labelOptions", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LabelOptions;", "labelRectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "textSize", "fontSize", "hAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "vAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "roundedRectangle", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;", "rect", "radius", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgGElement buildLabelComponent(@NotNull DataPointAesthetics p, @NotNull DoubleVector location2, @NotNull String text2, double sizeUnitRatio, @NotNull GeomContext ctx2, @Nullable DoubleVector boundsCenter, @NotNull LabelOptions labelOptions) {
            double d;
            SvgPathElement svgPathElement;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)labelOptions, (String)"labelOptions");
            DoubleVector textSize = TextUtil.INSTANCE.measure(text2, p, ctx2, sizeUnitRatio);
            Text.HorizontalAnchor hAnchor = TextUtil.INSTANCE.hAnchor(p, location2, boundsCenter);
            Text.VerticalAnchor vAnchor = TextUtil.INSTANCE.vAnchor(p, location2, boundsCenter);
            double fontSize = TextUtil.INSTANCE.fontSize(p, sizeUnitRatio);
            DoubleRectangle rectangle = this.labelRectangle(location2, textSize, fontSize, hAnchor, vAnchor, labelOptions);
            SvgPathElement $this$buildLabelComponent_u24lambda_u240 = svgPathElement = new SvgPathElement();
            boolean bl = false;
            $this$buildLabelComponent_u24lambda_u240.d().set(Companion.roundedRectangle(rectangle, labelOptions.getRadiusFactor() * rectangle.getHeight()).build());
            SvgPathElement backgroundRect = svgPathElement;
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, backgroundRect, p, labelOptions.getAlphaStroke(), null, false, 24, null);
            backgroundRect.strokeWidth().set(labelOptions.getBorderWidth());
            Label label2 = new Label(text2, 0, false, 6, null);
            TextUtil.INSTANCE.decorate(label2, p, sizeUnitRatio, labelOptions.getAlphaStroke());
            double padding = fontSize * labelOptions.getPaddingFactor();
            switch (WhenMappings.$EnumSwitchMapping$0[hAnchor.ordinal()]) {
                case 1: {
                    d = location2.getX() + padding;
                    break;
                }
                case 2: {
                    d = location2.getX() - padding;
                    break;
                }
                case 3: {
                    d = location2.getX();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double xPosition = d;
            DoubleVector textPosition = new DoubleVector(xPosition, rectangle.getOrigin().getY() + padding + fontSize * 0.8);
            label2.setHorizontalAnchor(hAnchor);
            label2.moveTo(textPosition);
            SvgGElement g = new SvgGElement();
            g.children().add(backgroundRect);
            g.children().add(label2.getRootGroup());
            SvgUtils.INSTANCE.transformRotate(g, TextUtil.INSTANCE.angle(p), location2.getX(), location2.getY());
            return g;
        }

        @NotNull
        public final DoubleRectangle labelRectangle(@NotNull DoubleVector location2, @NotNull DoubleVector textSize, double fontSize, @NotNull Text.HorizontalAnchor hAnchor, @NotNull Text.VerticalAnchor vAnchor, @NotNull LabelOptions labelOptions) {
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
            Intrinsics.checkNotNullParameter((Object)((Object)hAnchor), (String)"hAnchor");
            Intrinsics.checkNotNullParameter((Object)((Object)vAnchor), (String)"vAnchor");
            Intrinsics.checkNotNullParameter((Object)labelOptions, (String)"labelOptions");
            double padding = fontSize * labelOptions.getPaddingFactor();
            return TextUtil.INSTANCE.rectangleForText(location2, textSize, padding, hAnchor, vAnchor);
        }

        private final SvgPathDataBuilder roundedRectangle(DoubleRectangle rect2, double radius) {
            SvgPathDataBuilder svgPathDataBuilder;
            SvgPathDataBuilder $this$roundedRectangle_u24lambda_u242 = svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            boolean bl = false;
            DoubleRectangle $this$roundedRectangle_u24lambda_u242_u24lambda_u241 = rect2;
            boolean bl2 = false;
            double r = Math.min(radius, Math.min($this$roundedRectangle_u24lambda_u242_u24lambda_u241.getWidth() / (double)2, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getHeight() / (double)2));
            SvgPathDataBuilder.moveTo$default($this$roundedRectangle_u24lambda_u242, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getRight() - r, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getBottom(), false, 4, null);
            SvgPathDataBuilder.curveTo$default($this$roundedRectangle_u24lambda_u242, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getRight() - r, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getBottom(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getBottom(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getBottom() - r, false, 64, null);
            SvgPathDataBuilder.lineTo$default($this$roundedRectangle_u24lambda_u242, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getTop() + r, false, 4, null);
            SvgPathDataBuilder.curveTo$default($this$roundedRectangle_u24lambda_u242, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getTop() + r, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getTop(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getRight() - r, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getTop(), false, 64, null);
            SvgPathDataBuilder.lineTo$default($this$roundedRectangle_u24lambda_u242, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getLeft() + r, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getTop(), false, 4, null);
            SvgPathDataBuilder.curveTo$default($this$roundedRectangle_u24lambda_u242, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getLeft() + r, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getTop(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getTop(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getTop() + r, false, 64, null);
            SvgPathDataBuilder.lineTo$default($this$roundedRectangle_u24lambda_u242, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getBottom() - r, false, 4, null);
            SvgPathDataBuilder.curveTo$default($this$roundedRectangle_u24lambda_u242, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getBottom() - r, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getBottom(), $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getLeft() + r, $this$roundedRectangle_u24lambda_u242_u24lambda_u241.getBottom(), false, 64, null);
            $this$roundedRectangle_u24lambda_u242.closePath();
            return svgPathDataBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Text.HorizontalAnchor.values().length];
                try {
                    nArray[Text.HorizontalAnchor.LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Text.HorizontalAnchor.RIGHT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Text.HorizontalAnchor.MIDDLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

