/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintsCollection;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J#\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/RibbonGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "buildHints", "", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildIntern", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "dataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "finiteOrNull", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "x", "", "y", "(Ljava/lang/Double;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nRibbonGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RibbonGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/RibbonGeom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class RibbonGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = true;

    private final DoubleVector finiteOrNull(Double x2, Double y2) {
        DoubleVector doubleVector;
        if (SeriesUtil.INSTANCE.isFinite(x2) && SeriesUtil.INSTANCE.isFinite(y2)) {
            Double d = x2;
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = y2;
            Intrinsics.checkNotNull((Object)d3);
            doubleVector = new DoubleVector(d2, d3);
        } else {
            doubleVector = null;
        }
        return doubleVector;
    }

    private final Iterable<DataPointAesthetics> dataPoints(Aesthetics aesthetics2) {
        Iterable<DataPointAesthetics> data = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), Aes.Companion.getX(), Aes.Companion.getYMIN(), Aes.Companion.getYMAX());
        return GeomUtil.INSTANCE.ordered_X(data);
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Iterable<DataPointAesthetics> dataPoints2 = this.dataPoints(aesthetics2);
        LinesHelper helper2 = new LinesHelper(pos, coord, ctx2);
        Function1 upper2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this){
            final /* synthetic */ RibbonGeom this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$finiteOrNull(this.this$0, p.get(Aes.Companion.getX()), p.get(Aes.Companion.getYMAX()));
            }
        };
        Function1 lower2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this){
            final /* synthetic */ RibbonGeom this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$finiteOrNull(this.this$0, p.get(Aes.Companion.getX()), p.get(Aes.Companion.getYMIN()));
            }
        };
        List paths = LinesHelper.createBands$default(helper2, dataPoints2, upper2, lower2, false, 8, null);
        GeomBase.Companion.appendNodes(root, paths);
        helper2.setAlphaEnabled(false);
        GeomBase.Companion.appendNodes(root, helper2.createLines(dataPoints2, (Function1<? super DataPointAesthetics, DoubleVector>)upper2));
        GeomBase.Companion.appendNodes(root, helper2.createLines(dataPoints2, (Function1<? super DataPointAesthetics, DoubleVector>)lower2));
        this.buildHints(aesthetics2, pos, coord, ctx2);
    }

    private final void buildHints(Aesthetics aesthetics2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2) {
        TipLayoutHint.Kind kind;
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        Function1<DataPointAesthetics, List<Color>> colorMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.RIBBON, ctx2);
        TipLayoutHint.Kind kind2 = kind = TipLayoutHint.Kind.HORIZONTAL_TOOLTIP;
        HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(0.0);
        boolean bl = false;
        boolean bl2 = ctx2.getFlipped();
        TipLayoutHint.Kind kind3 = !bl2 ? kind : null;
        if (kind3 == null) {
            kind3 = TipLayoutHint.Kind.VERTICAL_TOOLTIP;
        }
        HintsCollection.HintConfigFactory hint = hintConfigFactory.defaultKind(kind3);
        Function1 location2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this){
            final /* synthetic */ RibbonGeom this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$finiteOrNull(this.this$0, p.get(Aes.Companion.getX()), 0.0);
            }
        };
        Function1 upper2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this){
            final /* synthetic */ RibbonGeom this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$finiteOrNull(this.this$0, p.get(Aes.Companion.getX()), p.get(Aes.Companion.getYMAX()));
            }
        };
        Function1 lower2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this){
            final /* synthetic */ RibbonGeom this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$finiteOrNull(this.this$0, p.get(Aes.Companion.getX()), p.get(Aes.Companion.getYMIN()));
            }
        };
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            DoubleVector doubleVector = (DoubleVector)location2.invoke((Object)p);
            if (doubleVector == null) continue;
            DoubleVector it = doubleVector;
            boolean bl3 = false;
            DoubleVector doubleVector2 = helper2.toClient(it, p);
            doubleVector = doubleVector2;
            if (doubleVector2 == null) {
                continue;
            }
            double x2 = doubleVector.getX();
            DoubleVector doubleVector3 = (DoubleVector)upper2.invoke((Object)p);
            if (doubleVector3 == null) continue;
            DoubleVector it2 = doubleVector3;
            boolean bl4 = false;
            DoubleVector doubleVector4 = helper2.toClient(it2, p);
            doubleVector3 = doubleVector4;
            if (doubleVector4 == null) {
                continue;
            }
            double top = doubleVector3.getY();
            DoubleVector doubleVector5 = (DoubleVector)lower2.invoke((Object)p);
            if (doubleVector5 == null) continue;
            DoubleVector it3 = doubleVector5;
            boolean bl5 = false;
            DoubleVector doubleVector6 = helper2.toClient(it3, p);
            doubleVector5 = doubleVector6;
            if (doubleVector6 == null) {
                continue;
            }
            double bottom = doubleVector5.getY();
            Double d = p.get(Aes.Companion.getX());
            Intrinsics.checkNotNull((Object)d);
            HintsCollection.HintConfigFactory hintConfigFactory2 = hint.defaultCoord(((Number)d).doubleValue());
            Color color = p.fill();
            Intrinsics.checkNotNull((Object)color);
            hintConfigFactory2.defaultColor(color, null);
            HintsCollection hintsCollection = new HintsCollection(p, helper2).addHint(hint.create(Aes.Companion.getYMAX())).addHint(hint.create(Aes.Companion.getYMIN()));
            GeomTargetCollector.TooltipParams tooltipParams = new GeomTargetCollector.TooltipParams(hintsCollection.getHints(), null, null, (List)colorMapper.invoke((Object)p), 6, null);
            GeomTargetCollector.DefaultImpls.addPoint$default(ctx2.getTargetCollector(), p.index(), new DoubleVector(x2, top), 0.0, tooltipParams, null, 16, null);
            GeomTargetCollector.DefaultImpls.addPoint$default(ctx2.getTargetCollector(), p.index(), new DoubleVector(x2, bottom), 0.0, tooltipParams, null, 16, null);
        }
    }

    public static final /* synthetic */ DoubleVector access$finiteOrNull(RibbonGeom $this, Double x2, Double y2) {
        return $this.finiteOrNull(x2, y2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/RibbonGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

