/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions.extractComponent;

import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssUnusedSymbolUtils;
import com.intellij.psi.css.inspections.RemoveUnusedSymbolIntentionAction;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.editor.VueComponentSourceEdit;
import org.jetbrains.vuejs.index.VueFileVisitor;
import org.jetbrains.vuejs.index.VueFrameworkHandlerKt;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentDataBuilder;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentDataBuilder$findStyles$;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentDataBuilder$processVueComponent$;
import org.jetbrains.vuejs.lang.expr.VueExprLanguagesKt;
import org.jetbrains.vuejs.lang.html.VueFile;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.VueModelManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0001HB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0003H\u0002J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%H\u0002J\n\u0010&\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\rJ\u0010\u0010*\u001a\u00020\r2\u0006\u0010)\u001a\u00020\rH\u0002J&\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\r2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0\u00032\u0006\u0010.\u001a\u00020\rH\u0002J$\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\r2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001902H\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u00105\u001a\u000203H\u0002J\u0010\u00106\u001a\u00020\u00192\u0006\u00105\u001a\u000203H\u0002J\u0010\u00107\u001a\u0002082\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u00109\u001a\u0004\u0018\u00010\r2\b\u0010:\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010;\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010<\u001a\u0004\u0018\u00010\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%H\u0002J\u001e\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%H\u0002J\u001e\u0010?\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\r2\u0006\u0010@\u001a\u0002032\u0006\u0010A\u001a\u000203J\u000e\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\rJ\u0010\u0010D\u001a\u00020\u00192\u0006\u00105\u001a\u000203H\u0002J\u0010\u0010E\u001a\u00020\u00192\u0006\u00105\u001a\u000203H\u0002J\b\u0010F\u001a\u00020\rH\u0002J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00170\u0003H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00030\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder;", "", "tags", "", "Lcom/intellij/psi/xml/XmlTag;", "<init>", "(Ljava/util/List;)V", "sourceFile", "Lcom/intellij/psi/xml/XmlFile;", "scriptTag", "mode", "Lorg/jetbrains/vuejs/model/VueMode;", "scriptLanguage", "", "templateLanguage", "styleTags", "unusedStylesInExistingComponent", "Lcom/intellij/psi/css/CssSelectorSuffix;", "componentsImportMap", "", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportDeclaration;", "refDataMap", "", "Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder$RefData;", "processVueComponent", "", "ref", "Lcom/intellij/psi/impl/source/xml/TagNameReference;", "gatherReferences", "addElementReferences", "element", "Lcom/intellij/psi/PsiElement;", "tag", "offset", "", "generateNewTemplateContents", "hasDirectUsage", "", "findTemplate", "createNewComponent", "Lcom/intellij/openapi/vfs/VirtualFile;", "newComponentName", "generateNewComponentText", "createTag", "name", "attributes", "content", "psiOperationOnText", "text", "operation", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiFile;", "findStyles", "file", "optimizeAndRemoveEmptyStyles", "hasMeaningfulChildren", "", "langAttribute", "lang", "generateImports", "compositionComponentDeclaration", "optionsComponentDeclaration", "componentName", "modifyCurrentComponent", "currentFile", "newPsiFile", "replaceWithNewTag", "replaceName", "cleanupOptionsComponentDeclaration", "optimizeUnusedComponentsAndImports", "generateProps", "getPropReferences", "RefData", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueExtractComponentDataBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueExtractComponentDataBuilder.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,474:1\n66#2,2:475\n66#2,2:477\n477#3:479\n183#3:480\n1255#3,2:481\n184#3:483\n477#3:499\n1321#3,2:500\n622#3:532\n1321#3,2:533\n1869#4,2:484\n1563#4:489\n1634#4,3:490\n1563#4:493\n1634#4,3:494\n774#4:502\n865#4,2:503\n774#4:505\n865#4,2:506\n1869#4,2:508\n1056#4:510\n1869#4,2:511\n1869#4,2:521\n1669#4,8:523\n1056#4:531\n3919#5:486\n4434#5,2:487\n11561#5:514\n11896#5,3:515\n3919#5:518\n4434#5,2:519\n1#6:497\n19#7:498\n19#7:513\n*S KotlinDebug\n*F\n+ 1 VueExtractComponentDataBuilder.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder\n*L\n70#1:475,2\n74#1:477,2\n91#1:479\n92#1:480\n96#1:481,2\n92#1:483\n265#1:499\n273#1:500,2\n156#1:532\n157#1:533,2\n117#1:484,2\n137#1:489\n137#1:490,3\n227#1:493\n227#1:494,3\n276#1:502\n276#1:503,2\n277#1:505\n277#1:506,2\n278#1:508,2\n295#1:510\n374#1:511,2\n408#1:521,2\n428#1:523,8\n429#1:531\n136#1:486\n136#1:487,2\n389#1:514\n389#1:515,3\n407#1:518\n407#1:519,2\n260#1:498\n382#1:513\n*E\n"})
public final class VueExtractComponentDataBuilder {
    @NotNull
    private final List<XmlTag> tags;
    @NotNull
    private final XmlFile sourceFile;
    @Nullable
    private final XmlTag scriptTag;
    @Nullable
    private final VueMode mode;
    @Nullable
    private final String scriptLanguage;
    @Nullable
    private final String templateLanguage;
    @NotNull
    private final List<XmlTag> styleTags;
    @NotNull
    private List<? extends CssSelectorSuffix> unusedStylesInExistingComponent;
    @NotNull
    private final Map<String, ES6ImportDeclaration> componentsImportMap;
    @NotNull
    private final Map<XmlTag, List<RefData>> refDataMap;

    /*
     * WARNING - void declaration
     */
    public VueExtractComponentDataBuilder(@NotNull List<? extends XmlTag> tags) {
        Map map;
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.tags = tags;
        PsiFile psiFile = this.tags.get(0).getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        this.sourceFile = (XmlFile)psiFile;
        XmlTag xmlTag = VueFrameworkHandlerKt.findScriptTag(this.sourceFile, true);
        if (xmlTag == null) {
            xmlTag = this.scriptTag = VueFrameworkHandlerKt.findScriptTag(this.sourceFile, false);
        }
        this.mode = VueFrameworkHandlerKt.isScriptVaporTag(this.scriptTag) ? VueMode.VAPOR : (VueFrameworkHandlerKt.isScriptSetupTag(this.scriptTag) ? VueMode.CLASSIC : null);
        this.scriptLanguage = VueUtilKt.detectLanguage(this.scriptTag);
        this.templateLanguage = VueUtilKt.detectLanguage(this.findTemplate());
        this.styleTags = this.findStyles((PsiFile)this.sourceFile);
        this.unusedStylesInExistingComponent = CollectionsKt.emptyList();
        this.componentsImportMap = new LinkedHashMap();
        Map map2 = map = MapsKt.createMapBuilder();
        VueExtractComponentDataBuilder vueExtractComponentDataBuilder = this;
        boolean bl = false;
        for (RefData refData : this.gatherReferences()) {
            void $this$refDataMap_u24lambda_u240;
            PsiLanguageInjectionHost host;
            PsiElement resolved;
            if (refData.getRef() instanceof TagNameReference) {
                this.processVueComponent((TagNameReference)refData.getRef());
                continue;
            }
            if (refData.resolve() == null) continue;
            PsiElement $this$parentOfType_u24default$iv = resolved;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, XmlTag.class, (boolean)true);
            if (parentTag == null && VueExprLanguagesKt.isVueExprMetaLanguage((Language)resolved.getLanguage()) && (host = InjectedLanguageManager.getInstance((Project)this.tags.get(0).getProject()).getInjectionHost(resolved)) != null) {
                PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)host;
                boolean withSelf$iv2 = false;
                boolean $i$f$parentOfType2 = false;
                parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, XmlTag.class, (boolean)true);
            }
            if ((this.scriptTag == null || !Intrinsics.areEqual((Object)parentTag, (Object)this.scriptTag)) && !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)parentTag), (PsiElement)((PsiElement)refData.getTag()), (boolean)true)) continue;
            $this$refDataMap_u24lambda_u240.compute(refData.getTag(), (arg_0, arg_1) -> VueExtractComponentDataBuilder.refDataMap$lambda$0$1((arg_0, arg_1) -> VueExtractComponentDataBuilder.refDataMap$lambda$0$0(refData, arg_0, arg_1), arg_0, arg_1));
        }
        vueExtractComponentDataBuilder.refDataMap = MapsKt.build((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    private final void processVueComponent(TagNameReference ref) {
        ES6ImportDeclaration eS6ImportDeclaration;
        Object v4;
        Object object;
        block4: {
            void $this$firstOrNull$iv;
            Sequence $this$filterIsInstance$iv;
            String string = ref.getNameElement().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String name = VueUtilKt.fromAsset$default(string, false, 2, null);
            object = new Boolean[]{false, true};
            object = SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])object), arg_0 -> VueExtractComponentDataBuilder.processVueComponent$lambda$0(this, arg_0)), VueExtractComponentDataBuilder::processVueComponent$lambda$1);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processVueComponent$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = sequence;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)element$iv;
                    boolean bl2 = false;
                    ES6ImportedBinding[] eS6ImportedBindingArray = importDeclaration.getImportedBindings();
                    Intrinsics.checkNotNullExpressionValue((Object)eS6ImportedBindingArray, (String)"getImportedBindings(...)");
                    Sequence sequence2 = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])eS6ImportedBindingArray), VueExtractComponentDataBuilder::processVueComponent$lambda$2$0), VueExtractComponentDataBuilder::processVueComponent$lambda$2$1);
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)VueUtilKt.fromAsset$default(it, false, 2, null), (Object)name)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        if ((eS6ImportDeclaration = (ES6ImportDeclaration)v4) == null) {
            return;
        }
        object = this.componentsImportMap;
        String string = ref.getNameElement().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = VueUtilKt.toAsset(string, true);
        Iterator iterator = eS6ImportDeclaration;
        object.put(string2, iterator);
    }

    private final List<RefData> gatherReferences() {
        List refs = new ArrayList();
        InjectedLanguageManager injManager = InjectedLanguageManager.getInstance((Project)this.tags.get(0).getProject());
        for (XmlTag tag : this.tags) {
            Collection hosts;
            PsiTreeUtil.processElements((PsiElement)((PsiElement)tag), (PsiElementProcessor)new PsiElementProcessor(refs, this, tag){
                final /* synthetic */ List<RefData> $refs;
                final /* synthetic */ VueExtractComponentDataBuilder this$0;
                final /* synthetic */ XmlTag $tag;
                {
                    this.$refs = $refs;
                    this.this$0 = $receiver;
                    this.$tag = $tag;
                }

                public final boolean execute(PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$refs.addAll(VueExtractComponentDataBuilder.access$addElementReferences(this.this$0, it, this.$tag, 0));
                    return true;
                }
            });
            int tagOffset = tag.getTextRange().getStartOffset();
            Intrinsics.checkNotNullExpressionValue((Object)PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)tag), PsiLanguageInjectionHost.class), (String)"findChildrenOfType(...)");
            for (PsiLanguageInjectionHost host : hosts) {
                List list = injManager.getInjectedPsiFiles((PsiElement)host);
                if (list == null) continue;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)element$iv;
                    boolean bl = false;
                    PsiTreeUtil.processElements((PsiElement)((PsiElement)pair.first), (PsiElementProcessor)new PsiElementProcessor(host, tagOffset, refs, this, tag, (com.intellij.openapi.util.Pair<PsiElement, TextRange>)pair){
                        final /* synthetic */ PsiLanguageInjectionHost $host;
                        final /* synthetic */ int $tagOffset;
                        final /* synthetic */ List<RefData> $refs;
                        final /* synthetic */ VueExtractComponentDataBuilder this$0;
                        final /* synthetic */ XmlTag $tag;
                        final /* synthetic */ com.intellij.openapi.util.Pair<PsiElement, TextRange> $pair;
                        {
                            this.$host = $host;
                            this.$tagOffset = $tagOffset;
                            this.$refs = $refs;
                            this.this$0 = $receiver;
                            this.$tag = $tag;
                            this.$pair = $pair;
                        }

                        public final boolean execute(PsiElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            int offset = this.$host.getTextRange().getStartOffset() - this.$tagOffset;
                            this.$refs.addAll(VueExtractComponentDataBuilder.access$addElementReferences(this.this$0, element, this.$tag, offset + ((TextRange)this.$pair.second).getStartOffset()));
                            return true;
                        }
                    });
                }
            }
        }
        return refs;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RefData> addElementReferences(PsiElement element, XmlTag tag, int offset) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        PsiReference[] psiReferenceArray = element.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Object[] objectArray = psiReferenceArray;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (PsiReference element$iv$iv : $this$filterTo$iv$iv) {
            PsiReference it = element$iv$iv;
            boolean bl = false;
            PsiElement psiElement = it instanceof PsiElement ? (PsiElement)it : null;
            if (!(!((psiElement != null ? psiElement.getParent() : null) instanceof PsiReference))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiReference element$iv$iv;
            element$iv$iv = (PsiReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new RefData((PsiReference)it, tag, offset));
        }
        return (List)destination$iv$iv;
    }

    private final String generateNewTemplateContents(Set<String> hasDirectUsage) {
        return CollectionsKt.joinToString$default((Iterable)this.tags, (CharSequence)"", null, null, (int)0, null, arg_0 -> VueExtractComponentDataBuilder.generateNewTemplateContents$lambda$0(this, hasDirectUsage, arg_0), (int)30, null);
    }

    private final XmlTag findTemplate() {
        return (XmlTag)PsiTreeUtil.findFirstParent((PsiElement)((PsiElement)CollectionsKt.first(this.tags)), arg_0 -> VueExtractComponentDataBuilder.findTemplate$lambda$1(VueExtractComponentDataBuilder::findTemplate$lambda$0, arg_0));
    }

    @Nullable
    public final VirtualFile createNewComponent(@NotNull String newComponentName) {
        Intrinsics.checkNotNullParameter((Object)newComponentName, (String)"newComponentName");
        String newText = this.generateNewComponentText(newComponentName);
        PsiDirectory psiDirectory = this.sourceFile.getParent();
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory folder = psiDirectory;
        VirtualFile virtualFile = folder.getVirtualFile().createChildData((Object)this, VueUtilKt.toAsset(newComponentName, true) + ".vue");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildData(...)");
        VirtualFile virtualFile2 = virtualFile;
        VfsUtil.saveText((VirtualFile)virtualFile2, (String)newText);
        return virtualFile2;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateNewComponentText(String newComponentName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Boolean existing;
        List<RefData> dataList;
        Set set;
        Set $this$generateNewComponentText_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean $i$a$-buildSet-VueExtractComponentDataBuilder$generateNewComponentText$hasDirectUsage$22 = false;
        Object hasReplaceMap = (Object[])new LinkedHashMap();
        Iterator<Map.Entry<XmlTag, List<RefData>>> iterator = this.refDataMap.entrySet().iterator();
        block4: while (iterator.hasNext()) {
            dataList = iterator.next().getValue();
            for (RefData data : dataList) {
                boolean state2 = data.getReplaceRange() == null;
                String refName = data.getRefName();
                existing = (Boolean)hasReplaceMap.get(refName);
                if (existing != null && !Intrinsics.areEqual((Object)state2, (Object)existing)) {
                    $this$generateNewComponentText_u24lambda_u240.add(refName);
                    continue block4;
                }
                hasReplaceMap.put(refName, state2);
            }
        }
        Set hasDirectUsage = SetsKt.build((Set)set);
        String componentDeclaration = this.mode != null ? this.compositionComponentDeclaration(hasDirectUsage) : this.optionsComponentDeclaration(newComponentName, hasDirectUsage);
        Object[] $i$a$-buildSet-VueExtractComponentDataBuilder$generateNewComponentText$hasDirectUsage$22 = new String[2];
        VueMode vueMode = this.mode;
        $i$a$-buildSet-VueExtractComponentDataBuilder$generateNewComponentText$hasDirectUsage$22[0] = switch (vueMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[vueMode.ordinal()]) {
            case 1 -> "setup";
            case 2 -> "vapor";
            default -> null;
        };
        $i$a$-buildSet-VueExtractComponentDataBuilder$generateNewComponentText$hasDirectUsage$22[1] = this.langAttribute(this.scriptLanguage);
        List scriptAttributes = CollectionsKt.listOfNotNull((Object[])$i$a$-buildSet-VueExtractComponentDataBuilder$generateNewComponentText$hasDirectUsage$22);
        hasReplaceMap = new String[]{this.generateImports(), componentDeclaration};
        String scriptContent = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])hasReplaceMap), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        hasReplaceMap = new String[]{this.createTag("script", scriptAttributes, scriptContent), this.createTag("template", CollectionsKt.listOfNotNull((Object)this.langAttribute(this.templateLanguage)), this.generateNewTemplateContents(hasDirectUsage))};
        Sequence sequence = SequencesKt.sequenceOf((Object[])hasReplaceMap);
        hasReplaceMap = this.styleTags;
        Sequence sequence2 = sequence;
        boolean $i$f$map = false;
        dataList = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            existing = (XmlTag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getText());
        }
        String text = SequencesKt.joinToString$default((Sequence)SequencesKt.plus((Sequence)sequence2, (Iterable)((List)destination$iv$iv)), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        text = this.psiOperationOnText(text, (Function1<? super PsiFile, Unit>)((Function1)new Function1<PsiFile, Unit>((Object)this){

            public final void invoke(PsiFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                VueExtractComponentDataBuilder.access$optimizeAndRemoveEmptyStyles((VueExtractComponentDataBuilder)this.receiver, p0);
            }
        }));
        boolean bl2 = false;
        return this.psiOperationOnText(text, (Function1<? super PsiFile, Unit>)((Function1)arg_0 -> VueExtractComponentDataBuilder.generateNewComponentText$lambda$3$0(this, arg_0)));
    }

    private final String createTag(String name, List<String> attributes, String content) {
        Object[] objectArray = new String[]{"<" + name + "  " + CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ">", content, "</" + name + ">"};
        return SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.sequenceOf((Object[])objectArray), VueExtractComponentDataBuilder::createTag$lambda$0), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String psiOperationOnText(String text, Function1<? super PsiFile, Unit> operation) {
        Project project = this.sourceFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VueFile vueFile = VueUtilKt.createVueFileFromText(project, text);
        operation.invoke((Object)vueFile);
        String string = vueFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final List<XmlTag> findStyles(PsiFile file) {
        XmlFile xmlFile;
        PsiFile $this$asSafely$iv = file;
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        if ((xmlFile = (XmlFile)psiFile) == null || ($this$asSafely$iv = xmlFile.getDocument()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile document = $this$asSafely$iv;
        PsiElement[] psiElementArray = document.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])psiElementArray);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findStyles$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, VueExtractComponentDataBuilder::findStyles$lambda$0));
    }

    private final void optimizeAndRemoveEmptyStyles(PsiFile file) {
        Iterable $this$filterTo$iv$iv;
        Object element$iv;
        List list = CssUnusedSymbolUtils.getUnusedStyles((PsiFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUnusedStyles(...)");
        Object $this$forEach$iv = SequencesKt.minus((Sequence)CollectionsKt.asSequence((Iterable)list), (Iterable)this.unusedStylesInExistingComponent);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            PsiElement p0 = (PsiElement)element$iv;
            boolean bl = false;
            RemoveUnusedSymbolIntentionAction.removeUnused((PsiElement)p0);
        }
        Iterable $this$filter$iv = this.findStyles(file);
        boolean $i$f$filter = false;
        iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XmlTag it = (XmlTag)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XmlTag styleTag = (XmlTag)element$iv$iv;
            boolean bl = false;
            if (!PsiTreeUtil.processElements((PsiElement)((PsiElement)styleTag), (PsiElementProcessor)new PsiElementProcessor(this){
                final /* synthetic */ VueExtractComponentDataBuilder this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean execute(PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)CssElementTypes.CSS_RULESET_LIST, (Object)it.getNode().getElementType()) || !VueExtractComponentDataBuilder.access$hasMeaningfulChildren(this.this$0, it);
                }
            })) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            XmlTag it = (XmlTag)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    private final boolean hasMeaningfulChildren(PsiElement element) {
        PsiElement[] psiElementArray = element.getChildren();
        return !PsiTreeUtil.processElements((PsiElementProcessor)hasMeaningfulChildren.1.INSTANCE, (PsiElement[])Arrays.copyOf(psiElementArray, psiElementArray.length));
    }

    private final String langAttribute(String lang) {
        String string = lang;
        return string != null ? "lang=\"" + string + "\"" : null;
    }

    private final String generateImports() {
        if (this.componentsImportMap.isEmpty()) {
            return null;
        }
        Iterable $this$sortedBy$iv = this.componentsImportMap.entrySet();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, VueExtractComponentDataBuilder::generateImports$lambda$1, (int)30, null);
    }

    private final String compositionComponentDeclaration(Set<String> hasDirectUsage) {
        if (this.refDataMap.isEmpty()) {
            return null;
        }
        String props = CollectionsKt.joinToString$default((Iterable)this.getPropReferences(), (CharSequence)"\n", (CharSequence)"{\n", (CharSequence)"\n}", (int)0, null, arg_0 -> VueExtractComponentDataBuilder.compositionComponentDeclaration$lambda$0(hasDirectUsage, arg_0), (int)24, null);
        return "defineProps(" + props + ")";
    }

    private final String optionsComponentDeclaration(String componentName, Set<String> hasDirectUsage) {
        List list;
        List $this$optionsComponentDeclaration_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$optionsComponentDeclaration_u24lambda_u240.add(TuplesKt.to((Object)"name", (Object)("'" + componentName + "'")));
        if (!this.componentsImportMap.isEmpty()) {
            String components = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.componentsImportMap.keySet()), (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null);
            $this$optionsComponentDeclaration_u24lambda_u240.add(TuplesKt.to((Object)"components", (Object)components));
        }
        if (!this.refDataMap.isEmpty()) {
            String props = CollectionsKt.joinToString$default((Iterable)this.getPropReferences(), (CharSequence)",\n", (CharSequence)"{\n", (CharSequence)"\n}", (int)0, null, arg_0 -> VueExtractComponentDataBuilder.optionsComponentDeclaration$lambda$0$0(hasDirectUsage, arg_0), (int)24, null);
            $this$optionsComponentDeclaration_u24lambda_u240.add(TuplesKt.to((Object)"props", (Object)props));
        }
        String members = CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)list), (CharSequence)",\n", null, null, (int)0, null, VueExtractComponentDataBuilder::optionsComponentDeclaration$lambda$1, (int)30, null);
        return StringsKt.trimIndent((String)("\n    export default {\n      " + members + "\n    }\n    "));
    }

    public final void modifyCurrentComponent(@NotNull String newComponentName, @NotNull PsiFile currentFile, @NotNull PsiFile newPsiFile) {
        Intrinsics.checkNotNullParameter((Object)newComponentName, (String)"newComponentName");
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)newPsiFile, (String)"newPsiFile");
        VueComponentSourceEdit vueComponentSourceEdit = VueComponentSourceEdit.Companion.create(VueModelManager.Companion.findEnclosingContainer((PsiElement)currentFile));
        if (vueComponentSourceEdit != null) {
            vueComponentSourceEdit.insertComponentImport(newComponentName, (PsiElement)newPsiFile);
        }
        this.optimizeUnusedComponentsAndImports(currentFile);
    }

    @NotNull
    public final XmlTag replaceWithNewTag(@NotNull String replaceName) {
        Intrinsics.checkNotNullParameter((Object)replaceName, (String)"replaceName");
        List list = CssUnusedSymbolUtils.getUnusedStyles((PsiFile)((PsiFile)this.sourceFile));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUnusedStyles(...)");
        this.unusedStylesInExistingComponent = list;
        XmlTag leader = this.tags.get(0);
        String newTagName = VueUtilKt.toAsset(replaceName, true);
        Object[] objectArray = new String[]{"pug", "jade"};
        String replaceText = CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)this.templateLanguage) ? "<template lang=\"pug\">\n" + newTagName + "(" + this.generateProps() + ")\n</template>" : "<template><" + newTagName + " " + this.generateProps() + "/></template>";
        Project project = leader.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VueFile dummyFile = VueUtilKt.createVueFileFromText(project2, replaceText);
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)dummyFile), XmlTag.class);
        Intrinsics.checkNotNull((Object)psiElement);
        XmlTag template = (XmlTag)psiElement;
        PsiElement psiElement2 = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)template), XmlTag.class);
        Intrinsics.checkNotNull((Object)psiElement2);
        XmlTag newTag = (XmlTag)psiElement2;
        PsiElement psiElement3 = leader.replace((PsiElement)newTag);
        Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
        XmlTag newlyAdded = (XmlTag)psiElement3;
        Iterable $this$forEach$iv = this.tags.subList(1, this.tags.size());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XmlTag it = (XmlTag)element$iv;
            boolean bl = false;
            it.delete();
        }
        return newlyAdded;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void cleanupOptionsComponentDeclaration(PsiFile file) {
        var3_2 = VueUtilKt.objectLiteralFor(VueUtilKt.findDefaultExport((PsiElement)VueFrameworkHandlerKt.findModule((PsiElement)file, false)));
        if (var3_2 == null || (var4_3 = var3_2.findProperty("components")) == null || (var5_4 = var4_3.getValue()) == null) ** GOTO lbl-1000
        var7_6 = var5_4;
        $i$f$asSafely = false;
        v0 = $this$asSafely$iv;
        if (!(v0 instanceof JSObjectLiteralExpression)) {
            v0 = null;
        }
        if ((var6_11 = (JSObjectLiteralExpression)v0) != null && ($this$asSafely$iv = var6_11.getProperties()) != null) {
            it = $i$f$asSafely = $this$asSafely$iv;
            $i$a$-takeIf-VueExtractComponentDataBuilder$cleanupOptionsComponentDeclaration$componentInitializers$1 = false;
            v1 /* !! */  = !(it.length == 0) ? $i$f$asSafely : null;
        } else lbl-1000:
        // 2 sources

        {
            v1 /* !! */  = null;
        }
        v2 = componentInitializers = v1 /* !! */ ;
        if (componentInitializers == null) {
            return;
        }
        var4_3 = componentInitializers;
        $i$f$map = false;
        var6_11 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>($this$map$iv.length);
        $i$f$mapTo = false;
        var10_14 = ((void)$this$mapTo$iv$iv).length;
        for (it = 0; it < var10_14; ++it) {
            var12_17 = item$iv$iv = $this$mapTo$iv$iv[it];
            var14_19 = destination$iv$iv;
            $i$a$-map-VueExtractComponentDataBuilder$cleanupOptionsComponentDeclaration$names$1 = false;
            v3 = it.getName();
            if (v3 == null) {
                v3 = "";
            }
            var14_19.add(VueUtilKt.toAsset(v3, true));
        }
        names = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        (XmlFile)file;
        file.accept((PsiElementVisitor)new VueFileVisitor(names, this){
            final /* synthetic */ Set<String> $names;
            final /* synthetic */ VueExtractComponentDataBuilder this$0;
            {
                this.$names = $names;
                this.this$0 = $receiver;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof XmlTag) {
                    String string = ((XmlTag)element).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.$names.remove(VueUtilKt.toAsset(string, true));
                }
                if (!Intrinsics.areEqual((Object)VueExtractComponentDataBuilder.access$getScriptTag$p(this.this$0), (Object)element)) {
                    this.recursion(element);
                }
            }
        });
        $this$map$iv = componentInitializers;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var10_14 = ((void)$this$filterTo$iv$iv).length;
        for (it = 0; it < var10_14; ++it) {
            it = element$iv$iv = $this$filterTo$iv$iv[it];
            $i$a$-filter-VueExtractComponentDataBuilder$cleanupOptionsComponentDeclaration$2 = false;
            if (it.getName() == null) ** GOTO lbl-1000
            v4 = it.getName();
            Intrinsics.checkNotNull((Object)v4);
            if (names.contains(VueUtilKt.toAsset(v4, true))) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (JSProperty)element$iv;
            $i$a$-forEach-VueExtractComponentDataBuilder$cleanupOptionsComponentDeclaration$3 = false;
            it.delete();
        }
    }

    private final void optimizeUnusedComponentsAndImports(PsiFile file) {
        if (this.mode == null) {
            this.cleanupOptionsComponentDeclaration(file);
        }
        ES6CreateImportUtil.optimizeImports((PsiElement)((PsiElement)file));
        this.optimizeAndRemoveEmptyStyles(file);
    }

    private final String generateProps() {
        return CollectionsKt.joinToString$default((Iterable)this.getPropReferences(), (CharSequence)" ", null, null, (int)0, null, VueExtractComponentDataBuilder::generateProps$lambda$0, (int)30, null);
    }

    private final List<RefData> getPropReferences() {
        Iterable $this$distinctBy$iv = CollectionsKt.flatten((Iterable)this.refDataMap.values());
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            RefData it = (RefData)e$iv;
            boolean bl = false;
            String key$iv = it.getRefName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Iterable $this$sortedBy$iv = list$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RefData it = (RefData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getRefName());
                it = (RefData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getRefName())));
            }
        });
    }

    private static final List refDataMap$lambda$0$0(RefData $refData, XmlTag xmlTag, List oldValue) {
        Intrinsics.checkNotNullParameter((Object)xmlTag, (String)"<unused var>");
        List list = oldValue;
        return list != null ? CollectionsKt.plus((Collection)list, (Object)$refData) : CollectionsKt.listOf((Object)$refData);
    }

    private static final List refDataMap$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }

    private static final JSExecutionScope processVueComponent$lambda$0(VueExtractComponentDataBuilder this$0, boolean setup) {
        return VueFrameworkHandlerKt.findModule((PsiElement)this$0.scriptTag, setup);
    }

    private static final Sequence processVueComponent$lambda$1(JSExecutionScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement[] psiElementArray = JSResolveUtil.getStubbedChildren((PsiElement)((PsiElement)it), (TokenSet)ES6ImportPsiUtil.ES6_IMPORT_DECLARATION);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getStubbedChildren(...)");
        return ArraysKt.asSequence((Object[])psiElementArray);
    }

    private static final boolean processVueComponent$lambda$2$0(ES6ImportedBinding it) {
        return !it.isNamespaceImport();
    }

    private static final String processVueComponent$lambda$2$1(ES6ImportedBinding it) {
        return it.getName();
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence generateNewTemplateContents$lambda$0(VueExtractComponentDataBuilder this$0, Set $hasDirectUsage, XmlTag tag) {
        void $this$forEach$iv;
        Sequence $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<RefData> list = this$0.refDataMap.get(tag);
        if (list == null) {
            String string = tag.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        List<RefData> dataList = list;
        StringBuilder builder2 = new StringBuilder(tag.getText());
        int tagStart = tag.getTextRange().getStartOffset();
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)dataList), arg_0 -> VueExtractComponentDataBuilder.generateNewTemplateContents$lambda$0$0($hasDirectUsage, arg_0)), arg_0 -> VueExtractComponentDataBuilder.generateNewTemplateContents$lambda$0$1(tagStart, arg_0));
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                Object object = pair.component1();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
                TextRange range = (TextRange)object;
                pair = (Pair)a;
                Comparable comparable = Integer.valueOf(range.getStartOffset());
                bl = false;
                Object object2 = pair.component1();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component1(...)");
                range = (TextRange)object2;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(range.getStartOffset()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Object object = pair.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            TextRange range = (TextRange)object;
            String name = (String)pair.component2();
            builder2.replace(range.getStartOffset(), range.getEndOffset(), name);
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean generateNewTemplateContents$lambda$0$0(Set $hasDirectUsage, RefData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$hasDirectUsage.contains(it.getRefName());
    }

    private static final Pair generateNewTemplateContents$lambda$0$1(int $tagStart, RefData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TextRange textRange = it.getReplaceRange();
        if (textRange == null) {
            return null;
        }
        TextRange absRange = textRange;
        return new Pair((Object)absRange.shiftLeft($tagStart), (Object)it.getRefName());
    }

    private static final boolean findTemplate$lambda$0(PsiElement it) {
        XmlTag xmlTag = it instanceof XmlTag ? (XmlTag)it : null;
        return Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"template");
    }

    private static final boolean findTemplate$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit generateNewComponentText$lambda$3$0(VueExtractComponentDataBuilder this$0, PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeStyleManager.getInstance((Project)this$0.sourceFile.getProject()).reformatText(file, 0, file.getTextRange().getEndOffset());
        return Unit.INSTANCE;
    }

    private static final boolean createTag$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final boolean findStyles$lambda$0(XmlTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)"style");
    }

    private static final CharSequence generateImports$lambda$1(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String name = (String)entry.getKey();
        ES6ImportDeclaration declaration = (ES6ImportDeclaration)entry.getValue();
        Object object = declaration.getFromClause();
        if (object == null || (object = object.getReferenceText()) == null) {
            object = "''";
        }
        return "import " + name + " from " + (String)object;
    }

    private static final CharSequence compositionComponentDeclaration$lambda$0(Set $hasDirectUsage, RefData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String type = $hasDirectUsage.contains(it.getRefName()) ? "{ type: Function }" : "{}";
        return it.getRefName() + ": " + type + ",";
    }

    private static final CharSequence optionsComponentDeclaration$lambda$0$0(Set $hasDirectUsage, RefData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String type = $hasDirectUsage.contains(it.getRefName()) ? "{ type: Function }" : "{}";
        return it.getRefName() + ": " + type;
    }

    private static final CharSequence optionsComponentDeclaration$lambda$1(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String name = (String)pair.component1();
        String value = (String)pair.component2();
        return name + ": " + value;
    }

    private static final CharSequence generateProps$lambda$0(RefData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ":" + VueUtilKt.fromAsset$default(it.getRefName(), false, 2, null) + "=\"" + it.getExpressionText() + "\"";
    }

    public static final /* synthetic */ List access$addElementReferences(VueExtractComponentDataBuilder $this, PsiElement element, XmlTag tag, int offset) {
        return $this.addElementReferences(element, tag, offset);
    }

    public static final /* synthetic */ XmlTag access$getScriptTag$p(VueExtractComponentDataBuilder $this) {
        return $this.scriptTag;
    }

    public static final /* synthetic */ void access$optimizeAndRemoveEmptyStyles(VueExtractComponentDataBuilder $this, PsiFile file) {
        $this.optimizeAndRemoveEmptyStyles(file);
    }

    public static final /* synthetic */ boolean access$hasMeaningfulChildren(VueExtractComponentDataBuilder $this, PsiElement element) {
        return $this.hasMeaningfulChildren(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0016\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder$RefData;", "", "ref", "Lcom/intellij/psi/PsiReference;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "offset", "", "<init>", "(Lcom/intellij/psi/PsiReference;Lcom/intellij/psi/xml/XmlTag;I)V", "getRef", "()Lcom/intellij/psi/PsiReference;", "getTag", "()Lcom/intellij/psi/xml/XmlTag;", "getOffset", "()I", "getRefName", "", "resolve", "Lcom/intellij/psi/PsiElement;", "getReplaceRange", "Lcom/intellij/openapi/util/TextRange;", "getExpressionText", "intellij.vuejs.backend"})
    @SourceDebugExtension(value={"SMAP\nVueExtractComponentDataBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueExtractComponentDataBuilder.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder$RefData\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,474:1\n19#2:475\n19#2:476\n19#2:477\n19#2:478\n19#2:479\n19#2:480\n*S KotlinDebug\n*F\n+ 1 VueExtractComponentDataBuilder.kt\norg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentDataBuilder$RefData\n*L\n441#1:475\n451#1:476\n456#1:477\n458#1:478\n466#1:479\n468#1:480\n*E\n"})
    private static final class RefData {
        @NotNull
        private final PsiReference ref;
        @NotNull
        private final XmlTag tag;
        private final int offset;

        public RefData(@NotNull PsiReference ref, @NotNull XmlTag tag, int offset) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.ref = ref;
            this.tag = tag;
            this.offset = offset;
        }

        @NotNull
        public final PsiReference getRef() {
            return this.ref;
        }

        @NotNull
        public final XmlTag getTag() {
            return this.tag;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final String getRefName() {
            String string;
            JSReferenceExpression jSReferenceExpression;
            Object object = this.ref;
            JSReferenceExpression jSReferenceExpression2 = object instanceof JSReferenceExpression ? (JSReferenceExpression)object : null;
            if (jSReferenceExpression2 == null) {
                String string2 = this.ref.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
                return string2;
            }
            JSReferenceExpression jsRef = jSReferenceExpression2;
            JSExpression $this$asSafely$iv = JSResolveUtil.getLeftmostQualifier((JSExpression)((JSExpression)jsRef));
            boolean $i$f$asSafely = false;
            JSExpression jSExpression = $this$asSafely$iv;
            if (!(jSExpression instanceof JSReferenceExpression)) {
                jSExpression = null;
            }
            if ((jSReferenceExpression = (JSReferenceExpression)jSExpression) != null && (object = jSReferenceExpression.getReferenceName()) != null) {
                string = object;
            } else {
                String string3 = ((JSReferenceExpression)this.ref).getCanonicalText();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCanonicalText(...)");
            }
            return string;
        }

        @Nullable
        public final PsiElement resolve() {
            JSReferenceExpression jSReferenceExpression;
            PsiReference psiReference = this.ref;
            JSReferenceExpression jSReferenceExpression2 = psiReference instanceof JSReferenceExpression ? (JSReferenceExpression)psiReference : null;
            if (jSReferenceExpression2 == null) {
                return this.ref.resolve();
            }
            JSReferenceExpression jsRef = jSReferenceExpression2;
            JSExpression $this$asSafely$iv = JSResolveUtil.getLeftmostQualifier((JSExpression)((JSExpression)jsRef));
            boolean $i$f$asSafely = false;
            JSExpression jSExpression = $this$asSafely$iv;
            if (!(jSExpression instanceof JSReferenceExpression)) {
                jSExpression = null;
            }
            return (jSReferenceExpression = (JSReferenceExpression)jSExpression) != null ? jSReferenceExpression.resolve() : null;
        }

        @Nullable
        public final TextRange getReplaceRange() {
            PsiElement psiElement;
            PsiReference $this$asSafely$iv = this.ref;
            boolean $i$f$asSafely = false;
            PsiReference psiReference = $this$asSafely$iv;
            if (!(psiReference instanceof PsiElement)) {
                psiReference = null;
            }
            PsiElement $this$asSafely$iv2 = (psiElement = (PsiElement)psiReference) != null ? psiElement.getParent() : null;
            boolean $i$f$asSafely2 = false;
            PsiElement psiElement2 = $this$asSafely$iv2;
            if (!(psiElement2 instanceof JSCallExpression)) {
                psiElement2 = null;
            }
            JSCallExpression jSCallExpression = (JSCallExpression)psiElement2;
            if (jSCallExpression == null) {
                return null;
            }
            JSCallExpression call = jSCallExpression;
            TextRange range = call.getTextRange();
            return new TextRange(this.offset + range.getStartOffset(), this.offset + range.getEndOffset());
        }

        @NotNull
        public final String getExpressionText() {
            JSCallExpression jSCallExpression;
            Object object;
            PsiReference $this$asSafely$iv = this.ref;
            boolean $i$f$asSafely = false;
            PsiReference psiReference = $this$asSafely$iv;
            if (!(psiReference instanceof PsiElement)) {
                psiReference = null;
            }
            PsiElement $this$asSafely$iv2 = (object = (PsiElement)psiReference) != null ? object.getParent() : null;
            boolean $i$f$asSafely2 = false;
            PsiElement psiElement = $this$asSafely$iv2;
            if (!(psiElement instanceof JSCallExpression)) {
                psiElement = null;
            }
            if ((jSCallExpression = (JSCallExpression)psiElement) == null || (object = jSCallExpression.getText()) == null) {
                return this.getRefName();
            }
            return object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VueMode.values().length];
            try {
                nArray[VueMode.CLASSIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueMode.VAPOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

