/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelImpl;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class JamAnnotationTypeUtilImpl
extends JamAnnotationTypeUtil {
    @NotNull
    private final Project myProject;

    public JamAnnotationTypeUtilImpl(@NotNull Project project) {
        if (project == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<PsiClass> getQualifierAnnotationTypesWithChildren(@NotNull Module module) {
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(1);
        }
        SmartList list = new SmartList();
        list.addAll(this.getAnnotationTypesWithChildren("org.springframework.beans.factory.annotation.Qualifier", module));
        list.addAll(this.getAnnotationTypesWithChildren("javax.inject.Qualifier", module));
        list.addAll(this.getImplicitQualifierAnnotations(module));
        SmartList smartList = list;
        if (smartList == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @NotNull
    public List<String> getQualifierAnnotationNamesWithChildren(@NotNull Module module) {
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(3);
        }
        SmartList list = new SmartList();
        list.addAll(this.getAnnotationNamesWithChildren("org.springframework.beans.factory.annotation.Qualifier", module));
        list.addAll(this.getAnnotationNamesWithChildren("javax.inject.Qualifier", module));
        list.addAll(ContainerUtil.mapNotNull(this.getImplicitQualifierAnnotations(module), PsiClass::getQualifiedName));
        SmartList smartList = list;
        if (smartList == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private Set<PsiClass> getImplicitQualifierAnnotations(@NotNull Module module) {
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(5);
        }
        return (Set)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, () -> {
            Set<String> fqns = JamAnnotationTypeUtilImpl.getImplicitQualifierAnnotationNames(module);
            if (fqns.isEmpty()) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{UastModificationTracker.getInstance((Project)this.myProject)});
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
            GlobalSearchScope moduleSearchScope = SpringGlobalSearchScopes.runtime((Module)module);
            Set types = ContainerUtil.map2SetNotNull(JamAnnotationTypeUtilImpl.getImplicitQualifierAnnotationNames(module), fqn -> {
                PsiClass psiClass = facade.findClass(fqn, moduleSearchScope);
                return psiClass != null && psiClass.isAnnotationType() ? psiClass : null;
            });
            return CachedValueProvider.Result.create((Object)types, (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)this.myProject), JavaLibraryModificationTracker.getInstance((Project)this.myProject)});
        });
    }

    private static Set<String> getImplicitQualifierAnnotationNames(@NotNull Module module) {
        PsiClass customAutowireConfigurerClass;
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(6);
        }
        if ((customAutowireConfigurerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.beans.factory.annotation.CustomAutowireConfigurer")) == null) {
            return Collections.emptySet();
        }
        HashSet<String> types = new HashSet<String>();
        Set<LocalXmlModel> models = SpringAutoConfiguredModels.getLocalXmlModelCandidates(module);
        for (LocalXmlModel model : models) {
            types.addAll(JamAnnotationTypeUtilImpl.getImplicitQualifierAnnotationNames((XmlFile)model.getConfig()));
        }
        return types;
    }

    private static Set<String> getImplicitQualifierAnnotationNames(XmlFile file) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
            PsiClass customAutowireConfigurerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.beans.factory.annotation.CustomAutowireConfigurer");
            if (customAutowireConfigurerClass == null) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{file, JavaLibraryModificationTracker.getInstance((Project)file.getProject())});
            }
            LocalXmlModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(file, module, Collections.emptySet());
            if (model == null) {
                Object[] dependencies = SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies();
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])ArrayUtil.prepend((Object)file, (Object[])dependencies));
            }
            SpringModelSearchParameters.BeanClass params = SpringModelSearchParameters.byClass((PsiClass)customAutowireConfigurerClass).withInheritors();
            HashSet result2 = new HashSet();
            Processor processor2 = pointer -> {
                CommonSpringBean bean = pointer.getSpringBean();
                SpringPropertyDefinition propertyDefinition = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"customQualifierTypes");
                if (!(propertyDefinition instanceof SpringProperty)) {
                    return true;
                }
                for (String value : SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)((SpringProperty)propertyDefinition))) {
                    if (StringUtil.isEmptyOrSpaces((String)value)) continue;
                    result2.add(value);
                }
                return true;
            };
            if (model instanceof LocalXmlModelImpl) {
                ((LocalXmlModelImpl)model).processLocalBeansByClass(params, processor2, true);
            } else {
                model.processLocalBeansByClass(params, processor2);
            }
            if (result2.isEmpty()) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{file});
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{file});
        });
    }

    @NotNull
    public List<String> getUserDefinedCustomComponentAnnotations(@NotNull Module module) {
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(7);
        }
        Collection<String> annotations = this.getCustomComponentAnnotations(module);
        HashSet<String> toRemove = new HashSet<String>();
        for (String defaultAnno : SpringSemContributorUtil.DEFAULT_SPRING_COMPONENTS) {
            if (defaultAnno.equals("org.springframework.stereotype.Component")) {
                toRemove.add(defaultAnno);
                continue;
            }
            toRemove.addAll(this.getAnnotationNamesWithChildren(defaultAnno, module));
        }
        List list = ContainerUtil.filter(annotations, a -> !toRemove.contains(a));
        if (list == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private Collection<String> getCustomComponentAnnotations(@NotNull Module module) {
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(9);
        }
        Collection<String> collection = this.getAnnotationNamesWithChildrenIncludingTests("org.springframework.stereotype.Component", module);
        if (collection == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull String annotationName, @NotNull Module module) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(11);
        }
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(12);
        }
        Collection<PsiClass> collection = JamAnnotationTypeUtilImpl.getAnnotationTypes(module, annotationName, false);
        if (collection == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    public Collection<PsiClass> getAnnotationTypesWithChildrenIncludingTests(@NotNull String annotationName, @NotNull Module module) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(14);
        }
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(15);
        }
        return JamAnnotationTypeUtilImpl.getAnnotationTypes(module, annotationName, true);
    }

    public Collection<String> getAnnotationNamesWithChildren(@NotNull String annotationName, @NotNull Module module) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(16);
        }
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(17);
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        return MetaAnnotationUtil.getAnnotationNamesWithChildren((Module)module, (String)annotationName, (boolean)false);
    }

    public Collection<String> getAnnotationNamesWithChildrenIncludingTests(@NotNull String annotationName, @NotNull Module module) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(18);
        }
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(19);
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        return MetaAnnotationUtil.getAnnotationNamesWithChildren((Module)module, (String)annotationName, (boolean)true);
    }

    private static Collection<PsiClass> getAnnotationTypes(@NotNull Module module, @NotNull String annotationName, boolean inTests) {
        if (module == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(20);
        }
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(21);
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        return MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)annotationName, (boolean)inTests);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotationTypesWithChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotationNamesWithChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedCustomComponentAnnotations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponentAnnotations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationTypesWithChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAnnotationTypesWithChildren";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAnnotationNamesWithChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitQualifierAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitQualifierAnnotationNames";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedCustomComponentAnnotations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponentAnnotations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildren";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildrenIncludingTests";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationNamesWithChildren";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationNamesWithChildrenIncludingTests";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 10, 13 -> new IllegalStateException(string);
        };
    }
}

