/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.hibernate.HibernateInspectionToolProvider;
import com.intellij.hibernate.facet.HibernateFacetConfiguration;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.hibernate.model.xml.config.HibernateConfiguration;
import com.intellij.hibernate.model.xml.config.SessionFactory;
import com.intellij.hibernate.model.xml.mapping.HbmHibernateMapping;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.jpa.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.JpaInspectionToolProvider;
import com.intellij.jpa.facet.JpaFacetImpl;
import com.intellij.jpa.facet.JpaFacetUtil;
import com.intellij.jpa.facet.JpaModuleConfiguration;
import com.intellij.jpa.highlighting.HibernateModelValidator;
import com.intellij.jpa.model.annotations.mapping.EntityMappingsImpl;
import com.intellij.jpa.model.common.MergedPersistenceMappings;
import com.intellij.jpa.model.xml.persistence.Persistence;
import com.intellij.jpa.model.xml.persistence.mapping.EntityMappings;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.ModifiablePersistenceFacet;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileAdapter;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValueUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HibernateFacet
extends Facet<HibernateFacetConfiguration>
implements ModifiablePersistenceFacet,
JpaModuleConfiguration {
    public static final FacetTypeId<HibernateFacet> ID = new FacetTypeId("hibernate");
    private final ConfigFileContainer myDescriptorsContainer;
    private EntityMappingsImpl myAnnotationsPersistenceRoot;
    private final JpaFacetImpl.UnitDataSourceMap myUnitDataSourceMap;
    private final JpaFacetImpl.UnitSettingMap myUnitNamingStrategyMap;
    private final CachedValue<List<PersistencePackage>> myUnitsValue;
    private static final Key<CachedValue<PersistencePackageDefaults>> SESSION_FACTORY_DEFAULTS = Key.create((String)"SESSION_FACTORY_DEFAULTS");

    @Nullable
    public static HibernateFacet getInstance(@NotNull Module module) {
        if (module == null) {
            HibernateFacet.$$$reportNull$$$0(0);
        }
        return (HibernateFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    public HibernateFacet(@NotNull FacetType<HibernateFacet, HibernateFacetConfiguration> facetType, @NotNull Module module, String name, @NotNull HibernateFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            HibernateFacet.$$$reportNull$$$0(1);
        }
        if (module == null) {
            HibernateFacet.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            HibernateFacet.$$$reportNull$$$0(3);
        }
        super(facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        this.myUnitDataSourceMap = new JpaFacetImpl.UnitDataSourceMap(configuration.getUnitToDataSourceMap(), (PersistenceFacet)this);
        this.myUnitNamingStrategyMap = new JpaFacetImpl.UnitSettingMap(this, configuration.getUnitToNamingStrategyMap(), (PersistenceFacet)this){

            @Nullable
            protected String getDefaultSettingValue(@NotNull PersistencePackage unit) {
                if (unit == null) {
                    1.$$$reportNull$$$0(0);
                }
                return unit.getModelHelper().getPersistenceUnitProperties().getProperty(HibernateUtil.getFullPropertyName("ejb.naming_strategy"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet$1", "getDefaultSettingValue"));
            }
        };
        this.myDescriptorsContainer = ConfigFileFactory.getInstance().createConfigFileContainer(this.getModule().getProject(), configuration.getDescriptorsConfiguration().getMetaDataProvider(), configuration.getDescriptorsConfiguration());
        this.myDescriptorsContainer.addListener((ConfigFileListener)new ConfigFileAdapter(){

            protected void configChanged(ConfigFile configFile) {
                FacetManager.getInstance((Module)HibernateFacet.this.getModule()).facetConfigurationChanged((Facet)HibernateFacet.this);
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myDescriptorsContainer);
        this.myUnitsValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> this.getPersistenceUnitsInner(), false);
    }

    public Icon getIcon() {
        return this.getType().getIcon();
    }

    @NotNull
    public List<PersistencePackage> getExtensionSessionFactories() {
        List list = ContainerUtil.concat((Iterable)PersistencePackagesProvider.EP_NAME.getExtensionList(), provider -> provider.getPersistencePackages((PersistenceFacet)this));
        if (list == null) {
            HibernateFacet.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<HibernateConfiguration> getHibernateConfigurations() {
        ArrayList<HibernateConfiguration> result = new ArrayList<HibernateConfiguration>();
        for (ConfigFile configFile : this.myDescriptorsContainer.getConfigFiles()) {
            if (configFile.getMetaData() != HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA) continue;
            ContainerUtil.addIfNotNull(result, (Object)((HibernateConfiguration)JamCommonUtil.getRootElement((PsiFile)configFile.getPsiFile(), HibernateConfiguration.class)));
        }
        ArrayList<HibernateConfiguration> arrayList = result;
        if (arrayList == null) {
            HibernateFacet.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public ModificationTracker getModificationTracker() {
        return FacetModificationTrackingService.getInstance((Project)this.myDescriptorsContainer.getProject()).getFacetModificationTracker((Facet)this);
    }

    public List<ConfigFile> getDescriptors() {
        return this.myDescriptorsContainer.getConfigFiles();
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myDescriptorsContainer;
    }

    @NotNull
    public List<PersistencePackage> getPersistenceUnits() {
        List list = (List)this.myUnitsValue.getValue();
        if (list == null) {
            HibernateFacet.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<PersistencePackage> getExplicitPersistenceUnits() {
        List list = (List)this.getPersistenceUnitsInner().getValue();
        if (list == null) {
            HibernateFacet.$$$reportNull$$$0(7);
        }
        return list;
    }

    private CachedValueProvider.Result<List<PersistencePackage>> getPersistenceUnitsInner() {
        ArrayList<PersistencePackage> result = new ArrayList<PersistencePackage>();
        for (HibernateConfiguration configuration : this.getHibernateConfigurations()) {
            result.add(configuration.getSessionFactory());
        }
        result.addAll(this.getExtensionSessionFactories());
        return new CachedValueProvider.Result(result, new Object[]{PsiModificationTracker.MODIFICATION_COUNT, FacetModificationTrackingService.getInstance((Project)this.getModule().getProject()).getFacetModificationTracker((Facet)this)});
    }

    @Nullable
    public com.intellij.jpa.model.common.persistence.mapping.EntityMappings getAnnotationEntityMappings() {
        this.refreshModel();
        return this.myAnnotationsPersistenceRoot;
    }

    @NotNull
    public PersistenceMappings getEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(8);
        }
        assert (unit.isValid());
        this.refreshModel();
        Collection xmlMappings = GenericValueUtil.getValueCollection((Collection)unit.getModelHelper().getMappingFiles(PersistenceMappings.class), new HashSet());
        ArrayList allMappings = new ArrayList();
        ContainerUtil.addIfNotNull(allMappings, (Object)this.getAnnotationEntityMappings(unit));
        ContainerUtil.addIfNotNull(allMappings, (Object)unit.getModelHelper().getAdditionalMapping());
        allMappings.addAll(xmlMappings);
        return allMappings.isEmpty() ? (PersistenceMappings)DomManager.getDomManager((Project)this.getModule().getProject()).createMockElement(HbmHibernateMapping.class, this.getModule(), true) : new MergedPersistenceMappings((PersistenceFacet)this, allMappings);
    }

    @NotNull
    public String getDefaultJPAProviderName() {
        return "Hibernate";
    }

    @Nullable
    public ConfigFile getDefaultORMDescriptor() {
        return null;
    }

    @Nullable
    public Persistence getMergedPersistenceRoot() {
        return JpaFacetUtil.getMergedPersistenceRoot((JpaModuleConfiguration)this);
    }

    public com.intellij.jpa.model.common.persistence.mapping.EntityMappings getAnnotationEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(9);
        }
        if (this.myAnnotationsPersistenceRoot != null) {
            Condition value = (Condition)JpaFacetImpl.getAnnoMappingsCondition((PersistenceFacet)this, (PersistencePackage)unit).getValue();
            return this.myAnnotationsPersistenceRoot.createCustomMappings(value);
        }
        return null;
    }

    @NotNull
    public List<XmlFile> getPersistenceXmls() {
        List<XmlFile> list = List.of();
        if (list == null) {
            HibernateFacet.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<PersistenceMappings> getDefaultEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(11);
        }
        List<PersistenceMappings> list = Collections.emptyList();
        if (list == null) {
            HibernateFacet.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public Class<SessionFactory> getPersistenceUnitClass() {
        return SessionFactory.class;
    }

    @NotNull
    public Map<ConfigFileMetaData, Class<? extends PersistenceMappings>> getSupportedDomMappingFormats() {
        LinkedHashMap<ConfigFileMetaData, Class<? extends PersistenceMappings>> map = new LinkedHashMap<ConfigFileMetaData, Class<? extends PersistenceMappings>>();
        map.put(HibernateDescriptorsConstants.HIBERNATE_MAPPING_META_DATA, HbmHibernateMapping.class);
        map.put(JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA, EntityMappings.class);
        LinkedHashMap<ConfigFileMetaData, Class<? extends PersistenceMappings>> linkedHashMap = map;
        if (linkedHashMap == null) {
            HibernateFacet.$$$reportNull$$$0(13);
        }
        return linkedHashMap;
    }

    public String getDataSourceId(@NotNull PersistencePackagePointer unit) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(14);
        }
        return this.myUnitDataSourceMap.getSettingValue(unit.getElementName());
    }

    public String getDataSourceId(@NotNull PersistencePackage unit) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(15);
        }
        return this.myUnitDataSourceMap.getDataSourceID(unit);
    }

    public void setDataSourceId(@NotNull PersistencePackage unit, String dataSourceName) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(16);
        }
        this.myUnitDataSourceMap.setDataSourceID(unit, dataSourceName);
        FacetManager.getInstance((Module)this.getModule()).facetConfigurationChanged((Facet)this);
    }

    public String getNamingStrategy(@NotNull PersistencePackage unit) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(17);
        }
        return this.myUnitNamingStrategyMap.getSettingValue(unit);
    }

    public void setNamingStrategy(@NotNull PersistencePackage unit, String namingStrategy) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(18);
        }
        this.myUnitNamingStrategyMap.setSettingValue(unit, namingStrategy);
        FacetManager.getInstance((Module)this.getModule()).facetConfigurationChanged((Facet)this);
    }

    public Language getQlLanguage() {
        return JpqlLanguage.HQL;
    }

    @NotNull
    public ModelValidator getModelValidator(@Nullable PersistencePackage unit) {
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)this, (PersistencePackage)unit, null);
        return new HibernateModelValidator(browser);
    }

    public Class<?> @NotNull [] getInspectionToolClasses() {
        Class[] classArray = (Class[])ArrayUtil.mergeArrays((Object[])new JpaInspectionToolProvider().getInspectionClasses(), (Object[])new HibernateInspectionToolProvider().getInspectionClasses());
        if (classArray == null) {
            HibernateFacet.$$$reportNull$$$0(19);
        }
        return classArray;
    }

    @NotNull
    public PersistencePackageDefaults getPersistenceUnitDefaults(@NotNull PersistencePackage unit) {
        if (unit == null) {
            HibernateFacet.$$$reportNull$$$0(20);
        }
        assert (unit.isValid());
        CachedValue cachedValue = (CachedValue)unit.getUserData(SESSION_FACTORY_DEFAULTS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)unit.getPsiManager().getProject()).createCachedValue(() -> {
                Properties properties = unit.getModelHelper().getPersistenceUnitProperties();
                final String schema = properties.getProperty(HibernateUtil.getFullPropertyName("default_schema"));
                final String catalog = properties.getProperty(HibernateUtil.getFullPropertyName("default_catalog"));
                PersistencePackageDefaults result = new PersistencePackageDefaults(){

                    @Nullable
                    public String getSchema() {
                        return schema;
                    }

                    @Nullable
                    public String getCatalog() {
                        return catalog;
                    }

                    @Nullable
                    public PropertyMemberType getAccess() {
                        return null;
                    }
                };
                PsiFile containingFile = unit.getContainingFile();
                return new CachedValueProvider.Result((Object)result, new Object[]{containingFile != null ? containingFile : ModificationTracker.EVER_CHANGED});
            }, false);
            unit.putUserData(SESSION_FACTORY_DEFAULTS, (Object)cachedValue);
        }
        PersistencePackageDefaults persistencePackageDefaults = (PersistencePackageDefaults)cachedValue.getValue();
        if (persistencePackageDefaults == null) {
            HibernateFacet.$$$reportNull$$$0(21);
        }
        return persistencePackageDefaults;
    }

    private void refreshModel() {
        boolean isJdk5;
        boolean bl = isJdk5 = LanguageLevel.JDK_1_5.compareTo((Enum)LanguageLevelUtil.getEffectiveLanguageLevel((Module)this.getModule())) <= 0;
        if (!this.getPersistenceUnits().isEmpty()) {
            if (isJdk5 && this.myAnnotationsPersistenceRoot == null) {
                this.myAnnotationsPersistenceRoot = new EntityMappingsImpl(this.getModule());
            }
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myAnnotationsPersistenceRoot == null) {
                this.myAnnotationsPersistenceRoot = new EntityMappingsImpl(this.getModule());
            }
        } else if (this.myAnnotationsPersistenceRoot != null) {
            this.myAnnotationsPersistenceRoot = null;
        }
    }

    public void initFacet() {
        JavaeeUtil.installDomAndJamListeners((Facet)this, (ConfigFileContainer)this.myDescriptorsContainer);
    }

    public void disposeFacet() {
        if (this.myAnnotationsPersistenceRoot != null) {
            this.myAnnotationsPersistenceRoot = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 10, 12, 13, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/facet/HibernateFacet";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/facet/HibernateFacet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionSessionFactories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHibernateConfigurations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnits";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitPersistenceUnits";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceXmls";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultEntityMappings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDomMappingFormats";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnitDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 21: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEntityMappings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationEntityMappings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEntityMappings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDataSourceId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNamingStrategy";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setNamingStrategy";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceUnitDefaults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 10, 12, 13, 19, 21 -> new IllegalStateException(string);
        };
    }
}

