/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.settings;

import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.typescript.lsp.JSExternalDefinitionsNodeDescriptor;
import com.intellij.lang.typescript.lsp.JSExternalDefinitionsPackageResolver;
import com.intellij.lang.typescript.lsp.JSServiceLoaderKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.tailwind.TailwindCssBundle;
import com.intellij.tailwind.lsp.TailwindLspServerSupportProvider;
import com.intellij.tailwind.settings.TailwindSettings;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.ui.JBDimension;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/tailwind/settings/TailwindConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "lspConfigurationEditor", "Lcom/intellij/openapi/editor/Editor;", "currentLspConfiguration", "", "getCurrentLspConfiguration", "()Ljava/lang/String;", "getDisplayName", "getHelpTopic", "createComponent", "Ljavax/swing/JComponent;", "reset", "", "isModified", "", "apply", "disposeUIResources", "intellij.tailwindcss"})
public final class TailwindConfigurable
implements Configurable {
    @NotNull
    private final Project project;
    private DialogPanel panel;
    private Editor lspConfigurationEditor;

    public TailwindConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final String getCurrentLspConfiguration() {
        Editor editor = this.lspConfigurationEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor = null;
        }
        String string = editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public String getDisplayName() {
        String string = TailwindCssBundle.message("settings.page.tailwind", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        return "configurable.tailwindcss";
    }

    @NotNull
    public JComponent createComponent() {
        JSExternalDefinitionsNodeDescriptor serverDescriptor = new JSExternalDefinitionsNodeDescriptor(TailwindSettings.Companion.getDefaultLspPackage());
        NodePackageField lspPackageField = new NodePackageField(this.project, (NodePackageDescriptor)serverDescriptor, () -> TailwindConfigurable.createComponent$lambda$0(this), (NodePackageRefResolver)new JSExternalDefinitionsPackageResolver(this.project, (NodePackageDescriptor)serverDescriptor));
        PsiFile jsonFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText("dummy.json", (Language)JsonLanguage.INSTANCE, (CharSequence)"", true, false);
        Document jsonDocument = PsiDocumentManager.getInstance((Project)this.project).getDocument(jsonFile);
        Editor editor = TemplateEditorUtil.createEditor((boolean)false, (Document)jsonDocument, (Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"createEditor(...)");
        this.lspConfigurationEditor = editor;
        Editor editor2 = this.lspConfigurationEditor;
        if (editor2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor2 = null;
        }
        editor2.getSettings().setAdditionalLinesCount(0);
        Editor editor3 = this.lspConfigurationEditor;
        if (editor3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor3 = null;
        }
        editor3.getComponent().setPreferredSize((Dimension)new JBDimension(200, 100));
        this.panel = BuilderKt.panel(arg_0 -> TailwindConfigurable.createComponent$lambda$1(lspPackageField, this, arg_0));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        return (JComponent)dialogPanel;
    }

    public void reset() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.reset();
        WriteAction.run(() -> TailwindConfigurable.reset$lambda$0(this));
    }

    public boolean isModified() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        return dialogPanel.isModified() || !Intrinsics.areEqual((Object)TailwindSettings.Companion.getInstance(this.project).getLspConfiguration(), (Object)this.getCurrentLspConfiguration());
    }

    public void apply() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        TailwindSettings.Companion.getInstance(this.project).setLspConfiguration(this.getCurrentLspConfiguration());
        if (!this.project.isDefault()) {
            LspServerManager.Companion.getInstance(this.project).stopAndRestartIfNeeded(TailwindLspServerSupportProvider.class);
        }
    }

    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor = this.lspConfigurationEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor = null;
        }
        editorFactory.releaseEditor(editor);
    }

    private static final NodeJsInterpreter createComponent$lambda$0(TailwindConfigurable this$0) {
        return NodeJsInterpreterManager.getInstance((Project)this$0.project).getInterpreter();
    }

    private static final Unit createComponent$lambda$1(NodePackageField $lspPackageField, TailwindConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = TailwindCssBundle.message("settings.page.lsp.server.path.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> TailwindConfigurable.createComponent$lambda$1$0($lspPackageField, this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TailwindConfigurable.createComponent$lambda$1$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TailwindConfigurable.createComponent$lambda$1$2(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$1$0(NodePackageField $lspPackageField, TailwindConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JSServiceLoaderKt.bind((Cell)$this$row.cell((JComponent)$lspPackageField).align((Align)AlignX.FILL.INSTANCE), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(TailwindSettings.Companion.getInstance(this$0.project)){

            public Object get() {
                return ((TailwindSettings)this.receiver).getLspServerPackageRef();
            }

            public void set(Object value) {
                ((TailwindSettings)this.receiver).setLspServerPackageRef((NodePackageRef)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$1$1(TailwindConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TailwindCssBundle.message("settings.page.configuration.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).resizableColumn();
        String string2 = TailwindCssBundle.message("settings.page.restore.default.configuration.link", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string2, (int)0, arg_0 -> TailwindConfigurable.createComponent$lambda$1$1$0(this$0, arg_0), (int)2, null).align((Align)AlignY.BOTTOM.INSTANCE).visibleIf(new ComponentPredicate(this$0){
            final /* synthetic */ TailwindConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            public void addListener(Function1<? super Boolean, Unit> listener) {
                Intrinsics.checkNotNullParameter(listener, (String)"listener");
                Editor editor = TailwindConfigurable.access$getLspConfigurationEditor$p(this.this$0);
                if (editor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
                    editor = null;
                }
                editor.getDocument().addDocumentListener(new DocumentListener(listener, this.this$0){
                    final /* synthetic */ Function1<Boolean, Unit> $listener;
                    final /* synthetic */ TailwindConfigurable this$0;
                    {
                        this.$listener = $listener;
                        this.this$0 = $receiver;
                    }

                    public void documentChanged(DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$listener.invoke((Object)(!Intrinsics.areEqual((Object)TailwindConfigurable.access$getCurrentLspConfiguration(this.this$0), (Object)TailwindSettings.DEFAULT_CONFIGURATION) ? 1 : 0));
                    }
                });
            }

            public Boolean invoke() {
                return !Intrinsics.areEqual((Object)TailwindConfigurable.access$getCurrentLspConfiguration(this.this$0), (Object)TailwindSettings.DEFAULT_CONFIGURATION);
            }
        });
        String string3 = TailwindCssBundle.message("settings.page.available.options.comment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string3, (int)0, (HyperlinkEventAction)HyperlinkEventAction.HTML_HYPERLINK_INSTANCE, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void createComponent$lambda$1$1$0(TailwindConfigurable this$0, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WriteAction.run(() -> TailwindConfigurable.createComponent$lambda$1$1$0$0(this$0));
    }

    private static final void createComponent$lambda$1$1$0$0(TailwindConfigurable this$0) {
        Editor editor = this$0.lspConfigurationEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor = null;
        }
        editor.getDocument().setText((CharSequence)TailwindSettings.DEFAULT_CONFIGURATION);
    }

    private static final Unit createComponent$lambda$1$2(TailwindConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Editor editor = this$0.lspConfigurationEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor = null;
        }
        JComponent jComponent = editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final void reset$lambda$0(TailwindConfigurable this$0) {
        Editor editor = this$0.lspConfigurationEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lspConfigurationEditor");
            editor = null;
        }
        editor.getDocument().setText((CharSequence)TailwindSettings.Companion.getInstance(this$0.project).getLspConfiguration());
    }

    public static final /* synthetic */ Editor access$getLspConfigurationEditor$p(TailwindConfigurable $this) {
        return $this.lspConfigurationEditor;
    }

    public static final /* synthetic */ String access$getCurrentLspConfiguration(TailwindConfigurable $this) {
        return $this.getCurrentLspConfiguration();
    }
}

