/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.gateway.ssh.deploy.TransferProgressTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/gateway/ssh/TransferProgressAdapter;", "Lcom/jetbrains/gateway/ssh/deploy/TransferProgressTracker;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "totalBytes", "", "<init>", "(Lcom/intellij/openapi/progress/ProgressIndicator;J)V", "isCancelled", "", "()Z", "updateProgress", "", "transferred", "speed", "(JLjava/lang/Long;)V", "intellij.gateway.core"})
public final class TransferProgressAdapter
implements TransferProgressTracker {
    @NotNull
    private final ProgressIndicator progressIndicator;
    private final long totalBytes;

    public TransferProgressAdapter(@NotNull ProgressIndicator progressIndicator, long totalBytes) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        this.progressIndicator = progressIndicator;
        this.totalBytes = totalBytes;
    }

    @Override
    public boolean isCancelled() {
        return this.progressIndicator.isCanceled();
    }

    @Override
    public void updateProgress(long transferred, @Nullable Long speed) {
        double fraction = (double)transferred / (double)this.totalBytes;
        String fractionPercentage = (int)(fraction * (double)100) + "%";
        int rankForTotalSize = StringUtil.rankForFileSize((long)this.totalBytes);
        String string = StringUtil.formatFileSize((long)this.totalBytes, (String)" ", (int)rankForTotalSize);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String totalBytesFormatted = string;
        String string2 = StringUtil.formatFileSize((long)transferred, (String)" ", (int)rankForTotalSize);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(...)");
        String transferredFormatted = string2;
        String progress = transferredFormatted + "/" + totalBytesFormatted;
        if (this.progressIndicator.isIndeterminate()) {
            this.progressIndicator.setIndeterminate(false);
        }
        this.progressIndicator.setFraction(fraction);
        if (speed != null) {
            String speedFormatted = StringUtil.formatFileSize((long)speed) + "/s";
            this.progressIndicator.setText2(fractionPercentage + " \u00b7 " + progress + " \u00b7 " + speedFormatted);
        } else {
            this.progressIndicator.setText2(fractionPercentage + " \u00b7 " + progress);
        }
    }
}

