/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.ui.MouseMovementTracker;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class QuickDocHintHandler<DocOwner> {
    protected static final int HINT_POPUP_BORDER_TOLERANCE = 2;
    @NotNull
    private final Alarm myShowHintAlarm = new Alarm();
    @NotNull
    private final MouseMovementTracker myMouseMovementTracker = new MouseMovementTracker();
    @NotNull
    private Reference<JBPopup> myActiveHintPopup = new WeakReference<Object>(null);
    @NotNull
    private Reference<DocOwner> myActiveHintDocOwner = new WeakReference<Object>(null);
    private boolean myKeepPopupOnMouseMove;

    public abstract int getShowQuickDocHintDelay();

    public abstract @NotNull Promise<@Nullable JBPopup> createQuickDocHintFor(@NotNull DocOwner var1, @Nullable Consumer<ComponentPopupBuilder> var2);

    @NotNull
    protected MouseEvent preprocessEvent(@NotNull MouseEvent event) {
        if (event == null) {
            QuickDocHintHandler.$$$reportNull$$$0(0);
        }
        MouseEvent mouseEvent = event;
        if (mouseEvent == null) {
            QuickDocHintHandler.$$$reportNull$$$0(1);
        }
        return mouseEvent;
    }

    protected abstract DocOwner getDocOwnerFor(@NotNull MouseEvent var1);

    @NotNull
    protected abstract Component getHintPopupOwner(@NotNull JBPopup var1);

    @NotNull
    protected abstract Point getQuickDocHintScreenLocation(@NotNull JBPopup var1, DocOwner var2);

    protected abstract void onQuickDocHintShown(@NotNull JBPopup var1, DocOwner var2);

    @NotNull
    protected Alarm getShowHintAlarm() {
        Alarm alarm = this.myShowHintAlarm;
        if (alarm == null) {
            QuickDocHintHandler.$$$reportNull$$$0(2);
        }
        return alarm;
    }

    @NotNull
    protected MouseMovementTracker getMouseMovementTracker() {
        MouseMovementTracker mouseMovementTracker = this.myMouseMovementTracker;
        if (mouseMovementTracker == null) {
            QuickDocHintHandler.$$$reportNull$$$0(3);
        }
        return mouseMovementTracker;
    }

    protected boolean isKeepPopupOnMouseMove() {
        return this.myKeepPopupOnMouseMove;
    }

    protected void setKeepPopupOnMouseMove(boolean keepPopupOnMouseMove) {
        this.myKeepPopupOnMouseMove = keepPopupOnMouseMove;
    }

    @Nullable
    protected JBPopup getActiveHintPopup() {
        return this.myActiveHintPopup.get();
    }

    protected void setActiveHintPopup(@Nullable JBPopup hintPopup) {
        this.myActiveHintPopup = new WeakReference<JBPopup>(hintPopup);
    }

    protected DocOwner getActiveHintDocOwner() {
        return this.myActiveHintDocOwner.get();
    }

    protected void setActiveHintDocOwner(DocOwner docOwner) {
        this.myActiveHintDocOwner = new WeakReference<DocOwner>(docOwner);
    }

    protected void onMouseMoved(@NotNull MouseEvent e) {
        if (e == null) {
            QuickDocHintHandler.$$$reportNull$$$0(4);
        }
        if (this.isMovingTowardsHintPopup(e) || this.isKeepPopupOnMouseMove()) {
            return;
        }
        DocOwner docOwner = this.getDocOwnerFor(e);
        if (!Objects.equals(docOwner, this.getActiveHintDocOwner())) {
            this.closeActiveHintIfPresent();
        }
        if (docOwner == null) {
            return;
        }
        if (!this.isHintShowing() && !this.isPopupDisabled()) {
            this.rescheduleShowHint(docOwner);
        }
    }

    protected void onMouseExited(@NotNull MouseEvent e) {
        if (e == null) {
            QuickDocHintHandler.$$$reportNull$$$0(5);
        }
        this.getShowHintAlarm().cancelAllRequests();
        if (!this.isKeepPopupOnMouseMove() && !this.isMovingTowardsHintPopup(e)) {
            this.closeActiveHintIfPresent();
        }
    }

    protected boolean isMovingTowardsHintPopup(@NotNull MouseEvent event) {
        if (event == null) {
            QuickDocHintHandler.$$$reportNull$$$0(6);
        }
        return this.getMouseMovementTracker().isMovingTowards(this.preprocessEvent(event), this.getActiveHintPopupBounds());
    }

    protected void rescheduleShowHint(@NotNull DocOwner docOwner) {
        if (docOwner == null) {
            QuickDocHintHandler.$$$reportNull$$$0(7);
        }
        this.getShowHintAlarm().cancelAllRequests();
        this.getShowHintAlarm().addRequest(() -> {
            MouseMovementTracker movementTracker = new MouseMovementTracker();
            this.createQuickDocHintFor(docOwner, popupBuilder -> popupBuilder.setCancelOnMouseOutCallback(event -> {
                boolean isMouseOverActiveHintDocOwner = Objects.equals(this.getDocOwnerFor(event), this.getActiveHintDocOwner());
                boolean isMovingTowardsHintPopup = movementTracker.isMovingTowards(this.preprocessEvent(event), this.getActiveHintPopupBounds());
                return !this.isKeepPopupOnMouseMove() && !isMouseOverActiveHintDocOwner && !isMovingTowardsHintPopup;
            })).onProcessed(hintPopup -> ApplicationManager.getApplication().invokeLater(() -> {
                if (hintPopup == null || this.isPopupDisabled()) {
                    return;
                }
                Point hintLocation = this.getQuickDocHintScreenLocation((JBPopup)hintPopup, docOwner);
                hintPopup.showInScreenCoordinates(this.getHintPopupOwner((JBPopup)hintPopup), hintLocation);
                this.setActiveHintPopup((JBPopup)hintPopup);
                this.setActiveHintDocOwner(docOwner);
                this.onQuickDocHintShown((JBPopup)hintPopup, docOwner);
            }));
        }, this.getShowQuickDocHintDelay());
    }

    @Nullable
    protected Rectangle getActiveHintPopupBounds() {
        JBPopup popup = this.getActiveHintPopup();
        if (popup == null || popup.isDisposed()) {
            return null;
        }
        Dimension size = popup.getSize();
        if (size == null) {
            return null;
        }
        Rectangle result = new Rectangle(popup.getLocationOnScreen(), size);
        result.grow(2, 2);
        return result;
    }

    protected void closeActiveHintIfPresent() {
        JBPopup hint = this.getActiveHintPopup();
        if (hint != null) {
            hint.cancel();
        }
        this.setActiveHintPopup(null);
        this.setActiveHintDocOwner(null);
        this.getMouseMovementTracker().reset();
        this.setKeepPopupOnMouseMove(false);
    }

    protected boolean isHintShowing() {
        JBPopup hint = this.getActiveHintPopup();
        return hint != null && !hint.isDisposed();
    }

    protected boolean isPopupDisabled() {
        return QuickDocHintHandler.isAnotherAppInFocus() || QuickDocHintHandler.isAnotherPopupFocused() || QuickDocHintHandler.isContextMenuShown();
    }

    protected static boolean isAnotherAppInFocus() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == null;
    }

    protected static boolean isAnotherPopupFocused() {
        JBPopup popup = PopupUtil.getPopupContainerFor((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        return popup != null && !popup.isDisposed();
    }

    protected static boolean isContextMenuShown() {
        return MenuSelectionManager.defaultManager().getSelectedPath().length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/QuickDocHintHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/QuickDocHintHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowHintAlarm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseMovementTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEvent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onMouseMoved";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onMouseExited";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMovingTowardsHintPopup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rescheduleShowHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

