/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.Comparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface DiagramElementsProvider<T> {
    @NotNull
    public static final Comparator<PsiElement> PSI_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof PsiNamedElement && o2 instanceof PsiNamedElement) {
            String name1 = ((PsiNamedElement)o1).getName();
            String name2 = ((PsiNamedElement)o2).getName();
            return name1 == null ? (name2 == null ? 0 : 1) : (name2 == null ? -1 : name1.compareTo(name2));
        }
        return o1 instanceof PsiNamedElement ? -1 : 1;
    };
    public static final DiagramElementsProvider @NotNull [] EMPTY_ARRAY = new DiagramElementsProvider[0];

    public T @NotNull [] getElements(T var1, @NotNull Project var2);

    @NotNull
    @Nls
    public String getName();

    @NotNull
    @Nls
    public String getHeaderName(T var1, @NotNull Project var2);

    @NotNull
    public ShortcutSet getShortcutSet();

    @NotNull
    public Comparator<? super T> getComparator();

    public boolean showProgress();

    @NotNull
    @Nls
    public String getProgressMessage();

    public boolean isEnabledOn(T var1);
}

