/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprComparison;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import kotlin.jvm.functions.Function1;

public class RelExprSingleAttribute
extends RelExpr {
    public static final String CUR_ITERATION = "$curIteration";
    private final String domain;
    private String attribute;
    private String relName;
    private Function1<? super IRelation, Integer> function;
    private final RelExprComparison.BinOp binOp;
    private final boolean myNegation;
    private int curIteration;

    public RelExprSingleAttribute(String domainName, String relName, Function1<? super IRelation, Integer> function2, RelExprComparison.BinOp binOp, boolean negation, Context context) {
        super(context, new QueryNode[0]);
        this.domain = domainName;
        this.relName = relName;
        this.function = function2;
        this.binOp = binOp;
        this.myNegation = negation;
    }

    public RelExprSingleAttribute(String domainName, String attribute, RelExprComparison.BinOp binOp, boolean negation, Context context) {
        super(context, new QueryNode[0]);
        this.domain = domainName;
        this.attribute = attribute;
        this.binOp = binOp;
        this.myNegation = negation;
    }

    public void resetCurIteration() {
        this.curIteration = 1;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public boolean isNegation() {
        return this.myNegation;
    }

    public RelExprComparison.BinOp getBinOp() {
        return this.binOp;
    }

    @Override
    public void accept(RelExprVisitor visitor2) {
        visitor2.visitSingleAttribute(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformSingleAttribute(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return new Domain[]{variablesManager.getDomain(this.domain)};
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        Domain dom = variablesManager.getDomain(this.domain);
        IRelation result = relationsManager.makeEmptyRelation(new Domain[]{dom});
        boolean complement = this.myNegation;
        int value = this.attribute != null ? symbolTable.getAttributeInt(dom.getType(), this.attribute) : (this.relName.equals(CUR_ITERATION) ? this.curIteration++ : (Integer)this.function.invoke((Object)variablesManager.getRelation(this.relName, cancellation)));
        switch (this.binOp) {
            case NEQ: {
                complement = !complement;
            }
            case EQ: {
                result = relationsManager.makeSingleTuple(dom, value);
                break;
            }
            case GT: {
                complement = !complement;
            }
            case LTEQ: {
                result = relationsManager.makeLess(dom, value, true, cancellation);
                break;
            }
            case GTEQ: {
                complement = !complement;
            }
            case LT: {
                result = relationsManager.makeLess(dom, value, false, cancellation);
            }
        }
        if (complement) {
            IRelation oldResult = result;
            result = result.complement(cancellation);
            oldResult.kill();
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprSingleAttribute{domain='" + this.domain + "', attribute='" + this.attribute + "', binOp=" + String.valueOf((Object)this.binOp) + "}";
    }

    @Override
    public String toShortString() {
        return (this.myNegation ? "!" : "") + "(" + this.domain + " " + String.valueOf((Object)this.binOp) + " " + this.attribute + ")";
    }
}

