/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RelExprComparison
extends RelExpr {
    private final String leftDomain;
    private final String rightDomain;
    private final String opDomainName;
    private final DomainType leftDomainType;
    private final DomainType rightDomainType;
    private final DomainType opDomainType;
    private final BinOp binOp;
    private final boolean myNegation;

    public RelExprComparison(String leftDomainName, String rightDomainName, @Nullable String opDomainName, DomainType leftDomainType, DomainType rightDomainType, @Nullable DomainType opDomainType, BinOp binOp, boolean negation, Context context) {
        super(context, new QueryNode[0]);
        this.leftDomain = leftDomainName;
        this.rightDomain = rightDomainName;
        this.opDomainName = opDomainName;
        this.leftDomainType = leftDomainType;
        this.rightDomainType = rightDomainType;
        this.opDomainType = opDomainType;
        this.binOp = binOp;
        this.myNegation = negation;
    }

    public String getLeftDomain() {
        return this.leftDomain;
    }

    public String getRightDomain() {
        return this.rightDomain;
    }

    public String getOpDomainName() {
        return this.opDomainName;
    }

    public boolean isNegation() {
        return this.myNegation;
    }

    public BinOp getBinOp() {
        return this.binOp;
    }

    public DomainType getLeftDomainType() {
        return this.leftDomainType;
    }

    public DomainType getRightDomainType() {
        return this.rightDomainType;
    }

    @Override
    public void accept(RelExprVisitor visitor2) {
        visitor2.visitComparison(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformReflexive(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        if (this.opDomainName != null) {
            return new Domain[]{variablesManager.getDomain(this.leftDomain), variablesManager.getDomain(this.rightDomain), variablesManager.getDomain(this.opDomainName)};
        }
        return new Domain[]{variablesManager.getDomain(this.leftDomain), variablesManager.getDomain(this.rightDomain)};
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        Domain left2 = variablesManager.getDomain(this.leftDomain);
        Domain right2 = variablesManager.getDomain(this.rightDomain);
        if (this.opDomainName != null) {
            List<String> opNames = Arrays.asList(">", "<", ">=", "<=", "==", "!=");
            List<BinOp> ops = Arrays.asList(BinOp.GT, BinOp.LT, BinOp.GTEQ, BinOp.LTEQ, BinOp.EQ, BinOp.NEQ);
            IRelation result = relationsManager.makeEmptyRelation(this.getDomains(variablesManager, domainsPool));
            for (int i = 0; i < ops.size(); ++i) {
                IRelation oldResult = result;
                int opAttr = symbolTable.getAttributeInt(this.opDomainType, opNames.get(i));
                IRelation rel1 = this.getRelation(relationsManager, cancellation, left2, right2, ops.get(i));
                IRelation rel2 = relationsManager.makeSingleTuple(variablesManager.getDomain(this.opDomainName), opAttr);
                result = result.unite(rel1.unsafeIntersect(rel2, cancellation), cancellation);
                oldResult.kill();
            }
            if (profileManager2 != null) {
                profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
            }
            return result;
        }
        IRelation result = this.getRelation(relationsManager, cancellation, left2, right2, this.binOp);
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
        return result;
    }

    private IRelation getRelation(IRelationsManager relationsManager, Cancellation cancellation, Domain left2, Domain right2, BinOp binOp) {
        IRelation result = relationsManager.makeEmptyRelation(new Domain[]{left2, right2});
        boolean complement = this.myNegation;
        switch (binOp.ordinal()) {
            case 1: {
                complement = !complement;
            }
            case 0: {
                result = relationsManager.makeEqual(left2, right2, cancellation);
                break;
            }
            case 3: {
                result = relationsManager.makeGreater(left2, right2, false, cancellation);
                break;
            }
            case 4: {
                result = relationsManager.makeLess(left2, right2, true, cancellation);
                break;
            }
            case 5: {
                result = relationsManager.makeGreater(left2, right2, true, cancellation);
                break;
            }
            case 2: {
                result = relationsManager.makeLess(left2, right2, false, cancellation);
            }
        }
        if (complement) {
            IRelation oldResult = result;
            result = result.complement(cancellation);
            oldResult.kill();
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprReflexive{leftDomain='" + this.leftDomain + "', rightDomain='" + this.rightDomain + "', binOp=" + String.valueOf((Object)this.binOp) + "}";
    }

    @Override
    public String toShortString() {
        return "(" + this.leftDomain + " " + String.valueOf((Object)this.binOp) + " " + this.rightDomain + ")";
    }

    public static enum BinOp {
        EQ,
        NEQ,
        LT,
        GT,
        LTEQ,
        GTEQ;

    }
}

