/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helmfile.util;

import com.intellij.kubernetes.helmfile.HelmfileFileType;
import com.intellij.kubernetes.helmfile.HelmfileManager;
import com.intellij.kubernetes.helmfile.model.HelmReleaseModel;
import com.intellij.kubernetes.helmfile.model.HelmfileModel;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Plow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u00a8\u0006\b"}, d2={"getRefereeReleases", "Lcom/intellij/util/Plow;", "Lcom/intellij/kubernetes/helmfile/model/HelmReleaseModel;", "file", "Lcom/intellij/psi/PsiFile;", "isValuesFile", "", "isHelmfileFile", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmfileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmfileUtil.kt\ncom/intellij/kubernetes/helmfile/util/HelmfileUtilKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,33:1\n30#2,2:34\n*S KotlinDebug\n*F\n+ 1 HelmfileUtil.kt\ncom/intellij/kubernetes/helmfile/util/HelmfileUtilKt\n*L\n18#1:34,2\n*E\n"})
public final class HelmfileUtilKt {
    @NotNull
    public static final Plow<HelmReleaseModel> getRefereeReleases(@Nullable PsiFile file) {
        if (HelmfileUtilKt.isHelmfileFile(file)) {
            return Plow.Companion.empty();
        }
        Object object = file;
        if (object == null || (object = object.getOriginalFile()) == null || (object = object.getVirtualFile()) == null || (object = object.getUrl()) == null) {
            return Plow.Companion.empty();
        }
        Object vFileUrl = object;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<HelmfileManager> serviceClass$iv = HelmfileManager.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        HelmfileManager helmfileMgr = (HelmfileManager)object2;
        return helmfileMgr.getAllHelmfileModels().flatMap(HelmfileUtilKt::getRefereeReleases$lambda$0).filter(arg_0 -> HelmfileUtilKt.getRefereeReleases$lambda$1((String)vFileUrl, arg_0));
    }

    public static final boolean isValuesFile(@Nullable PsiFile file) {
        Object object = file;
        if (object == null || (object = object.getOriginalFile()) == null || (object = object.getVirtualFile()) == null || (object = object.getUrl()) == null) {
            return false;
        }
        Object vFileUrl = object;
        return HelmfileUtilKt.getRefereeReleases(file).find(arg_0 -> HelmfileUtilKt.isValuesFile$lambda$0((String)vFileUrl, arg_0)) != null;
    }

    public static final boolean isHelmfileFile(@Nullable PsiFile file) {
        if (!(file instanceof YAMLFile)) {
            return false;
        }
        VirtualFile virtualFile = ((YAMLFile)file).getOriginalFile().getVirtualFile();
        return (virtualFile != null ? virtualFile.getFileType() : null) instanceof HelmfileFileType;
    }

    private static final Plow getRefereeReleases$lambda$0(HelmfileModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Plow.Companion.ofIterable((Iterable)it.getReleases().values());
    }

    private static final boolean getRefereeReleases$lambda$1(String $vFileUrl, HelmReleaseModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValuesFileUrls().contains($vFileUrl);
    }

    private static final boolean isValuesFile$lambda$0(String $vFileUrl, HelmReleaseModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValuesFileUrls().contains($vFileUrl);
    }
}

