/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.swagger.inspections.qodana;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.KtorStarterIcons;
import com.intellij.ktor.swagger.actions.KtorOpenApiFileProvider;
import com.intellij.ktor.swagger.actions.KtorOpenApiGenerationUtilsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.invoke.LambdaMetafactory;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ktor/swagger/inspections/qodana/KtorOpenApiUpdateInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "KtorOpenApiFileVisitor", "UpdateOpenApiQuickFix", "intellij.ktor"})
public final class KtorOpenApiUpdateInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        Module module = GenericPsiUtils.getModule((PsiElement)((PsiElement)psiFile));
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        if (!KtorLibraryUtilKt.hasKtorServerLibrary(module2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiFile psiFile2 = KtorOpenApiFileProvider.Companion.loadOpenApiResources(module2).getOpenApiFile();
        if (psiFile2 == null || (psiFile2 = (PsiFile)psiFile2.getElement()) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiFile openApiFile = psiFile2;
        return new KtorOpenApiFileVisitor(holder, openApiFile);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ktor/swagger/inspections/qodana/KtorOpenApiUpdateInspection$KtorOpenApiFileVisitor;", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "openApiFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/psi/PsiFile;)V", "visitFile", "", "file", "intellij.ktor"})
    private static final class KtorOpenApiFileVisitor
    extends PsiElementVisitor {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final PsiFile openApiFile;

        public KtorOpenApiFileVisitor(@NotNull ProblemsHolder holder, @NotNull PsiFile openApiFile) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)openApiFile, (String)"openApiFile");
            this.holder = holder;
            this.openApiFile = openApiFile;
        }

        public void visitFile(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (Intrinsics.areEqual((Object)file, (Object)this.openApiFile)) {
                Module module = GenericPsiUtils.getModule((PsiElement)((PsiElement)file));
                if (module == null) {
                    return;
                }
                Module module2 = module;
                String newOpenApi = ((Object)StringsKt.trim((CharSequence)KtorOpenApiGenerationUtilsKt.prepareOpenApiTextForModule(module2))).toString();
                String string = this.openApiFile.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String oldOpenApi = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!Intrinsics.areEqual((Object)newOpenApi, (Object)oldOpenApi)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new UpdateOpenApiQuickFix(newOpenApi)};
                    this.holder.registerProblem((PsiElement)file, KtorStarterBundle.INSTANCE.message("ktor.update.openapi.inspection", new Object[0]), localQuickFixArray);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ktor/swagger/inspections/qodana/KtorOpenApiUpdateInspection$UpdateOpenApiQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/util/Iconable;", "newOpenApiContent", "", "<init>", "(Ljava/lang/String;)V", "getNewOpenApiContent", "()Ljava/lang/String;", "getFamilyName", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getIcon", "Ljavax/swing/Icon;", "flags", "", "applyFix", "", "descriptor", "startInWriteAction", "", "intellij.ktor"})
    @SourceDebugExtension(value={"SMAP\nKtorOpenApiUpdateInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorOpenApiUpdateInspection.kt\ncom/intellij/ktor/swagger/inspections/qodana/KtorOpenApiUpdateInspection$UpdateOpenApiQuickFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,80:1\n67#2:81\n*S KotlinDebug\n*F\n+ 1 KtorOpenApiUpdateInspection.kt\ncom/intellij/ktor/swagger/inspections/qodana/KtorOpenApiUpdateInspection$UpdateOpenApiQuickFix\n*L\n58#1:81\n*E\n"})
    private static final class UpdateOpenApiQuickFix
    implements LocalQuickFix,
    Iconable {
        @NotNull
        private final String newOpenApiContent;

        public UpdateOpenApiQuickFix(@NotNull String newOpenApiContent) {
            Intrinsics.checkNotNullParameter((Object)newOpenApiContent, (String)"newOpenApiContent");
            this.newOpenApiContent = newOpenApiContent;
        }

        @NotNull
        public final String getNewOpenApiContent() {
            return this.newOpenApiContent;
        }

        @NotNull
        public String getFamilyName() {
            return KtorStarterBundle.INSTANCE.message("ktor.update.openapi.fix", new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            void $this$parentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            PsiElement psiElement = previewDescriptor.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            PsiElement psiElement2 = psiElement;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            PsiFile psiFile = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiFile.class, (boolean)false);
            if (psiFile != null && (psiElement2 = psiFile.getVirtualFile()) != null) {
                PsiElement swaggerFile = psiElement2;
                boolean bl = false;
                VfsUtil.saveText((VirtualFile)swaggerFile, (String)this.newOpenApiContent);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
            return intentionPreviewInfo;
        }

        @NotNull
        public Icon getIcon(int flags) {
            Icon icon = KtorStarterIcons.Ktor;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Ktor");
            return icon;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            Module module = GenericPsiUtils.getModule((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            Module module2 = module;
            TasksKt.runWithModalProgressBlocking((Project)project, (String)KtorStarterBundle.INSTANCE.message("ktor.generate.openapi.intention", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(module2, this, null){
                Object L$0;
                int label;
                final /* synthetic */ Module $module;
                final /* synthetic */ UpdateOpenApiQuickFix this$0;
                {
                    this.$module = $module;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.module.Module ), ()Lcom/intellij/ktor/swagger/actions/KtorOpenApiFileProvider;)((Module)this.$module), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            openApiFileProvider = (KtorOpenApiFileProvider)v0;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)openApiFileProvider);
                            this.label = 2;
                            v1 = KtorOpenApiGenerationUtilsKt.dumpOpenApiForModule(this.$module, this.this$0.getNewOpenApiContent(), openApiFileProvider, (Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl24
                        }
                        case 2: {
                            openApiFileProvider = (KtorOpenApiFileProvider)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl24:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final KtorOpenApiFileProvider invokeSuspend$lambda$0(Module $module) {
                    return KtorOpenApiFileProvider.Companion.loadOpenApiResources($module);
                }
            }));
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

