﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/comprehend/model/DetectEntitiesResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Comprehend::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DetectEntitiesResult::DetectEntitiesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DetectEntitiesResult& DetectEntitiesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("Entities")) {
    Aws::Utils::Array<JsonView> entitiesJsonList = jsonValue.GetArray("Entities");
    for (unsigned entitiesIndex = 0; entitiesIndex < entitiesJsonList.GetLength(); ++entitiesIndex) {
      m_entities.push_back(entitiesJsonList[entitiesIndex].AsObject());
    }
    m_entitiesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("DocumentMetadata")) {
    m_documentMetadata = jsonValue.GetObject("DocumentMetadata");
    m_documentMetadataHasBeenSet = true;
  }
  if (jsonValue.ValueExists("DocumentType")) {
    Aws::Utils::Array<JsonView> documentTypeJsonList = jsonValue.GetArray("DocumentType");
    for (unsigned documentTypeIndex = 0; documentTypeIndex < documentTypeJsonList.GetLength(); ++documentTypeIndex) {
      m_documentType.push_back(documentTypeJsonList[documentTypeIndex].AsObject());
    }
    m_documentTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Blocks")) {
    Aws::Utils::Array<JsonView> blocksJsonList = jsonValue.GetArray("Blocks");
    for (unsigned blocksIndex = 0; blocksIndex < blocksJsonList.GetLength(); ++blocksIndex) {
      m_blocks.push_back(blocksJsonList[blocksIndex].AsObject());
    }
    m_blocksHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Errors")) {
    Aws::Utils::Array<JsonView> errorsJsonList = jsonValue.GetArray("Errors");
    for (unsigned errorsIndex = 0; errorsIndex < errorsJsonList.GetLength(); ++errorsIndex) {
      m_errors.push_back(errorsJsonList[errorsIndex].AsObject());
    }
    m_errorsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
