/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class YieldNode
extends Node
implements IArgumentNode {
    private Node argsNode;
    private boolean expandedArguments;
    private boolean hasParens = false;

    public YieldNode(SourcePosition position, Node argsNode, boolean expandedArguments) {
        super(position);
        this.argsNode = this.adopt(argsNode);
        this.expandedArguments = expandedArguments;
    }

    public boolean isSame(Node other) {
        if (super.isSame(other)) {
            YieldNode ynode = (YieldNode)other;
            if (this.getArgs() != null && ynode.getArgs() != null && this.getArgs().isSame(ynode.getArgs()) && this.getExpandArguments() == ynode.getExpandArguments()) {
                return true;
            }
            if (this.getArgs() == null && ynode.getArgs() != null || this.getArgs() != null && ynode.getArgs() == null) {
                return false;
            }
        }
        return false;
    }

    public NodeType getNodeType() {
        return NodeType.YIELDNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitYieldNode(this);
    }

    @Deprecated
    public Node getArgsNode() {
        return this.getArgs();
    }

    public Node getArgs() {
        return this.argsNode;
    }

    public void setArgs(Node args) {
        this.argsNode = this.adopt(args);
    }

    public boolean getExpandArguments() {
        return this.expandedArguments;
    }

    public boolean hasParens() {
        return this.hasParens;
    }

    public void setHasParens(boolean hasParens) {
        this.hasParens = hasParens;
    }
}

