/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitActivity;
import git4idea.GitApplyChangesProcess;
import git4idea.GitProtectedBranchesKt;
import git4idea.actions.GitAbortOperationAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u001d\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0006H\u0014J&\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0005H\u0014J4\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0014J\u0018\u0010#\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010$\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0005H\u0002J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020'H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgit4idea/cherrypick/GitCherryPickProcess;", "Lgit4idea/GitApplyChangesProcess;", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "successfullyCherryPickedCount", "", "totalCommitsToCherryPick", "currentCommitCounter", "isSuccess", "", "isEmptyCommit", "result", "Lgit4idea/commands/GitCommandResult;", "cleanupBeforeCommit", "", "repository", "Lgit4idea/repo/GitRepository;", "generateDefaultMessage", "", "Lorg/jetbrains/annotations/NonNls;", "commit", "applyChanges", "listeners", "Lgit4idea/commands/GitLineHandlerListener;", "executeForCommit", "successfulCommits", "", "alreadyPicked", "skipCherryPick", "cherryPickSingleCommit", "updateCherryPickIndicatorText", "shouldAddSuffix", "Lcom/intellij/vcs/log/Hash;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nCherryPickProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CherryPickProcess.kt\ngit4idea/cherrypick/GitCherryPickProcess\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n37#2:148\n36#2,3:149\n24#3:152\n*S KotlinDebug\n*F\n+ 1 CherryPickProcess.kt\ngit4idea/cherrypick/GitCherryPickProcess\n*L\n117#1:148\n117#1:149,3\n144#1:152\n*E\n"})
public final class GitCherryPickProcess
extends GitApplyChangesProcess {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final ProgressIndicator indicator;
    private int successfullyCherryPickedCount;
    private final int totalCommitsToCherryPick;
    private int currentCommitCounter;
    @NotNull
    private static final Logger LOG;
    private static final boolean AUTO_COMMIT;

    public GitCherryPickProcess(@NotNull Project project, @NotNull List<? extends VcsCommitMetadata> commits, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        String string = GitBundle.message((String)"cherry.pick.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = GitBundle.message((String)"cherry.pick.applied", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        GitAbortOperationAction gitAbortOperationAction = new GitAbortOperationAction.CherryPick();
        String string3 = GitBundle.message((String)"activity.name.cherry.pick", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        super(project, commits, string, string2, gitAbortOperationAction, true, string3, GitActivity.CherryPick);
        this.indicator = indicator;
        this.totalCommitsToCherryPick = commits.size();
    }

    public final boolean isSuccess() {
        return this.successfullyCherryPickedCount == this.totalCommitsToCherryPick;
    }

    @Override
    protected boolean isEmptyCommit(@NotNull GitCommandResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        String string = result2.getOutputAsJoinedString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputAsJoinedString(...)");
        String stdout = string;
        String string2 = result2.getErrorOutputAsJoinedString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getErrorOutputAsJoinedString(...)");
        String stderr = string2;
        return StringsKt.contains$default((CharSequence)stdout, (CharSequence)"nothing to commit", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stdout, (CharSequence)"nothing added to commit but untracked files present", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stderr, (CharSequence)"previous cherry-pick is now empty", (boolean)false, (int)2, null);
    }

    @Override
    protected void cleanupBeforeCommit(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        File file = repository2.getRepositoryFiles().getCherryPickHead();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCherryPickHead(...)");
        File cherryPickHeadFile = file;
        if (cherryPickHeadFile.exists()) {
            boolean deleted = FileUtil.delete((File)cherryPickHeadFile);
            if (!deleted) {
                LOG.warn("Couldn't delete " + cherryPickHeadFile);
            }
        } else {
            LOG.info("Cancel cherry-pick in " + repository2.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    @Override
    @NotNull
    protected String generateDefaultMessage(@NotNull GitRepository repository2, @NotNull VcsCommitMetadata commit) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        String string = commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        Object message = string;
        Object object = commit.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
        if (this.shouldAddSuffix(repository2, (Hash)object)) {
            String string2 = "\n\n(cherry picked from commit %s)";
            Object[] objectArray = new Object[]{((Hash)commit.getId()).asString()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            message = (String)message + string3;
        }
        return message;
    }

    @Override
    @NotNull
    protected GitCommandResult applyChanges(@NotNull GitRepository repository2, @NotNull VcsCommitMetadata commit, @NotNull List<? extends GitLineHandlerListener> listeners) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        return this.cherryPickSingleCommit(repository2, commit, listeners);
    }

    @Override
    protected boolean executeForCommit(@NotNull GitRepository repository2, @NotNull VcsCommitMetadata commit, @NotNull List<VcsCommitMetadata> successfulCommits, @NotNull List<VcsCommitMetadata> alreadyPicked) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
        Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
        int n = this.currentCommitCounter;
        this.currentCommitCounter = n + 1;
        boolean result2 = super.executeForCommit(repository2, commit, successfulCommits, alreadyPicked);
        if (result2) {
            int n2 = this.successfullyCherryPickedCount;
            this.successfullyCherryPickedCount = n2 + 1;
            if (!((Collection)alreadyPicked).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.last(alreadyPicked), (Object)commit)) {
                this.skipCherryPick(commit, repository2);
            }
        }
        return result2;
    }

    private final void skipCherryPick(VcsCommitMetadata commit, GitRepository repository2) {
        LOG.info("Skipping cherry-pick, as the last commit " + commit.getId() + " in the sequence is empty");
        GitLineHandler handler = new GitLineHandler(this.getProject(), repository2.getRoot(), GitCommand.CHERRY_PICK);
        String[] stringArray = new String[]{"--skip"};
        handler.addParameters(stringArray);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        if (!result2.success()) {
            LOG.warn("Failed to skip cherry-pick");
        }
    }

    private final GitCommandResult cherryPickSingleCommit(GitRepository repository2, VcsCommitMetadata commit, List<? extends GitLineHandlerListener> listeners) {
        GitCommandResult result2;
        block1: {
            ProgressIndicator progressIndicator = this.indicator;
            if (progressIndicator != null) {
                ProgressIndicator it = progressIndicator;
                boolean bl = false;
                this.updateCherryPickIndicatorText(it, commit);
            }
            Git git = Git.getInstance();
            String string = ((Hash)commit.getId()).asString();
            Object object = commit.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
            Collection $this$toTypedArray$iv = listeners;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            GitLineHandlerListener[] gitLineHandlerListenerArray = thisCollection$iv.toArray(new GitLineHandlerListener[0]);
            GitCommandResult gitCommandResult = git.cherryPick(repository2, string, AUTO_COMMIT, this.shouldAddSuffix(repository2, (Hash)object), Arrays.copyOf(gitLineHandlerListenerArray, gitLineHandlerListenerArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"cherryPick(...)");
            result2 = gitCommandResult;
            ProgressIndicator progressIndicator2 = this.indicator;
            if (progressIndicator2 == null) break block1;
            progressIndicator2.setFraction((double)this.currentCommitCounter / (double)this.totalCommitsToCherryPick);
        }
        return result2;
    }

    private final void updateCherryPickIndicatorText(ProgressIndicator indicator, VcsCommitMetadata commit) {
        String string;
        if (this.totalCommitsToCherryPick > 1) {
            Object[] objectArray = new Object[]{StringUtil.trimMiddle((String)commit.getSubject(), (int)30), this.currentCommitCounter, this.totalCommitsToCherryPick};
            string = DvcsBundle.message((String)"cherry.picking.process.commit", (Object[])objectArray);
        } else {
            Object[] objectArray = new Object[]{StringUtil.trimMiddle((String)commit.getSubject(), (int)30)};
            string = DvcsBundle.message((String)"cherry.picking.process.commit.single", (Object[])objectArray);
        }
        indicator.setText(string);
    }

    private final boolean shouldAddSuffix(GitRepository repository2, Hash commit) {
        return GitVcsSettings.getInstance((Project)this.getProject()).shouldAddSuffixToCherryPicksOfPublishedCommits() && GitProtectedBranchesKt.isCommitPublished(repository2, commit);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        AUTO_COMMIT = true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgit4idea/cherrypick/GitCherryPickProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "AUTO_COMMIT", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

