/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.settings;

import com.intellij.aiplayground.models.settings.PlaygroundSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/aiplayground/settings/SettingsMigrationService;", "", "<init>", "()V", "migrateSettingsIfNeeded", "", "getCurrentSettingsVersion", "", "updateSettingsVersion", "version", "performMigration", "fromVersion", "toVersion", "migrateV1toV2", "migrateV2toV3", "Companion", "intellij.aiplayground.settings"})
@SourceDebugExtension(value={"SMAP\nSettingsMigrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsMigrationService.kt\ncom/intellij/aiplayground/settings/SettingsMigrationService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n24#2:141\n24#2:142\n24#2:143\n24#2:149\n24#2:150\n24#2:151\n24#2:152\n24#2:153\n24#2:156\n24#2:157\n24#2:158\n30#3,2:144\n30#3,2:147\n30#3,2:154\n1#4:146\n*S KotlinDebug\n*F\n+ 1 SettingsMigrationService.kt\ncom/intellij/aiplayground/settings/SettingsMigrationService\n*L\n26#1:141\n29#1:142\n33#1:143\n76#1:149\n99#1:150\n103#1:151\n106#1:152\n115#1:153\n127#1:156\n129#1:157\n132#1:158\n41#1:144,2\n62#1:147,2\n118#1:154,2\n*E\n"})
public final class SettingsMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int CURRENT_SETTINGS_VERSION = 3;

    public final void migrateSettingsIfNeeded() {
        try {
            int currentVersion = this.getCurrentSettingsVersion();
            int targetVersion = 3;
            if (currentVersion < targetVersion) {
                SettingsMigrationService $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(SettingsMigrationService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Migrating settings from version " + currentVersion + " to " + targetVersion);
                this.performMigration(currentVersion, targetVersion);
                this.updateSettingsVersion(targetVersion);
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(SettingsMigrationService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.info("Settings migration completed successfully");
            }
        }
        catch (Exception e) {
            SettingsMigrationService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SettingsMigrationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Error during settings migration", (Throwable)e);
        }
    }

    private final int getCurrentSettingsVersion() {
        int n;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<PlaygroundSettings> serviceClass$iv = PlaygroundSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        PlaygroundSettings playgroundSettings = (PlaygroundSettings)object;
        try {
            String versionString;
            Field field;
            PlaygroundSettings.PlaygroundSettingsState state = (PlaygroundSettings.PlaygroundSettingsState)playgroundSettings.getState();
            Field $this$getCurrentSettingsVersion_u24lambda_u240 = field = state.getClass().getDeclaredField("settingsVersion");
            boolean bl = false;
            $this$getCurrentSettingsVersion_u24lambda_u240.setAccessible(true);
            Object object2 = field.get(state);
            String string = versionString = object2 instanceof String ? (String)object2 : null;
            n = string != null ? Integer.parseInt(string) : 1;
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    private final void updateSettingsVersion(int version) {
        try {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            Object $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<PlaygroundSettings> serviceClass$iv = PlaygroundSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            PlaygroundSettings playgroundSettings = (PlaygroundSettings)object;
            try {
                $this$service$iv = playgroundSettings.getClass().getDeclaredField("settingsVersion");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Field field = PlaygroundSettings.class.getDeclaredField("settingsVersion");
                field.setAccessible(true);
                field.set(playgroundSettings, String.valueOf(version));
                $this$service$iv = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            SettingsMigrationService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SettingsMigrationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to update settings version", (Throwable)e);
        }
    }

    private final void performMigration(int fromVersion, int toVersion) {
        block4: for (int version = fromVersion; version < toVersion; ++version) {
            switch (version) {
                case 1: {
                    this.migrateV1toV2();
                    continue block4;
                }
                case 2: {
                    this.migrateV2toV3();
                }
            }
        }
    }

    private final void migrateV1toV2() {
        SettingsMigrationService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SettingsMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Performing migration from v1 to v2");
        try {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SettingsMigrationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("Successfully migrated from v1 to v2");
        }
        catch (Exception e) {
            SettingsMigrationService $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger3 = Logger.getInstance(SettingsMigrationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.error("Error migrating from v1 to v2", (Throwable)e);
        }
    }

    private final void migrateV2toV3() {
        SettingsMigrationService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SettingsMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Performing migration from v2 to v3");
        try {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<PlaygroundSettings> serviceClass$iv = PlaygroundSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            PlaygroundSettings playgroundSettings = (PlaygroundSettings)object;
            Field field = PlaygroundSettings.PlaygroundSettingsState.class.getDeclaredField("persistedActiveModels");
            field.setAccessible(true);
            field.set(playgroundSettings, MapsKt.emptyMap());
            SettingsMigrationService $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(SettingsMigrationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("Successfully initialized persistedActiveModels in settings");
        }
        catch (Exception e) {
            SettingsMigrationService $this$thisLogger$iv3 = this;
            boolean $i$f$thisLogger3 = false;
            Logger logger3 = Logger.getInstance(SettingsMigrationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.error("Error initializing persistedActiveModels field", (Throwable)e);
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger4 = Logger.getInstance(SettingsMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
        logger4.info("Successfully migrated from v2 to v3");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/aiplayground/settings/SettingsMigrationService$Companion;", "", "<init>", "()V", "CURRENT_SETTINGS_VERSION", "", "intellij.aiplayground.settings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

