/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.impl.CssBlockImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssParser2;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IErrorCounterReparseableElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class CssDeclarationBlockElementType
extends IErrorCounterReparseableElementType {
    public CssDeclarationBlockElementType(String debugName) {
        this(debugName, CSSLanguage.INSTANCE);
    }

    public CssDeclarationBlockElementType(String debugName, Language language) {
        super(debugName, language);
    }

    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        String nsPrefix;
        XmlTag tag;
        ASTNode treeParent;
        if (chameleon == null) {
            CssDeclarationBlockElementType.$$$reportNull$$$0(0);
        }
        if ((treeParent = chameleon.getTreeParent()) instanceof XmlAttributeValue && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)treeParent.getPsi(), XmlTag.class)) != null && !(nsPrefix = tag.getNamespacePrefix()).isEmpty()) {
            CharSequence chars = chameleon.getChars();
            CharTable chartable = SharedImplUtil.findCharTableByTree((ASTNode)chameleon);
            PsiManager manager = chameleon.getTreeParent().getPsi().getManager();
            return Factory.createSingleLeafElement((IElementType)XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, (CharSequence)chars, (CharTable)chartable, (PsiManager)manager);
        }
        return super.parseContents(chameleon);
    }

    @NotNull
    protected Language getLanguageForParser(@NotNull PsiElement psi) {
        if (psi == null) {
            CssDeclarationBlockElementType.$$$reportNull$$$0(1);
        }
        Language language = (Language)ObjectUtils.notNull((Object)CssPsiUtil.getStylesheetLanguage(psi), (Object)CSSLanguage.INSTANCE);
        if (language == null) {
            CssDeclarationBlockElementType.$$$reportNull$$$0(2);
        }
        return language;
    }

    public ASTNode createNode(CharSequence text) {
        return new CssBlockImpl(text, (IElementType)this);
    }

    public int getErrorsCount(CharSequence seq, Language fileLanguage, Project project) {
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(fileLanguage);
        Lexer lexer = parserDefinition.createLexer(project);
        PsiParser parser = parserDefinition.createParser(project);
        boolean supportsNestedBlocks = parser instanceof CssParser2 && ((CssParser2)parser).supportsNestedBlocks();
        lexer.start(seq);
        if (lexer.getTokenType() != CssElementTypes.CSS_LBRACE) {
            return Integer.MIN_VALUE;
        }
        lexer.advance();
        int balance = 1;
        while (true) {
            ProgressManager.checkCanceled();
            IElementType type = lexer.getTokenType();
            if (type == null) break;
            if (balance == 0) {
                return Integer.MIN_VALUE;
            }
            if (type == CssElementTypes.CSS_LBRACE) {
                if (!supportsNestedBlocks) {
                    return balance;
                }
                ++balance;
            } else if (type == CssElementTypes.CSS_RBRACE) {
                --balance;
            }
            lexer.advance();
        }
        return balance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssDeclarationBlockElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssDeclarationBlockElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseContents";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForParser";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

