/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.parameterInfo;

import com.intellij.codeInsight.hint.ExternalParameterInfoChangesProvider;
import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.model.ParameterInfoContext;
import com.jetbrains.rd.ide.model.ParameterInfoContextsModel;
import com.jetbrains.rd.ide.model.Range;
import com.jetbrains.rd.ide.model.SignatureItemModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.parameterInfo.FrontendParameterInfoHandler;
import com.jetbrains.rdclient.parameterInfo.FrontendParameterInfoHost;
import com.jetbrains.rdclient.parameterInfo.FrontendParameterInfoMediator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0003J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u0017H\u0002J\n\u0010,\u001a\u0004\u0018\u00010-H\u0002J\b\u0010.\u001a\u00020\u0017H\u0002J8\u0010/\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001f2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00067"}, d2={"Lcom/jetbrains/rdclient/parameterInfo/FrontendParameterInfoMediator;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/rd/ide/model/ParameterInfoContextsModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/ParameterInfoContextsModel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "alarmFrontendUpdate", "Lcom/intellij/util/Alarm;", "updatePublisher", "Lcom/intellij/codeInsight/hint/ExternalParameterInfoChangesProvider;", "kotlin.jvm.PlatformType", "reentrancyGuard", "", "firstTime", "update", "", "attachToModel", "items", "", "Lcom/jetbrains/rd/ide/model/SignatureItemModel;", "getItems", "()Ljava/util/List;", "matchedSignature", "", "getMatchedSignature", "()Ljava/lang/Integer;", "initialStartParameterList", "getInitialStartParameterList", "()I", "range", "Lcom/intellij/openapi/util/TextRange;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "parameterInfoContext", "Lcom/jetbrains/rd/ide/model/ParameterInfoContext;", "assertLifetime", "getParameterInfoController", "Lcom/intellij/codeInsight/hint/ParameterInfoControllerBase;", "createParameterInfo", "invoke", "file", "Lcom/intellij/psi/PsiFile;", "lBraceOffset", "highlightedElement", "Lcom/intellij/psi/PsiElement;", "requestFocus", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendParameterInfoMediator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendParameterInfoMediator.kt\ncom/jetbrains/rdclient/parameterInfo/FrontendParameterInfoMediator\n+ 2 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,170:1\n11#2,3:171\n16#2,5:190\n22#2:207\n68#3,4:174\n68#3,4:178\n68#3,4:182\n68#3,4:186\n68#3,4:195\n68#3,4:199\n68#3,4:203\n68#3,4:208\n14#3:212\n*S KotlinDebug\n*F\n+ 1 FrontendParameterInfoMediator.kt\ncom/jetbrains/rdclient/parameterInfo/FrontendParameterInfoMediator\n*L\n59#1:171,3\n59#1:190,5\n59#1:207\n60#1:174,4\n64#1:178,4\n71#1:182,4\n75#1:186,4\n64#1:195,4\n71#1:199,4\n75#1:203,4\n87#1:208,4\n32#1:212\n*E\n"})
public final class FrontendParameterInfoMediator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final ParameterInfoContextsModel model;
    @NotNull
    private final Alarm alarmFrontendUpdate;
    private final ExternalParameterInfoChangesProvider updatePublisher;
    private boolean reentrancyGuard;
    private boolean firstTime;
    @NotNull
    private static final Logger LOG;
    private static final int DELAY_MS = 200;

    private FrontendParameterInfoMediator(Lifetime lifetime, Editor editor, Project project, ParameterInfoContextsModel model2) {
        this.lifetime = lifetime;
        this.editor = editor;
        this.project = project;
        this.model = model2;
        this.alarmFrontendUpdate = new Alarm();
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ExternalParameterInfoChangesProvider.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.updatePublisher = (ExternalParameterInfoChangesProvider)messageBus.syncPublisher(topic);
        this.firstTime = true;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void update() {
        void $this$usingTrueFlag_u24default$iv;
        if (!RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
            return;
        }
        FrontendParameterInfoMediator frontendParameterInfoMediator = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)update.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            Logger logger;
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("Updating...");
            }
            if (this.firstTime) {
                ParameterInfoControllerBase controller = this.getParameterInfoController();
                if (controller != null) {
                    Logger $this$trace$iv2 = LOG;
                    boolean $i$f$trace2 = false;
                    if ($this$trace$iv2.isTraceEnabled()) {
                        logger = $this$trace$iv2;
                        boolean bl3 = false;
                        logger.trace("Dropping the previous controller");
                    }
                    Disposer.dispose((Disposable)((Disposable)controller));
                }
                this.firstTime = false;
            }
            if (this.getParameterInfoController() == null) {
                $this$trace$iv = LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl4 = false;
                    logger.trace("Create parameter info");
                }
                this.createParameterInfo();
            } else {
                $this$trace$iv = LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl5 = false;
                    logger.trace("Update parameter info");
                }
                this.updatePublisher.fireChangeAtOffset(this.editor, this.getInitialStartParameterList());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    private final void attachToModel() {
        this.model.getContext().advise(this.lifetime, arg_0 -> FrontendParameterInfoMediator.attachToModel$lambda$5(this, arg_0));
        int startParameterList = this.getInitialStartParameterList();
        this.lifetime.onTermination(() -> FrontendParameterInfoMediator.attachToModel$lambda$7(this, startParameterList));
    }

    @NotNull
    public final List<SignatureItemModel> getItems() {
        this.assertLifetime();
        return this.parameterInfoContext().getItems();
    }

    @Nullable
    public final Integer getMatchedSignature() {
        this.assertLifetime();
        return this.parameterInfoContext().getMatchedSignature();
    }

    public final int getInitialStartParameterList() {
        this.assertLifetime();
        return this.model.getInitialContext().getRange().getFrom();
    }

    @NotNull
    public final TextRange getRange() {
        this.assertLifetime();
        Range range = this.parameterInfoContext().getRange();
        int x = range.component1();
        int y = range.component2();
        return new TextRange(x, y);
    }

    private final ParameterInfoContext parameterInfoContext() {
        return (ParameterInfoContext)InterfacesKt.valueOrDefault((IOptProperty)this.model.getContext(), (Object)this.model.getInitialContext());
    }

    private final void assertLifetime() {
        LOG.assertTrue(RLifetimeKt.isAlive((Lifetime)this.lifetime), (Object)"lifetime.isAlive");
    }

    private final ParameterInfoControllerBase getParameterInfoController() {
        return ParameterInfoControllerBase.findControllerAtOffset((Editor)this.editor, (int)this.getInitialStartParameterList());
    }

    private final void createParameterInfo() {
        ThreadingAssertions.assertEventDispatchThread();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.project);
        PsiFile psiFile = documentManager.getPsiFile(this.editor.getDocument());
        if (psiFile == null) {
            FrontendParameterInfoMediator $this$createParameterInfo_u24lambda_u248 = this;
            boolean bl = false;
            LOG.error("file == null");
            return;
        }
        PsiFile file = psiFile;
        this.invoke(this.project, this.editor, file, this.getInitialStartParameterList(), null, false);
    }

    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int lBraceOffset, @Nullable PsiElement highlightedElement, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadingAssertions.assertEventDispatchThread();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null && offset > 0) {
            psiElement = file.findElementAt(offset - 1);
        }
        if (psiElement == null) {
            return;
        }
        ShowParameterInfoContext context = new ShowParameterInfoContext(editor, project, psiElement.getContainingFile(), offset, lBraceOffset, requestFocus);
        context.setHighlightedElement(highlightedElement);
        context.setRequestFocus(requestFocus);
        Language language = psiElement.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        Ref.ObjectRef handlers = new Ref.ObjectRef();
        Language[] languageArray = new Language[]{language2, file.getViewProvider().getBaseLanguage()};
        ParameterInfoHandler[] parameterInfoHandlerArray = ShowParameterInfoHandler.getHandlers((Project)project, (Language[])languageArray);
        if (parameterInfoHandlerArray == null) {
            return;
        }
        handlers.element = parameterInfoHandlerArray;
        if (((Object[])handlers.element).length == 0) {
            FrontendParameterInfoHandler[] frontendParameterInfoHandlerArray = new FrontendParameterInfoHandler[]{new FrontendParameterInfoHandler()};
            handlers.element = frontendParameterInfoHandlerArray;
        }
        DumbService dumbService = DumbService.Companion.getInstance(project);
        dumbService.runWithAlternativeResolveEnabled(() -> FrontendParameterInfoMediator.invoke$lambda$9(handlers, context));
    }

    private static final Unit attachToModel$lambda$5(FrontendParameterInfoMediator this$0, ParameterInfoContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit attachToModel$lambda$7(FrontendParameterInfoMediator this$0, int $startParameterList) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Parameter info session lifetime is terminated.");
        }
        this$0.alarmFrontendUpdate.cancelAllRequests();
        this$0.updatePublisher.fireChangeAtOffset(this$0.editor, $startParameterList);
        return Unit.INSTANCE;
    }

    private static final void invoke$lambda$9(Ref.ObjectRef $handlers, ShowParameterInfoContext $context) {
        for (ParameterInfoHandler handler : (ParameterInfoHandler[])$handlers.element) {
            Object element = handler.findElementForParameterInfo((CreateParameterInfoContext)$context);
            if (element == null) continue;
            handler.showParameterInfo(element, (CreateParameterInfoContext)$context);
        }
    }

    public /* synthetic */ FrontendParameterInfoMediator(Lifetime lifetime, Editor editor, Project project, ParameterInfoContextsModel model2, DefaultConstructorMarker $constructor_marker) {
        this(lifetime, editor, project, model2);
    }

    public static final /* synthetic */ boolean access$getReentrancyGuard$p(FrontendParameterInfoMediator $this) {
        return $this.reentrancyGuard;
    }

    public static final /* synthetic */ void access$setReentrancyGuard$p(FrontendParameterInfoMediator $this, boolean bl) {
        $this.reentrancyGuard = bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendParameterInfoMediator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/parameterInfo/FrontendParameterInfoMediator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DELAY_MS", "", "new", "Lcom/jetbrains/rdclient/parameterInfo/FrontendParameterInfoMediator;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/rd/ide/model/ParameterInfoContextsModel;", "holder", "Lcom/jetbrains/rdclient/parameterInfo/FrontendParameterInfoHost;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendParameterInfoMediator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendParameterInfoMediator.kt\ncom/jetbrains/rdclient/parameterInfo/FrontendParameterInfoMediator$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,170:1\n68#2,4:171\n*S KotlinDebug\n*F\n+ 1 FrontendParameterInfoMediator.kt\ncom/jetbrains/rdclient/parameterInfo/FrontendParameterInfoMediator$Companion\n*L\n38#1:171,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendParameterInfoMediator new(@NotNull Lifetime lifetime, @NotNull Editor editor, @NotNull Project project, @NotNull ParameterInfoContextsModel model2, @NotNull FrontendParameterInfoHost holder) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Create " + Reflection.getOrCreateKotlinClass(FrontendParameterInfoMediator.class).getSimpleName() + " with initial range " + model2.getInitialContext().getRange() + ".");
            }
            FrontendParameterInfoMediator mediator = new FrontendParameterInfoMediator(lifetime, editor, project, model2, null);
            holder.registerParameterInfoMediator(lifetime, mediator);
            lifetime.bracketIfAlive(() -> Companion.new$lambda$1(editor), () -> Companion.new$lambda$2(editor));
            mediator.attachToModel();
            return mediator;
        }

        private static final Unit new$lambda$1(Editor $editor) {
            EditorMouseHoverPopupControl.disablePopups((Editor)$editor);
            return Unit.INSTANCE;
        }

        private static final Unit new$lambda$2(Editor $editor) {
            EditorMouseHoverPopupControl.enablePopups((Editor)$editor);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

