/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverter;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverterTask;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputPathWithVariableName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputUtil;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorInitializationFlagKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellConverter;", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverter;", "<init>", "()V", "convertCell", "", "task", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverterTask;", "convertToDataInputCell", "convertInputCellToCodeCell", "getJupyterCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "intellij.jupyter.core"})
final class JupyterDataInputCellConverter
implements NotebookCellConverter {
    @Override
    public boolean convertCell(@NotNull NotebookCellConverterTask task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        return !JupyterEditorInitializationFlagKt.isJupyterInitialized(task2.getEditor()) ? false : (task2.getNewType().getJupyterCellType() == JupyterCellType.DATA_INPUT ? this.convertToDataInputCell(task2) : (JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(task2.getInterval()) == JupyterCellType.DATA_INPUT ? (WhenMappings.$EnumSwitchMapping$0[task2.getNewType().getJupyterCellType().ordinal()] == 1 ? this.convertInputCellToCodeCell(task2) : false) : false));
    }

    private final boolean convertToDataInputCell(NotebookCellConverterTask task2) {
        block1: {
            String string = task2.getEditHelper().makeCell("", NotebookCellLines.CellType.CODE, "data_input");
            if (string == null) {
                return false;
            }
            String cellCode = string;
            List<NotebookCellLines.Interval> converted = NotebookCellConverter.Companion.replaceCellWithUndoSupport(task2.getEditor(), cellCode, task2.getInterval(), task2.getCellLines());
            JupyterCell jupyterCell = this.getJupyterCell((NotebookCellLines.Interval)CollectionsKt.single(converted), task2);
            if (jupyterCell == null) break block1;
            JupyterDataInputCellMetadataKt.setDataInputMetadata(jupyterCell, JupyterDataInputCellMetadata.Companion.getDefault());
        }
        return true;
    }

    private final boolean convertInputCellToCodeCell(NotebookCellConverterTask task2) {
        NotebookCellLines.Interval interval = task2.getInterval();
        Editor editor = task2.getEditor();
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        if (backedNotebookVirtualFile == null) {
            return false;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(notebookFile.getNotebook().getCell(interval.getOrdinal()));
        if (jupyterDataInputCellMetadata == null) {
            return false;
        }
        JupyterDataInputCellMetadata metadata = jupyterDataInputCellMetadata;
        Path path = notebookFile.getFile().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path path2 = metadata.getFilePath(path);
        if (path2 == null) {
            return false;
        }
        Path path3 = path2;
        String generatedCell = JupyterDataInputUtil.INSTANCE.generateCell(notebookFile, project2, new JupyterDataInputPathWithVariableName(path3, metadata.getVariableName()), DataInputCodeGenerationContext.FOR_CONVERSION);
        String string = NotebookCellLinesEditHelper.makeCell$default(task2.getEditHelper(), generatedCell, NotebookCellLines.CellType.CODE, null, 4, null);
        if (string == null) {
            return false;
        }
        String cellText = string;
        NotebookCellConverter.Companion.replaceCellWithUndoSupport(editor, cellText, interval, NotebookCellLines.Companion.get(editor));
        return true;
    }

    private final JupyterCell getJupyterCell(NotebookCellLines.Interval interval, NotebookCellConverterTask task2) {
        Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(task2.getEditor());
        return object != null && (object = object.getNotebookOrNull()) != null ? object.getCell(interval.getOrdinal()) : null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterCellType.values().length];
            try {
                nArray[JupyterCellType.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

