/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.uml.python;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.python.uml.python.PyDummyFileClass;
import com.intellij.python.uml.python.PyDummyPackageClass;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUmlVfsResolver
implements DiagramVfsResolver<PyClass> {
    @Nullable
    public String getQualifiedName(@Nullable PyClass element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PyDummyFileClass) {
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            return virtualFile != null ? "#" + virtualFile.getCanonicalPath() : "#";
        }
        if (element instanceof PyDummyPackageClass) {
            VirtualFile virtualFile = ((PyDummyPackageClass)element).getDirectory().getVirtualFile();
            return "#" + virtualFile.getCanonicalPath();
        }
        return element.getQualifiedName();
    }

    public PyClass resolveElementByFQN(@NotNull String fqn, @NotNull Project project) {
        if (fqn == null) {
            PyUmlVfsResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PyUmlVfsResolver.$$$reportNull$$$0(1);
        }
        try {
            if (fqn.startsWith("#")) {
                String filePath2 = fqn.substring(1);
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath2);
                if (virtualFile != null) {
                    PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (file != null) {
                        return new PyDummyFileClass(file.getName(), project, (PyFile)file);
                    }
                    PsiDirectory dir = PsiManager.getInstance((Project)project).findDirectory(virtualFile);
                    if (dir != null) {
                        return new PyDummyPackageClass(project, dir);
                    }
                }
            }
            return (PyClass)ContainerUtil.getFirstItem((List)PyClassNameIndex.findByQualifiedName((String)fqn, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fqn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/uml/python/PyUmlVfsResolver";
        objectArray[2] = "resolveElementByFQN";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

