/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.huggingFace.modelChoice.modelHandling;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.python.huggingFace.modelChoice.modelHandling.ImportDetails;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001:\u0001\u001aJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J \u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J \u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/python/huggingFace/modelChoice/modelHandling/HfLibraryTemplateHandler;", "", "getCodeTemplate", "", "itemId", "pipelineTag", "getImportDetails", "Lcom/intellij/python/huggingFace/modelChoice/modelHandling/ImportDetails;", "insertCode", "", "project", "Lcom/intellij/openapi/project/Project;", "insertInPyFile", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "importDetails", "codeTemplate", "insertInIpynbFile", "insertAtOffset", "offset", "", "text", "calculateInsertionDetails", "Lcom/intellij/python/huggingFace/modelChoice/modelHandling/HfLibraryTemplateHandler$InsertionDetails;", "InsertionDetails", "intellij.python.huggingFace"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHfLibraryTemplateHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HfLibraryTemplateHandler.kt\ncom/intellij/python/huggingFace/modelChoice/modelHandling/HfLibraryTemplateHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,243:1\n648#2,5:244\n1069#2,2:249\n*S KotlinDebug\n*F\n+ 1 HfLibraryTemplateHandler.kt\ncom/intellij/python/huggingFace/modelChoice/modelHandling/HfLibraryTemplateHandler\n*L\n113#1:244,5\n115#1:249,2\n*E\n"})
public interface HfLibraryTemplateHandler {
    @NotNull
    public String getCodeTemplate(@NotNull String var1, @NotNull String var2);

    @NotNull
    public ImportDetails getImportDetails(@NotNull String var1, @NotNull String var2);

    default public void insertCode(@NotNull String itemId, @NotNull String pipelineTag, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)pipelineTag, (String)"pipelineTag");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ImportDetails importDetails = this.getImportDetails(itemId, pipelineTag);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (fileEditorManager == null || (fileEditorManager = fileEditorManager.getSelectedTextEditor()) == null) {
            return;
        }
        FileEditorManager editor = fileEditorManager;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        String codeTemplate = this.getCodeTemplate(itemId, pipelineTag);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
        if (psiFile2 instanceof PyFile) {
            this.insertInPyFile((Editor)editor, psiFile2, importDetails, codeTemplate);
        } else {
            this.insertInIpynbFile((Editor)editor, importDetails, codeTemplate);
        }
        psiDocumentManager.commitDocument(document2);
    }

    private void insertInPyFile(Editor editor, PsiFile psiFile, ImportDetails importDetails, String codeTemplate) {
        boolean insertOnEnd = false;
        if (editor.getCaretModel().getOffset() == editor.getDocument().getTextLength()) {
            this.insertAtOffset(editor, editor.getDocument().getTextLength(), "\n" + codeTemplate);
            insertOnEnd = true;
        }
        CommandProcessor.getInstance().executeCommand(editor.getProject(), () -> HfLibraryTemplateHandler.insertInPyFile$lambda$1(psiFile, importDetails), null, null);
        if (!insertOnEnd) {
            InsertionDetails insertionDetails = this.calculateInsertionDetails(editor);
            this.insertAtOffset(editor, insertionDetails.getOffset(), insertionDetails.getPrefix() + codeTemplate + insertionDetails.getPostfix());
        }
    }

    private void insertInIpynbFile(Editor editor, ImportDetails importDetails, String codeTemplate) {
        InsertionDetails insertionDetails = this.calculateInsertionDetails(editor);
        this.insertAtOffset(editor, insertionDetails.getOffset(), insertionDetails.getPrefix() + importDetails + "\n" + codeTemplate + "\n");
    }

    private void insertAtOffset(Editor editor, int offset, String text) {
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        CommandProcessor.getInstance().executeCommand(project2, () -> HfLibraryTemplateHandler.insertAtOffset$lambda$3(editor, offset, text), null, null);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
    }

    private InsertionDetails calculateInsertionDetails(Editor editor) {
        boolean bl;
        String prefix;
        int lineEndOffset;
        int lineNumber;
        Document document;
        block4: {
            String string;
            String lineContents;
            block3: {
                Document document2 = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                document = document2;
                lineNumber = document.getLineNumber(editor.getCaretModel().getOffset());
                int lineStartOffset = document.getLineStartOffset(lineNumber);
                lineEndOffset = document.getLineEndOffset(lineNumber);
                String string2 = document.getText(new TextRange(lineStartOffset, lineEndOffset));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                lineContents = string2;
                String string3 = document.getText(new TextRange(lineStartOffset, editor.getCaretModel().getOffset()));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                String partialContents = string3;
                if (StringsKt.isBlank((CharSequence)partialContents)) {
                    String string4 = document.getText(new TextRange(editor.getCaretModel().getOffset(), lineEndOffset));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                    String restOfTheLine = string4;
                    return StringsKt.isBlank((CharSequence)restOfTheLine) ? new InsertionDetails(editor.getCaretModel().getOffset(), "", "") : (!StringsKt.isBlank((CharSequence)lineContents) ? new InsertionDetails(lineStartOffset, "", "\n") : new InsertionDetails(lineStartOffset, "\n", ""));
                }
                String $this$takeWhile$iv = lineContents;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    int n2 = 0;
                    if (CharsKt.isWhitespace((char)it)) continue;
                    String string5 = $this$takeWhile$iv;
                    n2 = 0;
                    String string6 = string5.substring(n2, index$iv);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    break block3;
                }
                string = $this$takeWhile$iv;
            }
            String prefixWhitespaces = string;
            prefix = "\n" + prefixWhitespaces;
            CharSequence $this$all$iv = lineContents;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        int offset = bl ? document.getLineEndOffset(lineNumber) : lineEndOffset;
        return new InsertionDetails(offset, prefix, "");
    }

    private static void insertInPyFile$lambda$1$lambda$0(PsiFile $psiFile, ImportDetails $importDetails) {
        AddImportHelper.addOrUpdateFromImportStatement((PsiFile)$psiFile, (String)$importDetails.getFrom(), (String)$importDetails.getName(), (String)$importDetails.getAsName(), (AddImportHelper.ImportPriority)$importDetails.getPriority(), null);
    }

    private static void insertInPyFile$lambda$1(PsiFile $psiFile, ImportDetails $importDetails) {
        ApplicationManager.getApplication().runWriteAction(() -> HfLibraryTemplateHandler.insertInPyFile$lambda$1$lambda$0($psiFile, $importDetails));
    }

    private static void insertAtOffset$lambda$3$lambda$2(Editor $editor, int $offset, String $text) {
        $editor.getDocument().insertString($offset, (CharSequence)$text);
    }

    private static void insertAtOffset$lambda$3(Editor $editor, int $offset, String $text) {
        ApplicationManager.getApplication().runWriteAction(() -> HfLibraryTemplateHandler.insertAtOffset$lambda$3$lambda$2($editor, $offset, $text));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/huggingFace/modelChoice/modelHandling/HfLibraryTemplateHandler$InsertionDetails;", "", "offset", "", "prefix", "", "postfix", "<init>", "(ILjava/lang/String;Ljava/lang/String;)V", "getOffset", "()I", "getPrefix", "()Ljava/lang/String;", "getPostfix", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.python.huggingFace"})
    private static final class InsertionDetails {
        private final int offset;
        @NotNull
        private final String prefix;
        @NotNull
        private final String postfix;

        public InsertionDetails(int offset, @NotNull String prefix, @NotNull String postfix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
            this.offset = offset;
            this.prefix = prefix;
            this.postfix = postfix;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getPostfix() {
            return this.postfix;
        }

        public final int component1() {
            return this.offset;
        }

        @NotNull
        public final String component2() {
            return this.prefix;
        }

        @NotNull
        public final String component3() {
            return this.postfix;
        }

        @NotNull
        public final InsertionDetails copy(int offset, @NotNull String prefix, @NotNull String postfix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
            return new InsertionDetails(offset, prefix, postfix);
        }

        public static /* synthetic */ InsertionDetails copy$default(InsertionDetails insertionDetails, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = insertionDetails.offset;
            }
            if ((n2 & 2) != 0) {
                string = insertionDetails.prefix;
            }
            if ((n2 & 4) != 0) {
                string2 = insertionDetails.postfix;
            }
            return insertionDetails.copy(n, string, string2);
        }

        @NotNull
        public String toString() {
            return "InsertionDetails(offset=" + this.offset + ", prefix=" + this.prefix + ", postfix=" + this.postfix + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.offset);
            result = result * 31 + this.prefix.hashCode();
            result = result * 31 + this.postfix.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InsertionDetails)) {
                return false;
            }
            InsertionDetails insertionDetails = (InsertionDetails)other;
            if (this.offset != insertionDetails.offset) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)insertionDetails.prefix)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.postfix, (Object)insertionDetails.postfix);
        }
    }
}

