/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlSignatureInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            SqlSignatureInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlSignatureInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlSignatureInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, (SqlLanguageDialect)dialect, result){

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
                super.visitSqlFunctionCallExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlReferenceExpression nameElement = o.getNameElement();
                SqlExpressionList params = o.getParameterList();
                if (nameElement == null || params == null) {
                    return;
                }
                Object[] lists = SqlFunctionsUtil.getOverloads((SqlFunctionCallExpression)o);
                if (lists.length != 0 && JBIterable.of((Object[])lists).filter(SqlFunctionsUtil.ExpressionList::isMatched).isEmpty()) {
                    this.reportProblem(o, nameElement.getName());
                }
            }

            private void reportProblem(@NotNull SqlFunctionCallExpression ex, @NlsSafe @NotNull String name2) {
                SqlReferenceExpression nameElement;
                if (ex == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (name2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElement el = (PsiElement)ObjectUtils.chooseNotNull((Object)((nameElement = ex.getNameElement()) == null ? null : nameElement.getIdentifier()), (Object)ex);
                this.addDescriptor(this.myManager.createProblemDescriptor(el, SqlBundle.message((String)"inspection.message.could.not.take.such.arguments", (Object[])new Object[]{name2}), (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ex";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/inspections/SqlSignatureInspection$1";
                objectArray[2] = "reportProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlSignatureInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

