/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.diagram.DbDiagramColorManager;
import com.intellij.database.diagram.DbDiagramDataModel;
import com.intellij.database.diagram.DbDiagramElementManager;
import com.intellij.database.diagram.DbDiagramExtras;
import com.intellij.database.diagram.actions.DbDiagramCreateObjectGroup;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.core.actions.DiagramSourceActionsGroup;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Function;
import com.intellij.util.LazyKt;
import icons.DatabaseIcons;
import kotlin.Lazy;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbDiagramProvider
extends DiagramProvider<DbElement>
implements DumbAware {
    public static final String ID = "DATABASE";
    private final DbDiagramElementManager myElementManager = new DbDiagramElementManager();
    private final Lazy<DiagramNodeContentManager> myCategoryManager = LazyKt.lazyPub(this::createNodeContentManager);

    public DbDiagramProvider() {
        this.myElementManager.setUmlProvider(this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    @NotNull
    public String getID() {
        return ID;
    }

    @NotNull
    public DiagramColorManager getColorManager() {
        DiagramColorManager diagramColorManager = (DiagramColorManager)ApplicationManager.getApplication().getService(DbDiagramColorManager.class);
        if (diagramColorManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(0);
        }
        return diagramColorManager;
    }

    @NotNull
    public DiagramVisibilityManager createVisibilityManager() {
        DiagramVisibilityManager diagramVisibilityManager = EmptyDiagramVisibilityManager.INSTANCE;
        if (diagramVisibilityManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(1);
        }
        return diagramVisibilityManager;
    }

    @NotNull
    public DiagramNodeContentManager getNodeContentManager() {
        DiagramNodeContentManager diagramNodeContentManager = (DiagramNodeContentManager)this.myCategoryManager.getValue();
        if (diagramNodeContentManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(2);
        }
        return diagramNodeContentManager;
    }

    @NotNull
    public DiagramNodeContentManager createNodeContentManager() {
        return new AbstractDiagramNodeContentManager(){
            private final DiagramCategory COLUMNS = new DiagramCategory(DatabaseBundle.messagePointer((String)"category.name.columns", (Object[])new Object[0]), DatabaseIcons.Col, true);
            private final DiagramCategory ID_COLUMNS = new DiagramCategory(DatabaseBundle.messagePointer((String)"category.name.key.columns", (Object[])new Object[0]), DatabaseIcons.ColGoldKey, true);
            private final DiagramCategory[] CATEGORIES = new DiagramCategory[]{this.ID_COLUMNS, this.COLUMNS, Holder.VIRTUAL_FOREIGN_KEYS, Holder.COMMENTS};

            public DiagramCategory @NotNull [] getContentCategories() {
                if (this.CATEGORIES == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.CATEGORIES;
            }

            public boolean isInCategory(@Nullable Object nodeElement, @Nullable Object item, @NotNull DiagramCategory category, @Nullable DiagramBuilder builder) {
                if (category == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.COLUMNS.equals((Object)category)) {
                    return item instanceof DbColumn && !DasUtil.isPrimary((DasColumn)((DbColumn)item));
                }
                if (this.ID_COLUMNS.equals((Object)category)) {
                    return item instanceof DbColumn && DasUtil.isPrimary((DasColumn)((DbColumn)item));
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/diagram/DbDiagramProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "category";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentCategories";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/diagram/DbDiagramProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isInCategory";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    public DiagramElementManager<DbElement> getElementManager() {
        DbDiagramElementManager dbDiagramElementManager = this.myElementManager;
        if (dbDiagramElementManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(3);
        }
        return dbDiagramElementManager;
    }

    @NotNull
    public DiagramVfsResolver<DbElement> getVfsResolver() {
        DiagramVfsResolver<DbElement> diagramVfsResolver = Holder.myVfsResolver;
        if (diagramVfsResolver == null) {
            DbDiagramProvider.$$$reportNull$$$0(4);
        }
        return diagramVfsResolver;
    }

    @NotNull
    public DiagramRelationshipManager<DbElement> getRelationshipManager() {
        DiagramRelationshipManager<DbElement> diagramRelationshipManager = Holder.myRelationshipManager;
        if (diagramRelationshipManager == null) {
            DbDiagramProvider.$$$reportNull$$$0(5);
        }
        return diagramRelationshipManager;
    }

    @NotNull
    public DiagramPresentationModel createPresentationModel(@NotNull Project project, @NotNull Graph2D graph) {
        if (project == null) {
            DbDiagramProvider.$$$reportNull$$$0(6);
        }
        if (graph == null) {
            DbDiagramProvider.$$$reportNull$$$0(7);
        }
        return new DiagramPresentationModelImpl(graph, project, this){

            @NotNull
            protected AnAction getSourceActionGroup() {
                return new DiagramSourceActionsGroup(){

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.update(e);
                        e.getPresentation().setPopupGroup(true);
                        if (e.getPresentation().isEnabledAndVisible()) {
                            e.getPresentation().setText(DiagramBundle.message((String)"group.UML.SourceActionsGroup.text", (Object[])new Object[0]));
                        }
                    }

                    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                        ActionManager am = ActionManager.getInstance();
                        AnAction[] anActionArray = new AnAction[]{am.getAction("$Copy"), am.getAction("CopyReference"), Separator.getInstance(), am.getAction("FindUsages"), am.getAction("Uml.SourceActionsGroup.QuickActions"), am.getAction("DbDiagrams.SourceActionsGroup.GoTo"), Separator.getInstance(), am.getAction("DatabaseView.Ddl.AlterObject")};
                        if (anActionArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return anActionArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/database/diagram/DbDiagramProvider$2$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/database/diagram/DbDiagramProvider$2$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getChildren";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "update";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                };
            }
        };
    }

    public AnAction @NotNull [] getCreateNewActions() {
        AnAction[] anActionArray = new AnAction[]{new DbDiagramCreateObjectGroup()};
        if (anActionArray == null) {
            DbDiagramProvider.$$$reportNull$$$0(8);
        }
        return anActionArray;
    }

    @NotNull
    public DiagramDataModel<DbElement> createDataModel(@NotNull Project project, @Nullable DbElement element, @Nullable VirtualFile file, @NotNull DiagramPresentationModel presentationModel) {
        if (project == null) {
            DbDiagramProvider.$$$reportNull$$$0(9);
        }
        if (presentationModel == null) {
            DbDiagramProvider.$$$reportNull$$$0(10);
        }
        return new DbDiagramDataModel(project, element, this);
    }

    @NotNull
    public DiagramExtras<DbElement> getExtras() {
        DiagramExtras<DbElement> diagramExtras = Holder.myExtras;
        if (diagramExtras == null) {
            DbDiagramProvider.$$$reportNull$$$0(11);
        }
        return diagramExtras;
    }

    @NotNull
    public String getActionName(boolean isPopup) {
        String string = DatabaseBundle.message((String)"database.uml.action.name", (Object[])new Object[0]);
        if (string == null) {
            DbDiagramProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = DatabaseBundle.message((String)"database.schema.diagram", (Object[])new Object[0]);
        if (string == null) {
            DbDiagramProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramProvider";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibilityManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeContentManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVfsResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationshipManager";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateNewActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtras";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPresentationModel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDataModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    static final class Holder {
        static final DiagramCategory VIRTUAL_FOREIGN_KEYS = new DiagramCategory(DatabaseBundle.messagePointer((String)"category.name.virtual.foreign.keys", (Object[])new Object[0]), DatabaseIcons.VirtualForeignKey, true, true);
        static final DiagramCategory COMMENTS = new DiagramCategory(DatabaseBundle.messagePointer((String)"category.name.comments", (Object[])new Object[0]), AllIcons.General.Balloon, true);
        static final DiagramVfsResolver<DbElement> myVfsResolver = new DiagramVfsResolver<DbElement>(){

            public String getQualifiedName(@Nullable DbElement element) {
                return element == null ? null : element.getDataSource().getUniqueId() + (String)(element instanceof DbDataSource ? "" : "." + element.getKind().name() + ":" + QNameUtil.getQualifiedName((DbElement)element));
            }

            public DbElement resolveElementByFQN(@NotNull String fqn, @NotNull Project project) {
                if (fqn == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                int idx = fqn.indexOf(46);
                DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(idx == -1 ? fqn : fqn.substring(0, idx));
                if (dataSource == null || idx == -1) {
                    return dataSource;
                }
                String typedQName = fqn.substring(idx + 1);
                String qname = typedQName.substring(typedQName.indexOf(58) + 1);
                for (DasObject object : QNameUtil.findByQName((DasModel)dataSource.getModel(), (String)qname, (Function)DasUtil.TO_NAME)) {
                    if (!typedQName.startsWith(object.getKind().name() + ":")) continue;
                    return DbImplUtilCore.findElement((DbDataSource)dataSource, (DasObject)object);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fqn";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/diagram/DbDiagramProvider$Holder$1";
                objectArray[2] = "resolveElementByFQN";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        static final DiagramRelationshipManager<DbElement> myRelationshipManager = new DiagramRelationshipManager<DbElement>(){

            @Nullable
            public DiagramRelationshipInfo getDependencyInfo(DbElement e1, DbElement e2, DiagramCategory category) {
                return null;
            }

            public DiagramCategory @NotNull [] getContentCategories() {
                if (DiagramCategory.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(0);
                }
                return DiagramCategory.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diagram/DbDiagramProvider$Holder$2", "getContentCategories"));
            }
        };
        static final DiagramExtras<DbElement> myExtras = new DbDiagramExtras();

        Holder() {
        }
    }
}

