/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.dialects.DefinitionProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.UtilKt;
import com.intellij.database.script.generator.ui.ScriptGeneratorTool;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateSqlActions {
    @NotNull
    static JBIterable<BasicElement> getElements(AnActionEvent e, boolean scriptableOnly) {
        JBIterable result = DatabaseContextFun.getSelectedElements(e.getDataContext());
        JBIterable jBIterable = scriptableOnly ? result.filter(GenerateSqlActions::isElementScriptable) : result;
        if (jBIterable == null) {
            GenerateSqlActions.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public static AsyncTask<Void> generateDbDdl(@NotNull DefinitionProvider provider, @NotNull List<DbElement> objects, @NotNull ErrorHandler handler2, @NotNull StringBuilder builder, boolean markDb) {
        List<DbElement> current;
        DbElement first2;
        LocalDataSource dataSource;
        if (provider == null) {
            GenerateSqlActions.$$$reportNull$$$0(1);
        }
        if (objects == null) {
            GenerateSqlActions.$$$reportNull$$$0(2);
        }
        if (handler2 == null) {
            GenerateSqlActions.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            GenerateSqlActions.$$$reportNull$$$0(4);
        }
        LocalDataSource localDataSource = dataSource = (first2 = (DbElement)ContainerUtil.getFirstItem(objects)) == null ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)first2.getDataSource());
        if (dataSource == null) {
            return AsyncTask.completed(null);
        }
        ObjectPath path = ObjectPaths.of((DasObject)DasUtil.getNamespace((DasObject)first2));
        ArrayList rest = new ArrayList();
        if (JdbcUrlParserUtil.isDatabaseBounded((DatabaseConnectionPoint)dataSource)) {
            current = new ArrayList<DbElement>();
            for (DbElement object : objects) {
                (JdbcUrlParserUtil.outOfBounds((DatabaseConnectionPoint)dataSource, (ObjectPath)path, (ObjectPath)ObjectPaths.of((DasObject)object)) ? rest : current).add(object);
            }
        } else {
            current = objects;
        }
        Project project = first2.getProject();
        SearchPath searchPath = SearchPath.of((ObjectPath)path);
        return DatabaseSessionManager.getFacade(project, (DatabaseConnectionPoint)dataSource, null, searchPath, false, handler2, (DatabaseDepartment)DGDepartment.CODE_GENERATION).runAsync(SessionsUtil.function(connection2 -> {
            if (!rest.isEmpty() || markDb) {
                builder.append("-- Database ").append(DasUtil.getCatalog((DasObject)first2)).append("\n");
            }
            provider.load((Iterable)current, (DatabaseConnectionCore)connection2, builder);
            return null;
        })).applyAsync(AsyncUtil.getPoolExecutor(), r -> rest.isEmpty() ? AsyncTask.completed(null) : GenerateSqlActions.generateDbDdl(provider, rest, handler2, builder, true));
    }

    public static ActionStatus checkActionScriptableStatus(@NotNull JBIterable<BasicElement> elements, @Nullable Predicate<BasicElement> applicabilityPredicate) {
        if (elements == null) {
            GenerateSqlActions.$$$reportNull$$$0(5);
        }
        JBIterable unwantedElements = elements.filter(x -> x instanceof BasicNamespaceOwner);
        JBIterable applicableElements = elements;
        if (applicabilityPredicate != null) {
            applicableElements = applicableElements.filter(applicabilityPredicate::test);
        }
        if (applicableElements.isEmpty()) {
            return ActionStatus.HIDDEN;
        }
        if (unwantedElements.isNotEmpty()) {
            return ActionStatus.DISABLED;
        }
        BasicModel model = (BasicModel)applicableElements.map(BasicNode::getModel).unique().single();
        if (model == null) {
            return ActionStatus.DISABLED;
        }
        JBIterable scriptableElements = applicableElements.filter(GenerateSqlActions::isBasicElementScriptable);
        return scriptableElements.isNotEmpty() ? ActionStatus.ENABLED : ActionStatus.DISABLED;
    }

    private static boolean isElementScriptable(@Nullable BasicElement element) {
        if (element == null) {
            return false;
        }
        return element instanceof BasicSchemaObject || element instanceof BasicSchema;
    }

    private static boolean isBasicElementScriptable(@Nullable BasicElement element) {
        return element != null;
    }

    @NotNull
    private static String doGenerateDDLUnderProgress(@NotNull Collection<BasicElement> selectedElements, @NotNull Project project, @Nls String actionName) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(7);
        }
        String string = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GenerateSqlActions.doGenerateDDL(selectedElements, project, actionName), DatabaseBundle.message((String)"progress.title.generating.code", (Object[])new Object[0]), true, project);
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDL(@NotNull Collection<BasicElement> selectedElements, @NotNull Project project, @Nls String actionName) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(10);
        }
        TreePattern scope2 = null;
        for (BasicElement e : selectedElements) {
            if (!(e instanceof BasicRoot)) continue;
            scope2 = GenerateSqlActions.getIntrospectionScope((BasicRoot)e, project);
            break;
        }
        return GenerateSqlActions.doGenerateDDLUsingScriptingService(project, scope2, selectedElements, actionName);
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(Project project, @Nullable TreePattern scope2, @NotNull Collection<BasicElement> selectedElements, @Nls String actionName) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(11);
        }
        Map groupedByModels = ModelFun.groupByModel(selectedElements);
        StringBuilder b = new StringBuilder();
        for (Map.Entry entry : groupedByModels.entrySet()) {
            BasicModel m = (BasicModel)entry.getKey();
            ArrayList<BasicElement> elements = new ArrayList<BasicElement>((Collection)entry.getValue());
            GenerateSqlActions.abortIfSyncRequired(project, m, elements, actionName);
            String text = GenerateSqlActions.doGenerateDDLUsingScriptingService(project, scope2, m, elements);
            if (text.isEmpty()) continue;
            if (!b.isEmpty()) {
                b.append("\n\n");
            }
            b.append(text);
        }
        String string = b.toString();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void abortIfSyncRequired(Project project, BasicModel m, Collection<BasicElement> elements, @Nls String actionName) {
        RawDataSource dataSource = ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDataSource((BasicElement)m.getRoot());
        DetailsSyncHelper syncHelper = DetailsSyncHelper.of(project, (DasDataSource)dataSource, null);
        if (syncHelper.check(elements).askAbortIfSyncRequiredAnyThread(actionName)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull Project project, @Nullable TreePattern scope2, @NotNull BasicModel model, @NotNull Iterable<? extends BasicElement> selectedElements) {
        JBIterable explicitSchemata;
        JBIterable selection;
        JBIterable visibleDatabasesOfRoot;
        JBIterable databasesSchemata;
        List schemata;
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(13);
        }
        if (model == null) {
            GenerateSqlActions.$$$reportNull$$$0(14);
        }
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(15);
        }
        BasicSchema schema = (schemata = (databasesSchemata = (visibleDatabasesOfRoot = (selection = JBIterable.from(selectedElements)).filter(BasicMultiDatabaseRoot.class).flatten(BasicMultiDatabaseRoot::getDatabases).filter(BasicDatabase.class).filter(d -> scope2 == null || DataSourceSchemaMapping.matches((TreePattern)scope2, (DasObject)d))).append((Iterable)selection.filter(BasicDatabase.class).filter(db -> !visibleDatabasesOfRoot.contains(db))).flatten(BasicDatabase::getSchemas).filter(BasicSchema.class).filter(s -> !s.isNameSurrogate()).filter(s -> scope2 == null || DataSourceSchemaMapping.matches((TreePattern)scope2, (DasObject)s))).append((Iterable)(explicitSchemata = selection.filter(BasicSchema.class).filter(s -> !databasesSchemata.contains(s)))).toList()).size() == 1 ? (BasicSchema)schemata.get(0) : null;
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_DEFINITION);
        JBIterable.from((Iterable)schemata).flatten(UtilKt::getScriptableMajorObjects).append((Iterable)selection.filter(o -> !schemata.contains(o.getSchema()))).addAllTo(taskBuilder.getElements());
        taskBuilder.setCurrentSchema(schema);
        ScriptingSingleModelTask scriptingTask = taskBuilder.build();
        ScriptingResult result = ScriptGenerators.INSTANCE.makeScript(project, (ScriptingTask)scriptingTask);
        String string = result.getScriptText();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    private static TreePattern getIntrospectionScope(@NotNull BasicRoot root, @NotNull Project project) {
        DbModelRegistry modelRegistry;
        if (root == null) {
            GenerateSqlActions.$$$reportNull$$$0(17);
        }
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(18);
        }
        if ((modelRegistry = (DbModelRegistry)project.getService(DbModelRegistry.class)) == null) {
            return null;
        }
        RawDataSource ds = modelRegistry.findDataSource((BasicElement)root);
        return ds instanceof LocalDataSource ? ((LocalDataSource)ds).getIntrospectionScope() : null;
    }

    @Nullable
    private static DbElement findDbElement(@NotNull BasicElement element, @NotNull Project project) {
        DbModelRegistry r;
        if (element == null) {
            GenerateSqlActions.$$$reportNull$$$0(19);
        }
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(20);
        }
        if ((r = (DbModelRegistry)project.getService(DbModelRegistry.class)) == null) {
            return null;
        }
        return r.findDbElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDLUnderProgress";
                break;
            }
            case 12: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDLUsingScriptingService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDbDdl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkActionScriptableStatus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDLUnderProgress";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDL";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDLUsingScriptingService";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIntrospectionScope";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findDbElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }

    static class ShowSqlGeneratorAction
    extends DumbAwareAction {
        ShowSqlGeneratorAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(1);
            }
            ActionStatus status = GenerateSqlActions.checkActionScriptableStatus(GenerateSqlActions.getElements(e, false), null);
            e.getPresentation().setVisible(status.visible || e.isFromActionToolbar());
            e.getPresentation().setEnabled(status.enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<BasicElement> basicElements;
            JBIterable scriptableElements;
            if (e == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(2);
            }
            if ((scriptableElements = (basicElements = GenerateSqlActions.getElements(e, false)).filter(GenerateSqlActions::isBasicElementScriptable)).isEmpty()) {
                return;
            }
            Project project = e.getProject();
            BasicModel model = (BasicModel)basicElements.map(BasicNode::getModel).unique().single();
            if (project == null || model == null) {
                return;
            }
            ScriptGeneratorTool.INSTANCE.show(project, model, (Iterable<? extends BasicNode>)scriptableElements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$ShowSqlGeneratorAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$ShowSqlGeneratorAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class OpenDdlInConsoleAction
    extends DumbAwareAction {
        OpenDdlInConsoleAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(1);
            }
            boolean enabled = GenerateSqlActions.getElements(e, true).find(el -> DbImplUtilCore.getDbms((BasicElement)el) != Dbms.MONGO) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            List elements = GenerateSqlActions.getElements(e, true).unique().toList();
            String ddl = GenerateSqlActions.doGenerateDDLUnderProgress(elements, project, e.getPresentation().getText());
            if (StringUtil.isEmpty((String)ddl)) {
                return;
            }
            BasicElement firstElement = (BasicElement)elements.get(0);
            DbElement firstDbElement = GenerateSqlActions.findDbElement(firstElement, project);
            DbUIUtil.openInConsole(firstDbElement, ddl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$OpenDdlInConsoleAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$OpenDdlInConsoleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class CopyDdlAction
    extends DumbAwareAction {
        CopyDdlAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CopyDdlAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyDdlAction.$$$reportNull$$$0(1);
            }
            boolean enabled = GenerateSqlActions.getElements(e, false).find(el -> DbImplUtilCore.getDbms((BasicElement)el) != Dbms.MONGO) != null;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List elements;
            if (e == null) {
                CopyDdlAction.$$$reportNull$$$0(2);
            }
            if ((elements = GenerateSqlActions.getElements(e, false).unique().toList()).isEmpty()) {
                return;
            }
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            String actionName = e.getPresentation().getText();
            String ddlScript = GenerateSqlActions.doGenerateDDLUnderProgress(elements, project, actionName);
            CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
            copyPasteManager.setContents((Transferable)new StringSelection(ddlScript));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class CopyDdlFromDbAction
    extends DumbAwareAction {
        CopyDdlFromDbAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(1);
            }
            JBIterable<DbElement> objects = this.getObjects(e.getDataContext());
            JBIterable<DbElement> supported = this.filterSupported(objects);
            boolean visible = !objects.isEmpty();
            boolean enabled = visible && !supported.isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<DbElement> objects;
            DbElement first2;
            DefinitionProvider provider;
            if (e == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(2);
            }
            if ((provider = this.getProvider(first2 = (DbElement)(objects = this.getObjects(e.getDataContext())).first())) == null || first2 == null) {
                return;
            }
            AsyncTask.withBgIndicator((AsyncTask.Frame)AsyncTask.frame((String)DatabaseBundle.message((String)"action.DatabaseView.CopyDdlFromDbAction.loading.sources", (Object[])new Object[0])), (Project)first2.getProject(), null, (boolean)true).sync(() -> {
                ErrorHandler handler2 = new ErrorHandler();
                StringBuilder builder = new StringBuilder();
                GenerateSqlActions.generateDbDdl(provider, objects.filter(arg_0 -> ((DefinitionProvider)provider).isSupported(arg_0)).toList(), handler2, builder, false).whenComplete(AsyncUtil.getEdtExecutor(), (s, throwable) -> {
                    if (throwable != null) {
                        AsyncUtil.addUnhandledError((ErrorHandler)handler2, (Throwable)throwable, (LocalDataSource)DbImplUtil.getMaybeLocalDataSource((DasDataSource)first2.getDataSource()));
                        if (handler2.hasErrors()) {
                            ConnDatabaseNotifications.DATABASE_EXECUTION_GROUP().createNotification(handler2.getSummary(), MessageType.ERROR).setDisplayId("CopyDdlFromDbAction.error").notify(e.getProject());
                        }
                    } else {
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(builder.toString()));
                    }
                });
                return null;
            });
        }

        @NotNull
        JBIterable<DbElement> getObjects(DataContext context) {
            JBIterable<DbElement> objects = DatabaseContextFun.getSelectedDbElementsExpandingGroups(context);
            DbElement first2 = (DbElement)objects.first();
            if (first2 == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    CopyDdlFromDbAction.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            DbDataSource dataSource = first2.getDataSource();
            JBIterable jBIterable = objects.filter(o -> o != dataSource && o.getDataSource() == dataSource);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @NotNull
        JBIterable<DbElement> filterSupported(@NotNull JBIterable<DbElement> objects) {
            DefinitionProvider provider;
            if (objects == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(5);
            }
            JBIterable jBIterable = (provider = this.getProvider((DbElement)objects.first())) == null ? JBIterable.empty() : objects.filter(arg_0 -> ((DefinitionProvider)provider).isSupported(arg_0));
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        @Nullable
        DefinitionProvider getProvider(@Nullable DbElement first2) {
            if (first2 == null) {
                return null;
            }
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)first2.getDataSource());
            if (localDataSource == null) {
                return null;
            }
            return AbstractDefinitionProvider.find((LocalDataSource)localDataSource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterSupported";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "filterSupported";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

