/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TtyConnectorAccessor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalStartupMoment;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.BlockTerminalInitializationListener;
import org.jetbrains.plugins.terminal.block.BlockTerminalStartupResponsivenessReporterKt;
import org.jetbrains.plugins.terminal.block.BlockTerminalView;
import org.jetbrains.plugins.terminal.block.OldPlainTerminalView;
import org.jetbrains.plugins.terminal.block.TerminalContentView;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.ui.BlockTerminalColorPalette;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001GB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0017J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u001aH\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020/H\u0016J\b\u00101\u001a\u00020\"H\u0016J\u0018\u00102\u001a\u00020\"2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0007H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u001aH\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020/H\u0016J\u0018\u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0007H\u0016J\b\u0010>\u001a\u00020\"H\u0016J\b\u0010?\u001a\u000204H\u0016J\b\u0010@\u001a\u000204H\u0016J\u0010\u0010E\u001a\u00020\"2\u0006\u0010A\u001a\u00020BH\u0016J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00110'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\u0004\u0018\u00010B8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\u00a8\u0006H"}, d2={"Lorg/jetbrains/plugins/terminal/block/TerminalWidgetImpl;", "Lcom/intellij/terminal/ui/TerminalWidget;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;", "parent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;Lcom/intellij/openapi/Disposable;)V", "wrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "getTerminalTitle", "()Lcom/intellij/terminal/TerminalTitle;", "termSize", "Lcom/jediterm/core/util/TermSize;", "getTermSize", "()Lcom/jediterm/core/util/TermSize;", "ttyConnectorAccessor", "Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "getTtyConnectorAccessor", "()Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "shellCommand", "", "", "getShellCommand", "()Ljava/util/List;", "setShellCommand", "(Ljava/util/List;)V", "view", "Lorg/jetbrains/plugins/terminal/block/TerminalContentView;", "connectToTty", "", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "initialize", "Ljava/util/concurrent/CompletableFuture;", "options", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "createBlockTerminalView", "writePlainMessage", "message", "setCursorVisible", "visible", "", "hasFocus", "requestFocus", "addNotification", "notificationComponent", "Ljavax/swing/JComponent;", "disposable", "sendCommandToExecute", "getText", "", "isCommandRunning", "addTerminationCallback", "onTerminated", "Ljava/lang/Runnable;", "parentDisposable", "dispose", "getComponent", "getPreferredFocusableComponent", "session", "Lcom/intellij/terminal/session/TerminalSession;", "getSession", "()Lcom/intellij/terminal/session/TerminalSession;", "connectToSession", "getTerminalSizeInitializedFuture", "TerminalPlaceholder", "intellij.terminal"})
public final class TerminalWidgetImpl
implements TerminalWidget {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProvider settings;
    @NotNull
    private final Wrapper wrapper;
    @NotNull
    private final TerminalTitle terminalTitle;
    @NotNull
    private final TtyConnectorAccessor ttyConnectorAccessor;
    @Nullable
    private List<String> shellCommand;
    @NotNull
    private volatile TerminalContentView view;

    public TerminalWidgetImpl(@NotNull Project project, @NotNull JBTerminalSystemSettingsProvider settings, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.settings = settings;
        this.wrapper = new Wrapper();
        this.terminalTitle = new TerminalTitle();
        this.ttyConnectorAccessor = new TtyConnectorAccessor();
        this.view = new TerminalPlaceholder();
        this.wrapper.setContent(this.view.getComponent());
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.view);
    }

    @NotNull
    public TerminalTitle getTerminalTitle() {
        return this.terminalTitle;
    }

    @Nullable
    public TermSize getTermSize() {
        return this.view.getTerminalSize();
    }

    @NotNull
    public TtyConnectorAccessor getTtyConnectorAccessor() {
        return this.ttyConnectorAccessor;
    }

    @Nullable
    public List<String> getShellCommand() {
        return this.shellCommand;
    }

    public void setShellCommand(@Nullable List<String> list) {
        this.shellCommand = list;
    }

    @RequiresEdt(generateAssertion=false)
    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        this.view.connectToTty(ttyConnector, initialTermSize);
        this.getTtyConnectorAccessor().setTtyConnector(ttyConnector);
    }

    @RequiresEdt(generateAssertion=false)
    @NotNull
    public final CompletableFuture<TermSize> initialize(@NotNull ShellStartupOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TerminalContentView oldView = this.view;
        ShellIntegration shellIntegration = options.getShellIntegration();
        TerminalContentView terminalContentView = this.view = (shellIntegration != null ? shellIntegration.getCommandBlockIntegration() : null) != null ? this.createBlockTerminalView(options) : (TerminalContentView)new OldPlainTerminalView(this.project, this.settings, this.getTerminalTitle());
        if (oldView instanceof TerminalPlaceholder) {
            ((TerminalPlaceholder)oldView).moveTerminationCallbacksTo(this.view);
            ((TerminalPlaceholder)oldView).executePostponedShellCommands(this.view);
        }
        Disposer.dispose((Disposable)oldView);
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.view);
        JComponent component2 = this.view.getComponent();
        this.wrapper.setContent(component2);
        this.requestFocus();
        CompletableFuture<?> future = this.view.getTerminalSizeInitializedFuture();
        TerminalUiUtils.INSTANCE.cancelFutureByTimeout(future, 2000L, this.view);
        CompletionStage completionStage = future.thenApply(arg_0 -> TerminalWidgetImpl.initialize$lambda$0(new Function1(this){
            final /* synthetic */ TerminalWidgetImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final TermSize invoke(Object it) {
                return TerminalWidgetImpl.access$getView$p(this.this$0).getTerminalSize();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final TerminalContentView createBlockTerminalView(ShellStartupOptions options) {
        BlockTerminalView blockTerminalView;
        JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase = this.settings;
        TerminalColorPalette terminalColorPalette = new BlockTerminalColorPalette();
        ShellIntegration shellIntegration = options.getShellIntegration();
        Intrinsics.checkNotNull((Object)shellIntegration);
        BlockTerminalSession session2 = new BlockTerminalSession(jBTerminalSystemSettingsProviderBase, terminalColorPalette, shellIntegration);
        Disposer.register((Disposable)((Disposable)this), (Disposable)session2);
        BlockTerminalView it = blockTerminalView = new BlockTerminalView(this.project, session2, this.settings, this.getTerminalTitle());
        boolean bl = false;
        TerminalStartupMoment terminalStartupMoment = options.getStartupMoment$intellij_terminal();
        if (terminalStartupMoment == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        BlockTerminalStartupResponsivenessReporterKt.installStartupResponsivenessReporter(this.project, terminalStartupMoment, session2);
        ((BlockTerminalInitializationListener)this.project.getMessageBus().syncPublisher(BlockTerminalInitializationListener.Companion.getTOPIC())).modelsInitialized(it.getPromptView().getController().getModel(), it.getOutputView().getController().getOutputModel());
        return blockTerminalView;
    }

    public void writePlainMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public void setCursorVisible(boolean visible) {
    }

    public boolean hasFocus() {
        return this.view.isFocused();
    }

    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.getPreferredFocusableComponent(), true);
    }

    public void addNotification(@NotNull JComponent notificationComponent, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)notificationComponent, (String)"notificationComponent");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
    }

    public void sendCommandToExecute(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        this.view.sendCommandToExecute(shellCommand);
    }

    @NotNull
    public CharSequence getText() {
        return this.view.getText();
    }

    public boolean isCommandRunning() {
        TtyConnector ttyConnector = this.getTtyConnector();
        if (ttyConnector == null) {
            return false;
        }
        TtyConnector connector = ttyConnector;
        return TerminalUtil.hasRunningCommands(connector);
    }

    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.view.addTerminationCallback(onTerminated, parentDisposable);
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.wrapper;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.view.getPreferredFocusableComponent();
    }

    @Nullable
    public TerminalSession getSession() {
        return null;
    }

    public void connectToSession(@NotNull TerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        throw new IllegalStateException("connectToSession is not supported in TerminalWidgetImpl, use connectToTty instead".toString());
    }

    @NotNull
    public CompletableFuture<TermSize> getTerminalSizeInitializedFuture() {
        throw new IllegalStateException("getTerminalSizeInitializedFuture is not supported in TerminalWidgetImpl".toString());
    }

    private static final TermSize initialize$lambda$0(Function1 $tmp0, Object p0) {
        return (TermSize)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ TerminalContentView access$getView$p(TerminalWidgetImpl $this) {
        return $this.view;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0001J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0001J\b\u0010&\u001a\u00020\u0012H\u0016R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/terminal/block/TerminalWidgetImpl$TerminalPlaceholder;", "Lorg/jetbrains/plugins/terminal/block/TerminalContentView;", "<init>", "()V", "postponedTerminationCallbackInfos", "", "Lkotlin/Pair;", "Ljava/lang/Runnable;", "Lcom/intellij/openapi/Disposable;", "postponedShellCommands", "", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferredFocusableComponent", "getPreferredFocusableComponent", "connectToTty", "", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "Lcom/jediterm/core/util/TermSize;", "getTerminalSize", "getTerminalSizeInitializedFuture", "Ljava/util/concurrent/CompletableFuture;", "isFocused", "", "addTerminationCallback", "onTerminated", "parentDisposable", "sendCommandToExecute", "shellCommand", "getText", "", "moveTerminationCallbacksTo", "destView", "executePostponedShellCommands", "dispose", "intellij.terminal"})
    private static final class TerminalPlaceholder
    implements TerminalContentView {
        @NotNull
        private final List<Pair<Runnable, Disposable>> postponedTerminationCallbackInfos = new CopyOnWriteArrayList();
        @NotNull
        private final List<String> postponedShellCommands = new CopyOnWriteArrayList();
        @NotNull
        private final JComponent component = new JPanel(){
            {
                this.setBackground((Color)TerminalUi.INSTANCE.defaultBackgroundLazy());
            }
        };
        @NotNull
        private final JComponent preferredFocusableComponent = this.getComponent();

        @Override
        @NotNull
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        @NotNull
        public JComponent getPreferredFocusableComponent() {
            return this.preferredFocusableComponent;
        }

        @Override
        public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
            Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
            Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
            throw new IllegalStateException("Unexpected method call".toString());
        }

        @Override
        @Nullable
        public TermSize getTerminalSize() {
            return null;
        }

        @Override
        @NotNull
        public CompletableFuture<?> getTerminalSizeInitializedFuture() {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }

        @Override
        public boolean isFocused() {
            return false;
        }

        @Override
        public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.postponedTerminationCallbackInfos.add((Pair<Runnable, Disposable>)new Pair((Object)onTerminated, (Object)parentDisposable));
        }

        @Override
        public void sendCommandToExecute(@NotNull String shellCommand) {
            Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
            this.postponedShellCommands.add(shellCommand);
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return "";
        }

        public final void moveTerminationCallbacksTo(@NotNull TerminalContentView destView) {
            Intrinsics.checkNotNullParameter((Object)destView, (String)"destView");
            for (Pair<Runnable, Disposable> info : this.postponedTerminationCallbackInfos) {
                destView.addTerminationCallback((Runnable)info.getFirst(), (Disposable)info.getSecond());
            }
            this.postponedTerminationCallbackInfos.clear();
        }

        public final void executePostponedShellCommands(@NotNull TerminalContentView destView) {
            Intrinsics.checkNotNullParameter((Object)destView, (String)"destView");
            for (String shellCommand : this.postponedShellCommands) {
                destView.sendCommandToExecute(shellCommand);
            }
            this.postponedShellCommands.clear();
        }

        public void dispose() {
            this.postponedTerminationCallbackInfos.clear();
        }
    }
}

