/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.jetbrains.python.packaging.PyPackageVersionNormalizer;
import com.jetbrains.python.requirements.EnvironmentMarkersKt;
import com.jetbrains.python.requirements.Logical;
import com.jetbrains.python.requirements.PackageUtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J\u001e\u0010\u000e\u001a\u00020\t2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/requirements/Expression;", "Lcom/jetbrains/python/requirements/Logical;", "variable", "", "operation", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "isVersion", "", "()Z", "checkVersion", "actual", "checkOther", "check", "values", "", "intellij.python.community.impl"})
public final class Expression
implements Logical {
    @NotNull
    private final String variable;
    @NotNull
    private final String operation;
    @NotNull
    private final String value;

    public Expression(@NotNull String variable, @NotNull String operation, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.variable = variable;
        this.operation = operation;
        this.value = value;
    }

    private final boolean isVersion() {
        return EnvironmentMarkersKt.getVERSION_VARIABLES().contains(this.variable);
    }

    private final boolean checkVersion(String actual, String value) {
        return PackageUtilsKt.compareVersions(PyPackageVersionNormalizer.normalize(actual), this.operation, PyPackageVersionNormalizer.normalize(value));
    }

    private final boolean checkOther(String actual, String value) {
        if (Intrinsics.areEqual((Object)this.operation, (Object)"===")) {
            return Intrinsics.areEqual((Object)actual, (Object)value);
        }
        String string = this.operation;
        return Intrinsics.areEqual((Object)string, (Object)"==") ? Intrinsics.areEqual((Object)actual, (Object)value) : (Intrinsics.areEqual((Object)string, (Object)"!=") ? !Intrinsics.areEqual((Object)actual, (Object)value) : false);
    }

    @Override
    public boolean check(@NotNull Map<String, String> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        String string = values.get(this.variable);
        if (string == null) {
            return false;
        }
        String actual = string;
        return this.isVersion() ? this.checkVersion(actual, this.value) : this.checkOther(actual, this.value);
    }
}

