/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.quickfix.RemoveUnnecessaryBackslashQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementEffectFunctionCallQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.statement.effect", new Object[0]);
        if (string == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(3);
        }
        if (element instanceof PyReferenceExpression) {
            String expressionText = element.getText();
            if ("print".equals(expressionText)) {
                StatementEffectFunctionCallQuickFix.replacePrint(element);
            } else if ("exec".equals(expressionText)) {
                StatementEffectFunctionCallQuickFix.replaceExec(element);
            } else {
                element.replace((PsiElement)PyElementGenerator.getInstance(project).createCallExpression(LanguageLevel.forElement((PsiElement)element), expressionText));
            }
        }
    }

    private static void replaceExec(@NotNull PsiElement expression) {
        if (expression == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(4);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(expression.getProject());
        String expressionText = expression.getText();
        StringBuilder stringBuilder = new StringBuilder(expressionText + " (");
        PsiElement next = StatementEffectFunctionCallQuickFix.getNextElement(expression);
        if (next == null) {
            stringBuilder.append(")");
            expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)expression), PyElement.class, stringBuilder.toString()));
            return;
        }
        String commentText = StatementEffectFunctionCallQuickFix.getComment(next);
        if (next instanceof PyExpressionStatement) {
            PyExpression expr = ((PyExpressionStatement)next).getExpression();
            if (expr instanceof PyBinaryExpression) {
                PsiElement operator = ((PyBinaryExpression)expr).getPsiOperator();
                if (operator instanceof LeafPsiElement && ((LeafPsiElement)operator).getElementType() == PyTokenTypes.IN_KEYWORD) {
                    StatementEffectFunctionCallQuickFix.addInArguments(stringBuilder, (PyBinaryExpression)expr);
                } else {
                    stringBuilder.append(next.getText());
                }
            } else if (expr instanceof PyTupleExpression) {
                PyExpression[] elements = ((PyTupleExpression)expr).getElements();
                if (elements.length > 1) {
                    if (elements[0] instanceof PyBinaryExpression) {
                        StatementEffectFunctionCallQuickFix.addInArguments(stringBuilder, (PyBinaryExpression)elements[0]);
                    }
                    stringBuilder.append(", ");
                    stringBuilder.append(elements[1].getText());
                }
            } else {
                stringBuilder.append(((PyExpressionStatement)next).getExpression().getText());
            }
        } else {
            stringBuilder.append(next.getText());
        }
        next.delete();
        stringBuilder.append(")");
        if (commentText != null) {
            stringBuilder.append(commentText);
        }
        expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)expression), PyStatement.class, stringBuilder.toString()));
    }

    private static String getComment(@Nullable PsiElement next) {
        PsiElement lastChild;
        String commentText = null;
        if (next != null && (lastChild = next.getLastChild()) instanceof PsiComment) {
            commentText = lastChild.getText();
        }
        return commentText;
    }

    private static void addInArguments(@NotNull StringBuilder stringBuilder, @NotNull PyBinaryExpression binaryExpression) {
        if (stringBuilder == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(5);
        }
        if (binaryExpression == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(6);
        }
        stringBuilder.append(binaryExpression.getLeftExpression().getText());
        stringBuilder.append(", ");
        PyExpression rightExpression = binaryExpression.getRightExpression();
        if (rightExpression != null) {
            stringBuilder.append(rightExpression.getText());
        }
    }

    private static void replacePrint(@NotNull PsiElement expression) {
        if (expression == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(7);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(expression.getProject());
        String expressionText = expression.getText();
        StringBuilder stringBuilder = new StringBuilder(expressionText + " (");
        PsiElement next = StatementEffectFunctionCallQuickFix.getNextElement(expression);
        String commentText = StatementEffectFunctionCallQuickFix.getComment(next);
        if (next != null) {
            String text = next instanceof PyExpressionStatement ? ((PyExpressionStatement)next).getExpression().getText() : next.getText();
            stringBuilder.append(text);
            if (text.endsWith(",")) {
                stringBuilder.append(" end=' '");
            }
            next.delete();
        }
        stringBuilder.append(")");
        if (commentText != null) {
            stringBuilder.append(commentText);
        }
        expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)expression), PyStatement.class, stringBuilder.toString()));
    }

    private static PsiElement getNextElement(@NotNull PsiElement expression) {
        if (expression == null) {
            StatementEffectFunctionCallQuickFix.$$$reportNull$$$0(8);
        }
        PsiElement whiteSpace = expression.getContainingFile().findElementAt(expression.getTextOffset() + expression.getTextLength());
        PsiElement next = null;
        if (whiteSpace instanceof PsiWhiteSpace) {
            String whiteSpaceText = whiteSpace.getText();
            if (!whiteSpaceText.contains("\n")) {
                next = whiteSpace.getNextSibling();
                while (next instanceof PsiWhiteSpace && whiteSpaceText.contains("\\")) {
                    next = next.getNextSibling();
                }
            }
        } else {
            next = whiteSpace;
        }
        RemoveUnnecessaryBackslashQuickFix.removeBackSlash(next);
        if (whiteSpace != null) {
            whiteSpace.delete();
        }
        return next;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/StatementEffectFunctionCallQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceExec";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInArguments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replacePrint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNextElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

