/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.stubs.serializers;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/stubs/serializers/JSFileStubSerializer;", "Lcom/intellij/psi/stubs/StubSerializer;", "Lcom/intellij/lang/javascript/psi/stubs/impl/JSFileStubImpl;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getExternalId", "", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "intellij.javascript.psi.impl"})
public final class JSFileStubSerializer
implements StubSerializer<JSFileStubImpl> {
    @NotNull
    private final Language language;

    public JSFileStubSerializer(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.language = language;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public String getExternalId() {
        return this.language + ":FILE";
    }

    public void serialize(@NotNull JSFileStubImpl stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)((Object)stub), (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getFileElementType().getLanguage().getID());
        JSFileCachedData cachedData = stub.getCachedData();
        if (cachedData == null) {
            JSFile file = (JSFile)stub.getPsi();
            if (file instanceof JSFileBaseImpl) {
                cachedData = ((JSFileBaseImpl)file).getCachedData();
            } else {
                cachedData = new JSFileCachedData();
                if (file != null) {
                    cachedData.applyModuleStatus(file.getModuleStatus());
                    cachedData.setTestFileType(file.getTestFileType());
                    if (file.hasES6Syntax()) {
                        cachedData.setHasES6Syntax();
                    }
                    if (file.hasJSXSyntax()) {
                        cachedData.setHasJSXSyntax();
                    }
                    if (file.mayHaveTests()) {
                        cachedData.setMayHaveTests();
                    }
                    cachedData.setPragmaFlags(file.getPragmaFlags());
                }
            }
        }
        cachedData.serialize(dataStream);
        Set<String> set = stub.getReferencedPaths();
        if (set == null) {
            JSFile jSFile = (JSFile)stub.getPsi();
            set = jSFile != null ? jSFile.getReferencedPaths() : null;
            if (set == null) {
                set = SetsKt.emptySet();
            }
        }
        Set<String> referencedPaths = set;
        JSFileCachedData.serializeStringSet(referencedPaths, dataStream);
    }

    @NotNull
    public JSFileStubImpl deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        String languageId = dataStream.readNameString();
        JSFileCachedData cachedData = JSFileCachedData.deserialize(dataStream);
        Set<String> set = JSFileCachedData.deserializeStringSet(dataStream);
        Intrinsics.checkNotNullExpressionValue(set, (String)"deserializeStringSet(...)");
        Set<String> referencedPaths = set;
        return new JSFileStubImpl(Language.findLanguageByID((String)languageId), cachedData, referencedPaths);
    }

    public void indexStub(@NotNull JSFileStubImpl stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)((Object)stub), (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }
}

