/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jna.platform.win32.Kernel32;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmNodePackage
extends NodePackage {
    public NpmNodePackage(@NotNull String path2) {
        if (path2 == null) {
            NpmNodePackage.$$$reportNull$$$0(0);
        }
        super(path2);
    }

    @Override
    @NlsSafe
    @NotNull
    public String getName() {
        String systemIndependentPath = this.getSystemIndependentPath();
        if (StringUtil.isEmptyOrSpaces((String)systemIndependentPath)) {
            return "";
        }
        String directoryPackageName = this.getPackageNameFromDirectory(systemIndependentPath);
        return directoryPackageName != null ? directoryPackageName : NpmNodePackage.getPackageNameFromFile(systemIndependentPath);
    }

    @Nullable
    private String getPackageNameFromDirectory(@NotNull String systemIndependentPath) {
        if (systemIndependentPath == null) {
            NpmNodePackage.$$$reportNull$$$0(1);
        }
        String name = super.getName();
        if (systemIndependentPath.endsWith("/") || systemIndependentPath.endsWith("/node_modules/" + PathUtil.toSystemIndependentName((String)name))) {
            return name;
        }
        return null;
    }

    @NotNull
    private static String getPackageNameFromFile(@NotNull String systemIndependentPath) {
        if (systemIndependentPath == null) {
            NpmNodePackage.$$$reportNull$$$0(2);
        }
        String fileName = PathUtil.getFileName((String)systemIndependentPath);
        if (SystemInfo.isWindows && !NpmNodePackage.isAbsoluteUnixFilePath(systemIndependentPath)) {
            String string = FileUtilRt.getNameWithoutExtension((String)fileName);
            if (string == null) {
                NpmNodePackage.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = fileName;
        if (string == null) {
            NpmNodePackage.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isValid(@Nullable Project project, @Nullable NodeJsInterpreter interpreter2) {
        if (StringUtil.isEmptyOrSpaces((String)this.getSystemIndependentPath())) {
            return false;
        }
        if (interpreter2 instanceof WslNodeInterpreter) {
            return this.getWslFileKind((WslNodeInterpreter)interpreter2) != null;
        }
        if (interpreter2 instanceof NodeJsRemoteInterpreter) {
            return true;
        }
        return this.isValidLocalFileOrDirectory();
    }

    private boolean isValidLocalFileOrDirectory() {
        return NpmNodePackage.getLocalFileKind(this.getSystemDependentPath()) != null;
    }

    @Override
    @Nullable
    public String validateAndGetErrorMessage(@NotNull String packageName, @Nullable Project project, @Nullable NodeJsInterpreter interpreter2) {
        if (packageName == null) {
            NpmNodePackage.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getSystemDependentPath())) {
            return JavaScriptBundle.message("dialog.message.unspecified.package", packageName);
        }
        if (!this.isValid(project, interpreter2)) {
            return JavaScriptBundle.message("dialog.message.invalid.npm.package", packageName);
        }
        return null;
    }

    @Override
    @NotNull
    public String getPresentablePath() {
        if (SystemInfo.isWindows && NpmNodePackage.isAbsoluteUnixFilePath(this.getSystemIndependentPath())) {
            String string = this.getSystemIndependentPath();
            if (string == null) {
                NpmNodePackage.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = super.getPresentablePath();
        if (string == null) {
            NpmNodePackage.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    static FileKind getLocalFileKind(@NotNull String localFilePath) {
        Path path2;
        if (localFilePath == null) {
            NpmNodePackage.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)localFilePath)) {
            return null;
        }
        try {
            path2 = Path.of(localFilePath, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
        if (!path2.isAbsolute() || !Files.exists(path2, new LinkOption[0])) {
            return null;
        }
        return Files.isDirectory(path2, new LinkOption[0]) ? FileKind.DIRECTORY : FileKind.FILE;
    }

    @Nullable
    private FileKind getWslFileKind(@NotNull WslNodeInterpreter interpreter2) {
        if (interpreter2 == null) {
            NpmNodePackage.$$$reportNull$$$0(9);
        }
        return NpmNodePackage.getWslFileKind(NpmUtil.getWslLinuxPath(interpreter2, this), interpreter2);
    }

    @Nullable
    static FileKind getWslFileKind(@NotNull String linuxFilePath, @NotNull WslNodeInterpreter interpreter2) {
        if (linuxFilePath == null) {
            NpmNodePackage.$$$reportNull$$$0(10);
        }
        if (interpreter2 == null) {
            NpmNodePackage.$$$reportNull$$$0(11);
        }
        if (NpmNodePackage.isAbsoluteUnixFilePath(linuxFilePath)) {
            String windowsFilePath = interpreter2.getDistribution().getWindowsPath(linuxFilePath);
            FileAttributes attrs = FileSystemUtil.getAttributes((String)windowsFilePath);
            if (attrs != null) {
                return attrs.isDirectory() ? FileKind.DIRECTORY : FileKind.FILE;
            }
            int systemAttrs = Kernel32.INSTANCE.GetFileAttributes(windowsFilePath);
            if (systemAttrs != -1) {
                String parentDirName = PathUtil.getFileName((String)PathUtil.getParentPath((String)windowsFilePath));
                return NodeModulesDirectoryManager.isNodeModulesDirName(parentDirName) ? FileKind.DIRECTORY : FileKind.FILE;
            }
        }
        return null;
    }

    private static boolean isAbsoluteUnixFilePath(@NotNull String unixFilePath) {
        if (unixFilePath == null) {
            NpmNodePackage.$$$reportNull$$$0(12);
        }
        return unixFilePath.startsWith("/") && !unixFilePath.startsWith("//");
    }

    @Nullable
    private FileKind getFileKind(@NotNull NodeJsInterpreter interpreter2) {
        if (interpreter2 == null) {
            NpmNodePackage.$$$reportNull$$$0(13);
        }
        if (interpreter2 instanceof NodeJsLocalInterpreter) {
            return NpmNodePackage.getLocalFileKind(this.getSystemDependentPath());
        }
        if (interpreter2 instanceof WslNodeInterpreter) {
            return this.getWslFileKind((WslNodeInterpreter)interpreter2);
        }
        if (interpreter2 instanceof NodeJsRemoteInterpreter) {
            return NpmNodePackage.getRemoteFileKind(this.getSystemIndependentPath());
        }
        return null;
    }

    @NotNull
    private static FileKind getRemoteFileKind(@NotNull String npmPkgPath) {
        if (npmPkgPath == null) {
            NpmNodePackage.$$$reportNull$$$0(14);
        }
        if (npmPkgPath.endsWith("/")) {
            FileKind fileKind = FileKind.DIRECTORY;
            if (fileKind == null) {
                NpmNodePackage.$$$reportNull$$$0(15);
            }
            return fileKind;
        }
        if (PathUtil.getFileName((String)PathUtil.getParentPath((String)npmPkgPath)).equals("node_modules")) {
            FileKind fileKind = FileKind.DIRECTORY;
            if (fileKind == null) {
                NpmNodePackage.$$$reportNull$$$0(16);
            }
            return fileKind;
        }
        if (npmPkgPath.equals("/usr/share/yarn") || PathUtil.getParentPath((String)npmPkgPath).equals("/opt")) {
            FileKind fileKind = FileKind.DIRECTORY;
            if (fileKind == null) {
                NpmNodePackage.$$$reportNull$$$0(17);
            }
            return fileKind;
        }
        FileKind fileKind = FileKind.FILE;
        if (fileKind == null) {
            NpmNodePackage.$$$reportNull$$$0(18);
        }
        return fileKind;
    }

    public void configureNpmPackage(@NotNull NodeTargetRun targetRun, String ... args) throws ExecutionException {
        NodeJsInterpreter interpreter2;
        FileKind fileKind;
        if (targetRun == null) {
            NpmNodePackage.$$$reportNull$$$0(19);
        }
        if ((fileKind = this.getFileKind(interpreter2 = targetRun.getInterpreter())) == null) {
            String pkgName = StringUtil.notNullize((String)StringUtil.nullize((String)this.getName().trim()), (String)"npm/yarn/pnpm");
            throw new ExecutionException(JavaScriptBundle.message("dialog.message.invalid.npm.package", pkgName));
        }
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        if (fileKind == FileKind.FILE) {
            String exeFilePath = this.getExeFilePath(interpreter2);
            if (NpmNodePackage.isJavaScriptFile(exeFilePath)) {
                NpmNodePackage.configureMainJsFile(targetRun, exeFilePath, args);
            } else {
                commandLineBuilder.setExePath(exeFilePath);
                commandLineBuilder.addFixedParametersAt(0, List.of(args));
            }
        } else {
            NpmNodePackage.configurePackageDir(targetRun, this, args);
        }
    }

    private void configureNpmPackage(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter interpreter2) throws ExecutionException {
        FileKind fileKind;
        if (commandLine == null) {
            NpmNodePackage.$$$reportNull$$$0(20);
        }
        if (interpreter2 == null) {
            NpmNodePackage.$$$reportNull$$$0(21);
        }
        if ((fileKind = this.getFileKind(interpreter2)) == null) {
            String pkgName = StringUtil.notNullize((String)StringUtil.nullize((String)this.getName().trim()), (String)"npm/yarn/pnpm");
            throw new ExecutionException(JavaScriptBundle.message("dialog.message.invalid.npm.package", pkgName));
        }
        if (fileKind == FileKind.FILE) {
            String exeFilePath = this.getExeFilePath(interpreter2);
            if (NpmNodePackage.isJavaScriptFile(exeFilePath)) {
                NpmNodePackage.configureMainJsFile(commandLine, exeFilePath);
            } else {
                commandLine.setExePath(exeFilePath);
                NodeCommandLineConfigurator.markExePathAsSet(commandLine);
                NodeCommandLineUtil.prependNodeDirToPATH(commandLine, interpreter2);
            }
        } else {
            NpmNodePackage.configurePackageDir(commandLine, interpreter2, this);
        }
    }

    static boolean isJavaScriptFile(@NotNull String exeFilePath) {
        if (exeFilePath == null) {
            NpmNodePackage.$$$reportNull$$$0(22);
        }
        return exeFilePath.endsWith(".js") || exeFilePath.endsWith(".cjs");
    }

    private static void configurePackageDir(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPkg) throws ExecutionException {
        if (commandLine == null) {
            NpmNodePackage.$$$reportNull$$$0(23);
        }
        if (interpreter2 == null) {
            NpmNodePackage.$$$reportNull$$$0(24);
        }
        if (npmPkg == null) {
            NpmNodePackage.$$$reportNull$$$0(25);
        }
        NpmNodePackage.configureMainJsFile(commandLine, NpmUtil.getValidNpmCliJsFilePath(npmPkg, interpreter2));
    }

    private static void configureMainJsFile(@NotNull GeneralCommandLine commandLine, @NotNull String mainJsFilePath) {
        if (commandLine == null) {
            NpmNodePackage.$$$reportNull$$$0(26);
        }
        if (mainJsFilePath == null) {
            NpmNodePackage.$$$reportNull$$$0(27);
        }
        NpmNodePackage.addParametersAt(commandLine, 0, List.of(mainJsFilePath));
    }

    private static void addParametersAt(@NotNull GeneralCommandLine commandLine, int index, @NotNull List<String> params) {
        if (commandLine == null) {
            NpmNodePackage.$$$reportNull$$$0(28);
        }
        if (params == null) {
            NpmNodePackage.$$$reportNull$$$0(29);
        }
        int i = 0;
        for (String param : params) {
            commandLine.getParametersList().addAt(index + i++, param);
        }
    }

    @NotNull
    private String getExeFilePath(@NotNull NodeJsInterpreter interpreter2) {
        if (interpreter2 == null) {
            NpmNodePackage.$$$reportNull$$$0(30);
        }
        if (interpreter2 instanceof WslNodeInterpreter) {
            String string = NpmUtil.getWslLinuxPath((WslNodeInterpreter)interpreter2, this);
            if (string == null) {
                NpmNodePackage.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = interpreter2 instanceof NodeJsRemoteInterpreter ? this.getSystemIndependentPath() : this.getSystemDependentPath();
        if (string == null) {
            NpmNodePackage.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static void configurePackageDir(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg, String[] args) throws ExecutionException {
        if (targetRun == null) {
            NpmNodePackage.$$$reportNull$$$0(33);
        }
        if (npmPkg == null) {
            NpmNodePackage.$$$reportNull$$$0(34);
        }
        NpmNodePackage.configureMainJsFile(targetRun, NpmUtil.getValidNpmCliJsFilePath(npmPkg, targetRun.getInterpreter()), args);
    }

    private static void configureMainJsFile(@NotNull NodeTargetRun targetRun, @NotNull String mainJsFilePath, String[] args) {
        if (targetRun == null) {
            NpmNodePackage.$$$reportNull$$$0(35);
        }
        if (mainJsFilePath == null) {
            NpmNodePackage.$$$reportNull$$$0(36);
        }
        targetRun.getCommandLineBuilder().addFixedParametersAt(0, ContainerUtil.concat(List.of(mainJsFilePath), List.of(args)));
    }

    public static void configureNpmPackage(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg, String ... args) throws ExecutionException {
        if (targetRun == null) {
            NpmNodePackage.$$$reportNull$$$0(37);
        }
        if (npmPkg == null) {
            NpmNodePackage.$$$reportNull$$$0(38);
        }
        if (npmPkg instanceof NpmNodePackage) {
            ((NpmNodePackage)npmPkg).configureNpmPackage(targetRun, args);
        } else {
            NpmNodePackage.configurePackageDir(targetRun, npmPkg, args);
        }
    }

    @Deprecated
    public static void configureNpmPackage(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPkg) throws ExecutionException {
        if (commandLine == null) {
            NpmNodePackage.$$$reportNull$$$0(39);
        }
        if (interpreter2 == null) {
            NpmNodePackage.$$$reportNull$$$0(40);
        }
        if (npmPkg == null) {
            NpmNodePackage.$$$reportNull$$$0(41);
        }
        if (npmPkg instanceof NpmNodePackage) {
            ((NpmNodePackage)npmPkg).configureNpmPackage(commandLine, interpreter2);
        } else {
            NpmNodePackage.configurePackageDir(commandLine, interpreter2, npmPkg);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 15, 16, 17, 18, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemIndependentPath";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmNodePackage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFilePath";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 24: 
            case 30: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linuxFilePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unixFilePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkgPath";
                break;
            }
            case 19: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeFilePath";
                break;
            }
            case 25: 
            case 34: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainJsFilePath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmNodePackage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNameFromFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteFileKind";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExeFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameFromDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameFromFile";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 31: 
            case 32: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateAndGetErrorMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFileKind";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWslFileKind";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAbsoluteUnixFilePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileKind";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteFileKind";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "configureNpmPackage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScriptFile";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "configurePackageDir";
                break;
            }
            case 26: 
            case 27: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "configureMainJsFile";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addParametersAt";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExeFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 15, 16, 17, 18, 31, 32 -> new IllegalStateException(string);
        };
    }

    static enum FileKind {
        DIRECTORY,
        FILE;

    }
}

